/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.ExecuteWatchdog;
import org.apache.tools.ant.taskdefs.Redirector;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileUtils;

public class ExecTask
extends Task {
    private String os;
    private File dir;
    protected boolean failOnError = false;
    protected boolean newEnvironment = false;
    private Long timeout = null;
    private Environment env = new Environment();
    protected Commandline cmdl = new Commandline();
    private String resultProperty;
    private boolean failIfExecFails = true;
    private String executable;
    private boolean resolveExecutable = false;
    private boolean spawn = false;
    private boolean incompatibleWithSpawn = false;
    private Redirector redirector = new Redirector(this);
    private boolean vmLauncher = true;

    public void setSpawn(boolean spawn) {
        this.spawn = spawn;
    }

    public void setTimeout(Long value) {
        this.timeout = value;
        this.incompatibleWithSpawn = true;
    }

    public void setTimeout(Integer value) {
        if (value == null) {
            this.timeout = null;
        } else {
            this.setTimeout(new Long(value.intValue()));
        }
        this.incompatibleWithSpawn = true;
    }

    public void setExecutable(String value) {
        this.executable = value;
        this.cmdl.setExecutable(value);
    }

    public void setDir(File d) {
        this.dir = d;
    }

    public void setOs(String os) {
        this.os = os;
    }

    public void setCommand(Commandline cmdl) {
        this.log("The command attribute is deprecated. Please use the executable attribute and nested arg elements.", 1);
        this.cmdl = cmdl;
    }

    public void setOutput(File out) {
        this.redirector.setOutput(out);
        this.incompatibleWithSpawn = true;
    }

    public void setInput(File input) {
        this.redirector.setInput(input);
        this.incompatibleWithSpawn = true;
    }

    public void setInputString(String inputString) {
        this.redirector.setInputString(inputString);
        this.incompatibleWithSpawn = true;
    }

    public void setLogError(boolean logError) {
        this.redirector.setLogError(logError);
        this.incompatibleWithSpawn = true;
    }

    public void setError(File error) {
        this.redirector.setError(error);
        this.incompatibleWithSpawn = true;
    }

    public void setOutputproperty(String outputProp) {
        this.redirector.setOutputProperty(outputProp);
        this.incompatibleWithSpawn = true;
    }

    public void setErrorProperty(String errorProperty) {
        this.redirector.setErrorProperty(errorProperty);
        this.incompatibleWithSpawn = true;
    }

    public void setFailonerror(boolean fail) {
        this.failOnError = fail;
        this.incompatibleWithSpawn = true;
    }

    public void setNewenvironment(boolean newenv) {
        this.newEnvironment = newenv;
    }

    public void setResolveExecutable(boolean resolveExecutable) {
        this.resolveExecutable = resolveExecutable;
    }

    public boolean getResolveExecutable() {
        return this.resolveExecutable;
    }

    public void addEnv(Environment.Variable var) {
        this.env.addVariable(var);
    }

    public Commandline.Argument createArg() {
        return this.cmdl.createArgument();
    }

    public void setResultProperty(String resultProperty) {
        this.resultProperty = resultProperty;
        this.incompatibleWithSpawn = true;
    }

    protected void maybeSetResultPropertyValue(int result) {
        String res = Integer.toString(result);
        if (this.resultProperty != null) {
            this.getProject().setNewProperty(this.resultProperty, res);
        }
    }

    public void setFailIfExecutionFails(boolean flag) {
        this.failIfExecFails = flag;
        this.incompatibleWithSpawn = true;
    }

    public void setAppend(boolean append) {
        this.redirector.setAppend(append);
        this.incompatibleWithSpawn = true;
    }

    protected String resolveExecutable(String exec, boolean searchPath) {
        if (!this.resolveExecutable) {
            return exec;
        }
        File executableFile = this.getProject().resolveFile(exec);
        if (executableFile.exists()) {
            return executableFile.getAbsolutePath();
        }
        FileUtils fileUtils = FileUtils.newFileUtils();
        if (this.dir != null && (executableFile = fileUtils.resolveFile(this.dir, exec)).exists()) {
            return executableFile.getAbsolutePath();
        }
        if (searchPath) {
            Vector env = Execute.getProcEnvironment();
            Enumeration e = env.elements();
            Path p = null;
            while (e.hasMoreElements()) {
                String line = (String)e.nextElement();
                if (!line.startsWith("PATH=") && !line.startsWith("Path=")) continue;
                p = new Path(this.getProject(), line.substring(5));
                break;
            }
            if (p != null) {
                String[] dirs = p.list();
                for (int i = 0; i < dirs.length; ++i) {
                    executableFile = fileUtils.resolveFile(new File(dirs[i]), exec);
                    if (!executableFile.exists()) continue;
                    return executableFile.getAbsolutePath();
                }
            }
        }
        return exec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        File savedDir = this.dir;
        this.cmdl.setExecutable(this.resolveExecutable(this.executable, false));
        this.checkConfiguration();
        if (this.isValidOs()) {
            try {
                this.runExec(this.prepareExec());
            }
            finally {
                this.dir = savedDir;
            }
        }
    }

    protected void checkConfiguration() throws BuildException {
        if (this.cmdl.getExecutable() == null) {
            throw new BuildException("no executable specified", this.getLocation());
        }
        if (this.dir != null && !this.dir.exists()) {
            throw new BuildException("The directory you specified does not exist");
        }
        if (this.dir != null && !this.dir.isDirectory()) {
            throw new BuildException("The directory you specified is not a directory");
        }
        if (this.spawn && this.incompatibleWithSpawn) {
            this.getProject().log("spawn does not allow attributes related to input, output, error, result", 0);
            this.getProject().log("spawn does not also not allow timeout", 0);
            throw new BuildException("You have used an attribute which is not compatible with spawn");
        }
    }

    protected boolean isValidOs() {
        String myos = System.getProperty("os.name");
        this.log("Current OS is " + myos, 3);
        if (this.os != null && this.os.indexOf(myos) < 0) {
            this.log("This OS, " + myos + " was not found in the specified list of valid OSes: " + this.os, 3);
            return false;
        }
        return true;
    }

    public void setVMLauncher(boolean vmLauncher) {
        this.vmLauncher = vmLauncher;
    }

    protected Execute prepareExec() throws BuildException {
        if (this.dir == null) {
            this.dir = this.getProject().getBaseDir();
        }
        Execute exe = new Execute(this.createHandler(), this.createWatchdog());
        exe.setAntRun(this.getProject());
        exe.setWorkingDirectory(this.dir);
        exe.setVMLauncher(this.vmLauncher);
        exe.setSpawn(this.spawn);
        String[] environment = this.env.getVariables();
        if (environment != null) {
            for (int i = 0; i < environment.length; ++i) {
                this.log("Setting environment variable: " + environment[i], 3);
            }
        }
        exe.setNewenvironment(this.newEnvironment);
        exe.setEnvironment(environment);
        return exe;
    }

    protected final void runExecute(Execute exe) throws IOException {
        int returnCode = -1;
        if (!this.spawn) {
            returnCode = exe.execute();
            if (exe.killedProcess()) {
                String msg = "Timeout: killed the sub-process";
                if (this.failOnError) {
                    throw new BuildException(msg);
                }
                this.log(msg, 1);
            }
            this.maybeSetResultPropertyValue(returnCode);
            if (Execute.isFailure(returnCode)) {
                if (this.failOnError) {
                    throw new BuildException(this.getTaskType() + " returned: " + returnCode, this.getLocation());
                }
                this.log("Result: " + returnCode, 0);
            }
            this.redirector.complete();
        } else {
            exe.spawn();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runExec(Execute exe) throws BuildException {
        this.log(this.cmdl.describeCommand(), 3);
        exe.setCommandline(this.cmdl.getCommandline());
        try {
            this.runExecute(exe);
        }
        catch (IOException e) {
            if (this.failIfExecFails) {
                throw new BuildException("Execute failed: " + e.toString(), e, this.getLocation());
            }
            this.log("Execute failed: " + e.toString(), 0);
        }
        finally {
            this.logFlush();
        }
    }

    protected ExecuteStreamHandler createHandler() throws BuildException {
        return this.redirector.createHandler();
    }

    protected ExecuteWatchdog createWatchdog() throws BuildException {
        if (this.timeout == null) {
            return null;
        }
        return new ExecuteWatchdog(this.timeout);
    }

    protected void logFlush() {
    }
}

