/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.filters;

import java.io.IOException;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.filters.BaseFilterReader;
import org.apache.tools.ant.filters.ChainableReader;
import org.apache.tools.ant.types.RegularExpression;
import org.apache.tools.ant.types.Substitution;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.LineTokenizer;
import org.apache.tools.ant.util.Tokenizer;
import org.apache.tools.ant.util.regexp.Regexp;

public class TokenFilter
extends BaseFilterReader
implements ChainableReader {
    private Vector filters = new Vector();
    private Tokenizer tokenizer = null;
    private String delimOutput = null;
    private String line = null;
    private int linePos = 0;

    public TokenFilter() {
    }

    public TokenFilter(Reader in) {
        super(in);
    }

    public int read() throws IOException {
        if (this.tokenizer == null) {
            this.tokenizer = new LineTokenizer();
        }
        while (this.line == null || this.line.length() == 0) {
            this.line = this.tokenizer.getToken(this.in);
            if (this.line == null) {
                return -1;
            }
            Enumeration e = this.filters.elements();
            while (e.hasMoreElements()) {
                Filter filter = (Filter)e.nextElement();
                this.line = filter.filter(this.line);
                if (this.line != null) continue;
                break;
            }
            this.linePos = 0;
            if (this.line == null || this.tokenizer.getPostToken().length() == 0) continue;
            if (this.delimOutput != null) {
                this.line = this.line + this.delimOutput;
                continue;
            }
            this.line = this.line + this.tokenizer.getPostToken();
        }
        char ch = this.line.charAt(this.linePos);
        ++this.linePos;
        if (this.linePos == this.line.length()) {
            this.line = null;
        }
        return ch;
    }

    public final Reader chain(Reader reader) {
        TokenFilter newFilter = new TokenFilter(reader);
        newFilter.filters = this.filters;
        newFilter.tokenizer = this.tokenizer;
        newFilter.delimOutput = this.delimOutput;
        newFilter.setProject(this.getProject());
        return newFilter;
    }

    public void setDelimOutput(String delimOutput) {
        this.delimOutput = TokenFilter.resolveBackSlash(delimOutput);
    }

    public void addLineTokenizer(LineTokenizer tokenizer) {
        this.add(tokenizer);
    }

    public void addStringTokenizer(StringTokenizer tokenizer) {
        this.add(tokenizer);
    }

    public void addFileTokenizer(FileTokenizer tokenizer) {
        this.add(tokenizer);
    }

    public void add(Tokenizer tokenizer) {
        if (this.tokenizer != null) {
            throw new BuildException("Only one tokenizer allowed");
        }
        this.tokenizer = tokenizer;
    }

    public void addReplaceString(ReplaceString filter) {
        this.filters.addElement(filter);
    }

    public void addContainsString(ContainsString filter) {
        this.filters.addElement(filter);
    }

    public void addReplaceRegex(ReplaceRegex filter) {
        this.filters.addElement(filter);
    }

    public void addContainsRegex(ContainsRegex filter) {
        this.filters.addElement(filter);
    }

    public void addTrim(Trim filter) {
        this.filters.addElement(filter);
    }

    public void addIgnoreBlank(IgnoreBlank filter) {
        this.filters.addElement(filter);
    }

    public void addDeleteCharacters(DeleteCharacters filter) {
        this.filters.addElement(filter);
    }

    public void add(Filter filter) {
        this.filters.addElement(filter);
    }

    public static String resolveBackSlash(String input) {
        StringBuffer b = new StringBuffer();
        boolean backSlashSeen = false;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (!backSlashSeen) {
                if (c == '\\') {
                    backSlashSeen = true;
                    continue;
                }
                b.append(c);
                continue;
            }
            switch (c) {
                case '\\': {
                    b.append('\\');
                    break;
                }
                case 'n': {
                    b.append('\n');
                    break;
                }
                case 'r': {
                    b.append('\r');
                    break;
                }
                case 't': {
                    b.append('\t');
                    break;
                }
                case 'f': {
                    b.append('\f');
                    break;
                }
                case 's': {
                    b.append(" \t\n\r\f");
                    break;
                }
                default: {
                    b.append(c);
                }
            }
            backSlashSeen = false;
        }
        return b.toString();
    }

    public static int convertRegexOptions(String flags) {
        if (flags == null) {
            return 0;
        }
        int options = 0;
        if (flags.indexOf(103) != -1) {
            options |= 0x10;
        }
        if (flags.indexOf(105) != -1) {
            options |= 0x100;
        }
        if (flags.indexOf(109) != -1) {
            options |= 0x1000;
        }
        if (flags.indexOf(115) != -1) {
            options |= 0x10000;
        }
        return options;
    }

    public static class DeleteCharacters
    extends ProjectComponent
    implements Filter,
    ChainableReader {
        private String deleteChars = "";

        public void setChars(String deleteChars) {
            this.deleteChars = TokenFilter.resolveBackSlash(deleteChars);
        }

        public String filter(String string) {
            StringBuffer output = new StringBuffer(string.length());
            for (int i = 0; i < string.length(); ++i) {
                char ch = string.charAt(i);
                if (this.isDeleteCharacter(ch)) continue;
                output.append(ch);
            }
            return output.toString();
        }

        public Reader chain(Reader reader) {
            return new BaseFilterReader(this, reader){
                private final /* synthetic */ DeleteCharacters this$0;
                {
                    this.this$0 = this$0;
                }

                public int read() throws IOException {
                    int c;
                    do {
                        if ((c = this.in.read()) != -1) continue;
                        return c;
                    } while (DeleteCharacters.access$000(this.this$0, (char)c));
                    return c;
                }
            };
        }

        private boolean isDeleteCharacter(char c) {
            for (int d = 0; d < this.deleteChars.length(); ++d) {
                if (this.deleteChars.charAt(d) != c) continue;
                return true;
            }
            return false;
        }

        static /* synthetic */ boolean access$000(DeleteCharacters x0, char x1) {
            return x0.isDeleteCharacter(x1);
        }
    }

    public static class IgnoreBlank
    extends ChainableReaderFilter {
        public String filter(String line) {
            if (line.trim().length() == 0) {
                return null;
            }
            return line;
        }
    }

    public static class Trim
    extends ChainableReaderFilter {
        public String filter(String line) {
            return line.trim();
        }
    }

    public static class ContainsRegex
    extends ChainableReaderFilter {
        private String from;
        private String to;
        private Project project;
        private RegularExpression regularExpression;
        private Substitution substitution;
        private boolean initialized = false;
        private String flags = "";
        private int options;
        private Regexp regexp;

        public void setPattern(String from) {
            this.from = from;
        }

        public void setReplace(String to) {
            this.to = to;
        }

        public void setFlags(String flags) {
            this.flags = flags;
        }

        private void initialize() {
            if (this.initialized) {
                return;
            }
            this.options = TokenFilter.convertRegexOptions(this.flags);
            if (this.from == null) {
                throw new BuildException("Missing from in containsregex");
            }
            this.regularExpression = new RegularExpression();
            this.regularExpression.setPattern(this.from);
            this.regexp = this.regularExpression.getRegexp(this.project);
            if (this.to == null) {
                return;
            }
            this.substitution = new Substitution();
            this.substitution.setExpression(this.to);
        }

        public String filter(String string) {
            this.initialize();
            if (!this.regexp.matches(string, this.options)) {
                return null;
            }
            if (this.substitution == null) {
                return string;
            }
            return this.regexp.substitute(string, this.substitution.getExpression(this.getProject()), this.options);
        }
    }

    public static class ReplaceRegex
    extends ChainableReaderFilter {
        private String from;
        private String to;
        private RegularExpression regularExpression;
        private Substitution substitution;
        private boolean initialized = false;
        private String flags = "";
        private int options;
        private Regexp regexp;

        public void setPattern(String from) {
            this.from = from;
        }

        public void setReplace(String to) {
            this.to = to;
        }

        public void setFlags(String flags) {
            this.flags = flags;
        }

        private void initialize() {
            if (this.initialized) {
                return;
            }
            this.options = TokenFilter.convertRegexOptions(this.flags);
            if (this.from == null) {
                throw new BuildException("Missing pattern in replaceregex");
            }
            this.regularExpression = new RegularExpression();
            this.regularExpression.setPattern(this.from);
            this.regexp = this.regularExpression.getRegexp(this.getProject());
            if (this.to == null) {
                this.to = "";
            }
            this.substitution = new Substitution();
            this.substitution.setExpression(this.to);
        }

        public String filter(String line) {
            this.initialize();
            if (!this.regexp.matches(line, this.options)) {
                return line;
            }
            return this.regexp.substitute(line, this.substitution.getExpression(this.getProject()), this.options);
        }
    }

    public static class ContainsString
    extends ProjectComponent
    implements Filter {
        private String contains;

        public void setContains(String contains) {
            this.contains = contains;
        }

        public String filter(String string) {
            if (this.contains == null) {
                throw new BuildException("Missing contains in containsstring");
            }
            if (string.indexOf(this.contains) > -1) {
                return string;
            }
            return null;
        }
    }

    public static class ReplaceString
    extends ChainableReaderFilter {
        private String from;
        private String to;

        public void setFrom(String from) {
            this.from = from;
        }

        public void setTo(String to) {
            this.to = to;
        }

        public String filter(String line) {
            if (this.from == null) {
                throw new BuildException("Missing from in stringreplace");
            }
            StringBuffer ret = new StringBuffer();
            int start = 0;
            int found = line.indexOf(this.from);
            while (found >= 0) {
                if (found > start) {
                    ret.append(line.substring(start, found));
                }
                if (this.to != null) {
                    ret.append(this.to);
                }
                start = found + this.from.length();
                found = line.indexOf(line, start);
            }
            if (line.length() > start) {
                ret.append(line.substring(start, line.length()));
            }
            return ret.toString();
        }
    }

    public static abstract class ChainableReaderFilter
    extends ProjectComponent
    implements ChainableReader,
    Filter {
        private boolean byLine = true;

        public void setByLine(boolean byLine) {
            this.byLine = byLine;
        }

        public Reader chain(Reader reader) {
            TokenFilter tokenFilter = new TokenFilter(reader);
            if (!this.byLine) {
                tokenFilter.add(new FileTokenizer());
            }
            tokenFilter.add(this);
            return tokenFilter;
        }

        public abstract /* synthetic */ String filter(String var1);
    }

    public static class StringTokenizer
    extends ProjectComponent
    implements Tokenizer {
        private String intraString = "";
        private int pushed = -2;
        private char[] delims = null;
        private boolean delimsAreTokens = false;
        private boolean suppressDelims = false;
        private boolean includeDelims = false;

        public void setDelims(String delims) {
            this.delims = TokenFilter.resolveBackSlash(delims).toCharArray();
        }

        public void setDelimsAreTokens(boolean delimsAreTokens) {
            this.delimsAreTokens = delimsAreTokens;
        }

        public void setSuppressDelims(boolean suppressDelims) {
            this.suppressDelims = suppressDelims;
        }

        public void setIncludeDelims(boolean includeDelims) {
            this.includeDelims = includeDelims;
        }

        public String getToken(Reader in) throws IOException {
            int ch = -1;
            if (this.pushed != -2) {
                ch = this.pushed;
                this.pushed = -2;
            } else {
                ch = in.read();
            }
            if (ch == -1) {
                return null;
            }
            boolean inToken = true;
            this.intraString = "";
            StringBuffer word = new StringBuffer();
            StringBuffer padding = new StringBuffer();
            while (ch != -1) {
                char c = (char)ch;
                boolean isDelim = this.isDelim(c);
                if (inToken) {
                    if (isDelim) {
                        if (this.delimsAreTokens) {
                            if (word.length() == 0) {
                                word.append(c);
                                break;
                            }
                            this.pushed = ch;
                            break;
                        }
                        padding.append(c);
                        inToken = false;
                    } else {
                        word.append(c);
                    }
                } else if (isDelim) {
                    padding.append(c);
                } else {
                    this.pushed = ch;
                    break;
                }
                ch = in.read();
            }
            this.intraString = padding.toString();
            if (this.includeDelims) {
                word.append(this.intraString);
            }
            return word.toString();
        }

        public String getPostToken() {
            if (this.suppressDelims || this.includeDelims) {
                return "";
            }
            return this.intraString;
        }

        private boolean isDelim(char ch) {
            if (this.delims == null) {
                return Character.isWhitespace(ch);
            }
            for (int i = 0; i < this.delims.length; ++i) {
                if (this.delims[i] != ch) continue;
                return true;
            }
            return false;
        }
    }

    public static class FileTokenizer
    extends ProjectComponent
    implements Tokenizer {
        public String getToken(Reader in) throws IOException {
            return FileUtils.readFully(in);
        }

        public String getPostToken() {
            return "";
        }
    }

    public static interface Filter {
        public String filter(String var1);
    }
}

