<?
defined('_JEXEC') or die('Restricted access');
class modChatHelper
{		
	function setParams($params)
	{
		modChatHelper::setExtendServer($params->get(extend_chat_server));
		modChatHelper::setClientLocation($params->get(client_location));
		modChatHelper::setClientName($params->get(swfname));
		modChatHelper::setInitHost($params->get(init_host));
		modChatHelper::setInitPort($params->get(init_port));
		modChatHelper::setChatGroup($params->get(init_group));
		modChatHelper::setChatDataPath($params->get(chat_data_path));
	}
	
	
	function setExtendServer($extendserver)
	{
		$this->extendserver = $extendserver;
	}
	
	function setClientLocation($clientlocation)
	{
		$this->clientlocation = $clientlocation;
	}
	
	function setClientName($clientname)
	{
		$this->clientname = $clientname;
	}
	
	function setInitHost($inithost){
		$this->inithost = $inithost;
	}
	
	function setInitPort($initport){
		$this->initport = $initport;
	}
	
	function setChatGroup($chatgroup)
	{
		$this->chatgroup = $chatgroup;
	}
	
	function setChatDataPath($chatdatapath)
	{
		$this->chatdatapath = $chatdatapath;
	}
	
	function chat_getChattersFromLocalServer()
	{
		$room = array();
		$room['connections'] = 0;
		$room['logon_users'] = 0;
		$room['room_numbers'] = 0;
	
		$online_file = $this->chatdatapath."online.txt";

		if (!file_exists($online_file))
		{
			return $room;
		}
	
		if (!$row = file($online_file))
		{
			return $room;
		}
	
		$room_data = explode("|", $row[0]);
	
	
		if (count($room_data) == 3)
		{
			$room['connections'] = 	intval($room_data[0]);
			$room['logon_users'] = 	intval($room_data[1]);
			$room['room_numbers'] = intval($room_data[2]);
		}
		return $room;
	}
	
	function chat_getChattersFromExtendServer()
	{
		$room = array();
	
		$room['connections'] = "<script lanauge=javascript src='".$this->clientlocation."connections.php'></script>";
		$room['logon_users'] = "<script lanauge=javascript src='".$this->clientlocation."logon_users.php'></script>";
		$room['room_numbers'] = "<script lanauge=javascript src='".$this->clientlocation."room_numbers.php'></script>";
	
		return $room;
	}
	
	function chat_getChatterListFromLocalServer()
	{
		$userListStr = "";
	
		$d = @dir($this->chatdatapath);
		if(is_object($d))
		{
			while (false !== ($entry = $d->read())) 
			{
		   	$rest = substr($entry, 0, 5);
		   	if ($rest == "room_")
		   	{
			
				if (file_exists($this->chatdatapath.$entry))
				{
				
					$f_users = file($this->chatdatapath.$entry);
				
					for ($i = 0; $i < count($f_users); $i ++)
					{
						$f_line = trim($f_users[$i]);
					
						if ($f_line != "")
						{
							$userListStr = ($userListStr == "") ? $f_line : $userListStr. "," . $f_line;
						}
					}
					$userListStr = (empty($userListStr)) ? "None" : $userListStr;	
				}	   	
		   	}
	
			}
			$d->close();
		}
		$userListStr = ($userListStr == "") ? "None" : $userListStr;
		return $userListStr;
	}
	
	function chat_getChatterListFromExtendServer()
	{
		$userListStr = "<script lanauge=javascript src='".$this->clientlocation."user_list.php'></script>";
		$userListStr = (empty($userListStr)) ? "None" : $userListStr;	
		return $userListStr;
	}
}
?>