<%@ language="vbscript" %>
<%option explicit%>

<!--#include file="System/ErrorMessageHeader.asp"-->
<%
if (IsNull(Application("II_WEBROOT_PATH")) or IsEmpty(Application("II_WEBROOT_PATH"))) then
	'Redirect to web apps homepage, which reconstructs the application variable values by default without having to use them (calls System/SystemSettings.asp)
	response.redirect ("../../")
	response.end
end if
%>

<%Server.Execute (Application("II_WEBROOT_PATH") & "/System/PAGE_SYSTEM.asp")%>
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
<%Server.Execute (Application("II_WEBROOT_PATH") & "/System/PAGE_HEADER.asp")%>
<link media="screen" rel="stylesheet" type="text/css" href="skin/style.css" />
</head>
<body>
<%Server.Execute (Application("II_WEBROOT_PATH") & "/System/PAGE_BODY_TOP.asp")%>

<!--#include file="System/SystemDatabases.asp"-->



















<div id='toolbar'>
<a href='default.asp?imageview=1' class='button view' title='view images'><img src='Skin/images/spacer.gif' class='' alt='' title='' /><span class='hide'>view images&nbsp;</span></a>
<a href='add.asp' class='button add' title='upload'><img src='Skin/images/spacer.gif' class='' alt='' title='' /><span class='hide'>upload</span></a>
<div class='button divider'><span class='hide'>&nbsp;|&nbsp;</span></div>
<a href='help.asp' class='button help' title='help'><img src='Skin/images/spacer.gif' class='' alt='' title='' /><span class='hide'>help</span></a>
</div>



<div class='imagemanager_help'>
<h1>ImageManager</h1>
<fieldset>
<br />

<h2>Overview</h2>
<p>
The <strong>ImageManager Module</strong> allows you to manage all your images, graphics and photos in one simple area online! Using ImageManager, you can easily view and store all your images and upload new images as needed. Think of the ImageManager as a large central repository or "library" of images, which you may reference as needed. Besides being a central repository for photos, the ImageManager may also be used as a quick viewing tool or area for sharing large volumes of photos with others. Because all of your web visitors access ImageIsle by default (and all its modules) they can add, edit, and delete existing images found in your web site. For this reason, it is better to secure the ImageManager so that only you have access. This way, you can manage all your images securely without the risk of others changing your images. You may do this using the Security Module that comes with the full version of ImageIsle. However, if you are in an intranet environment, or feel secure with allowing others the ability to add their images to your library (public portal), then you may allow others to access the ImageManager and upload their own images to the application.
</p>
<p>
Because the ImageManager controls all images uploaded and managed in the web site, all other areas and modules in the site will use the ImageManager's database of images. This gives you the freedom to upload as many images as you like into the ImageManager without having to worry about the order they are in, the sizes, or which images are displayed publicly to others (unless you allow public access to the ImageModule itself, as described above). As you add new and exciting modules to your web application, those module will be able to access the ImageModules repository of images as stored in its database, and share them out in all kinds of creative ways, without affecting the ImageManager's central repository of images. Keep this in mind as your library of images increases and you begin to add new modules and assign images to various modules. The ImageModule is a very simple tool for adding volumes of images and making sure they are available for all the other modules in your web application.
</p>

<h2>Viewing Images</h2>
<p>
In the main area of the ImageManager, you will see an "eye" icon. This tool bar icon allows you to access views of your images. (The free version of the ImageManager Module comes with only one "view". This thumbnail view, which shows tiles and paged sets of image thumbnails in the web page, is what freeware users will see. In the full version there are three views and a sorting feature). Finally, you will see a numerical paging toolbar. This gray toolbar allows you to quickly access "pages" of images. Because only a certain number are displayed per page, managing hundreds of images is much easier using this paging system. Click a number to go to that page of images.
</p>

<p>
When you click an image, you may view that image full size. Because you upload all images as they are originally (not resized) what you see is what you get. However, the browser and interface will "scale" down this large image to "fit" into the available vertical interface space in the display. What this means is viewing an image will show the image in many cases slightly smaller, so it fits inside your browser window. Its still the same large image, just stretched down to fit. When viewing, you can continue to "rescale" the image if it still is too large by clicking the gray scale boxes in the toolbar. Click the edit tool to take you to the edit area. This allows you to see a box to the left that displays info about the image, such as its size and dimensions, etc. You may add a name and description to your image, which may or may not display with the image in various parts of the product (depending on what area of the product you are in and version of software you are using). In this module, those names and descriptions are helpful in the text listing views of images, so you can quickly identify images by name or description if needed.
</p>

<p><strong>Rotate Tool</strong> - At the top of the edit view area is a purple circular arrow. Clicking that will rotate your image 90 degrees to the left or clockwise. Keep clicking to align you image as needed. Many digital cameras create horizontal image views which you have to turn your head to see. This handy tool was created for those people who may be uploading right off their digital camera into the product and need a quick way to quickly rotate their images. Clicking this tool permanently rotates the image, so it is not like rescaling and does affect the original image and saves it and its thumbnail in the new rotation.<br />***Note: When you click this tool, you may see something "funny". You may see your image blink then appear blurred or distorted. Dont worry! Its not the software, its your browser! Some browsers are set to "cache" large images, meaning that they will not update your local copy with the one that's been rotated and sent to your browser for viewing. You will actually be viewing your non-rotated image but with the wrong width and height sent in the html of the web page. Nothing is wrong with your image, so dont panic! If you are running into this problem, go into your browser and clear your cache! That should show your image in the correct rotation. If you are using Internet Explorer, a better solution is to go into Tools/Internet Options, then under the General tab, click the settings button or browser history settings button and you will come to your "Temporary Internet Files" area. Choose the radio button called "Every Time I Visit the Page". That will force your browser to suck down a fresh rotated copy when you press the purple rotate button, and will allow you to see the image rotation exactly as its supposed to look.
</p>

<h2>Uploading Images</h2>
<p>
The ImageManager Module also allows you to upload new images into your web site. You may upload images from your computer to your web site and server using the file upload system under the "Upload" button and blue arrow icon. In the upload area, you will see ten upload file fields, and a submit button. Simply choose images you wish to upload by clicking "browse" buttons in the ten upload buttons found in the Uploads page, then clicking "upload images" to upload these images from your computer to the server. Please be patient while you images upload to your site.
</p>
<p>
*Note:  Dialup users may have to wait some minutes when uploading very large files. To prevent this, please reduce the size of your image before uploading. The same applies for images several megs in size over a broadband connection. Its possible that large numbers of very large images may "time out" on the upload process. To prevent this, again, please resize your images when possible to a smaller size.
</p>
<p>
After the images are uploaded, the system will refresh and you may see a message at the top that describes which images were successful and which could not be uploaded. The system will refresh the page and will then generate thumbnails for all your images automatically.
</p>
<p>
*Note: During this process DO NOT CLICK ANYWHERE IN THE INTERFACE, as the system needs to complete both the image upload process and the thumbnail creation process! Doing so will stop the thumbnail creation and/or database save processes on the server, and you will have to reload your images.
</p>
<p>
Upon completion, the upload page will return you to your page and indicate that upload is complete, displaying a green checkmark and message. After completion, your images can be seen by clicking the "Images" button in the toolbar at the top. You may have to click the last paging numbers in the paging toolbar at the top to see the latest images you just added. Or, simply click the sort dropdown and choose "newest to oldest" and submit. New images may be clicked in the display to view, or edited by clicking edit. The new images are now in the ImageManager Module and ready for viewing. Keep in mind that the ImageManager is not generally considered a tool for sharing views of your images with others (the ImageViewer Module allows you to share images in the ImageManager Module), but may be used as such if needed.
</p>
<p>

You may read our section below if you are having any special issues with uploading your images or creating thumbnails:

<ul>
<li><strong>Supported File Formats</strong>: This version of the application is designed to support only those image formats that display in most current browsers, and without the support of third party plugins. These generally include JPEG, PNG, GIF, and BMP. Many other image formats are not supported by your browser for visual display, so have been excluded in this version. This includes file formats like TIFF, PSD (Photoshop), TARGA, PICT, Paint, RAW, many others. Later versions or modules may allow these formats and/or convert them to readable types.</li>
<li><strong>Original File Formats Retained</strong>: On uploading an image, the original image format, size, dimensions, and file name are retained exactly as you created them. The exception would be if you have "illegal characters" used in your image name (like quotes, etc.). Some characters may be stripped out so the file paths work in a users browser and display in the interface correctly. No conversion, compression, or manipulation of the original image is ever done, except to store the image on your web site and server exactly as you created it. For that reason, its important that you resize and rename your images as needed before uploading. After upload, certain tools in the interface will allow you to manipulate the image (i.e. rotate tool, etc.) But essentially what you upload is what you get!</li>
<li><strong>Image Thumbnails</strong>: In this version of the application, all thumbnails are created for you as new images based on the original image, when possible. Thumbnails are automatically created for you after the initial image upload is complete.<br />*Note: Because a small ASP.NET web page performs this function, your web server must support ASP.NET as well as ASP, and have full read/write permissions assigned on the main ImageIsle folder for both the anonymous IUSR account and the ASP_NET worker process account. Without those permission applied to all files inside the ImageIsle folder, the web site may not function correctly. Please contact your ISP or Web Host Provider and ask their support team to add these permission if yoiu still see errors in the web site.<br />These thumbnails, when created, are currently stored as JPEGS. Some image formats do not convert to the thumbnail format created in this web application. Conversion to the thumbnail format used in this application may cause issues with some types of 8-bit color JPEGS, certain GIF (including some animated formats), some color indexed images, and other compressions. If you see thumbnails missing for some images you upload, this is expected for these formats. When the system can create a thumb from the image you upload, it will be shown in the image view area. If not, a placeholder image will be provided that does not show a thumbnail. But you may click that item to see the image full size. Note: The system uses a small JavaScript call to process the web page upon completing your inital image upload. If you have disabled JavaScript support or your agent does not support JavaScript, you will see a button you may still physically press to trigger the thumbnail creator script when upload is complete. In general, most browsers will skip this process and automaticfally create the thumbnails for you, after file upload.</li>
<li><strong>Large Files May Not Upload</strong>: Large files take longer to upload and some very large images uploaded on dial-up may time out your connection to the server before the file is completely uploaded. Edit the size and dpi of your images before uploading to reduce their size whenever possible, especially if you are using a dial-up connection. Smaller photos are better in that scenario and on the web in general, when showing to others online. In all cases its always better to upload images 4 megabytes or less or less than 1 megabyte when possible, so users who view your images online do not have to wait long periods of time waiting for their browsers to download images to them from your site. If you and your visitors have broadband connections, then larger file uploads and views will be possible. Keep that in mind when creating images on your desktop that will be uploaded into ImageIsle.</li>
<li><strong>Check your Host Provider for File Space Allowed</strong>: Because the practice of uploading and storing large amounts of images on a web server takes up space on your hosted web site, you may quickly exceed the allowed space on your host provider's server account you have with them. Please check with your web site host provider first to see how much hard drive space in megabytes or gigabytes they allow for your web site as found under your hosting contract with them. Make sure you have plenty of hard drive space before uploading large volumes of images to your site. The same rule applies to gigabytes of download allowed. Most host providers also allow so much download bandwidth. Make sure you also have enough bandwidth to present your images. The web application cannot control those factors, especially if your host provider has systems in place that disallow you to upload additional items once you reach your maximum allowed.</li>
<li><strong>Check your Host Provider for Read/Write Permissions on your Web Site</strong>: If you have any problems uploading images to the server (errors listed at the bottom of this page), or they do not appear after uploading, check to make sure your web site has write permissions set on all folders inside this web application. Contact your ISP or the host provider for your web site and request that they give the ASP_NET and anonymous user accounts (IUSR) full write/read/delete/folder permissions on the server for all folders and files inside the <%=Application("II_PRODUCT_NAME")%> web application. The same permission changes apply, in general, to all errors related to reading and writing to the module databases, as the web application uses MSXML to manage and write to the database, and will need those same anonymous and ASP worker process accounts given full permissions on the folder and file permission settings as well, to function correctly.</li>
<li><strong>Copyrights and Your Responsibility</strong>: It is the users responsibility to make sure that no copyright infringements occur with the images they choose to upload to this system. The creator of this software (<%=Application("II_COMPANY_NAME")%>) is not liable for or responsible, in any way, for infringements of any kind or damages that occur to other groups or peoples, from the storing or uploading of files using this software, which may or may not involve copyrighted material or patent infringments related to files uploaded to this system. All images and files stored and used in this software by the user are the sole responsibility of the user(s) of the software. By using this software, the user agrees to these requirements and stipulations as defined in the license that comes with this software.</li>
<li>*Note: If you have any problems or errors uploading images, it is mostly likely due to a setting on the web server. Make sure ASP and ASP.NET 1.1 are enabled on your web site first. Then, make sure the problem is not related to a permission setting on the web server where your web site is hosted. Please ask you ISP to add write permissions (or priveleges) for the "IUSR" and "ASP_NET" user accounts on your ImageIsle folder and all sub folders and files. Please read the "INSTRUCTIONS.txt" file in the root web folder for <%=Application("II_PRODUCT_NAME")%> for more information.</li>
</ul>
</p>


<h2>New Modules!</h2>

<p>
The ImageManager (in the free version) will allow you to manage hundreds if not thousands of images online, using a simple web-based interface and toolset. Just upload the images and they are always available from your web site. You can then assign them to other modules (i.e. ImageViewer pages) and share them (or not share them) online to the world, as you desire. Because the free version is simplified for new users, you may see features that you wish to have in managing your images online, and which may not included in this free version. In future versions, we will be adding new features that refine and enhance how you manage your digital libraries. These more advanced modules will be simple drag and drop folders that you can use to replace your old module and which will have newer and more advanced features and functionality. So, please look for these new modules at our web site.
</p>
<p>
Finally, keep in mind, that the ImageManager works best when combined with other modules, which allow you to access images from the ImageManager database and extend them to public web pages (i.e. ImageViewer Module), secure them behind a login (i.e. Security Module), or extend their use into future modules you add to the product. Always keep in mind that each module in <%=Application("II_PRODUCT_NAME")%> is designed to serve a small set of functions, but which combined with other modules, enhance the final web application and extend its feature set into new and more exciting areas. For example, future modules may allow you to organize libraries of images by albums or groups, and then combine those with the ImageViewer pages, so that you can mix and match groupings of images with groupings of public web pages. Or, a future module may allow your to perform online digital editing on your uploaded images via the web site, where you actually crop, colorize, watermark, or resize your images online through the web product. Together, modules make the site do what you need it to do! So, look for newer modules at our web site, as they may have newer features you have been looking for.
<br /><br />
You may download new modules and skins, as well as get more information about this product and others we offer by visiting us online: <a href="<%=Application("II_COMPANY_URL")%>" target='_blank'><strong><%=Application("II_COMPANY_URL")%></strong></a>
</p>

</fieldset>

</div>










<!--#include file="System/ErrorMessageFooter.asp"-->
<%Server.Execute (Application("II_WEBROOT_PATH") & "/System/PAGE_BODY_BOTTOM.asp")%>
</body>
</html>

