/*
 * Decompiled with CFR 0.152.
 */
package zipsnap;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import zipsnap.ErrorWarningHandler;
import zipsnap.FileIO;
import zipsnap.FileUnit;
import zipsnap.StringManipulator;
import zipsnap.UserIO;
import zipsnap.ZipSnap;

public class CompressionIO {
    public static int zipFiles(File zipFile, List<FileUnit> files, List<FileUnit> addedFiles) {
        String zipFileName = zipFile.getName();
        if (ZipSnap.simulateOnly) {
            return CompressionIO.simulateProcessFiles("\n\nSimulating addition of " + files.size() + " files/directories to new ZIP volume \"" + zipFileName + "\":", "", "No. of files/directories added:", true, files, addedFiles);
        }
        System.out.print("\n\nAdding " + files.size() + " files/directories to new ZIP volume \"" + zipFileName + "\":");
        File parentDir = zipFile.getParentFile();
        if (!parentDir.exists()) {
            parentDir.mkdirs();
        }
        if (!parentDir.isDirectory()) {
            ErrorWarningHandler.reportErrorAndExit("Unable to create ZIP volume \"" + zipFileName + "\":\nThe parent directory \"" + parentDir.getPath() + "\" does not exist, and cannot be created.");
        }
        if (zipFile.exists()) {
            ErrorWarningHandler.reportErrorAndExit("Unable to create ZIP volume \"" + zipFileName + "\":\nA " + (zipFile.isDirectory() ? "directory" : "file") + " of the same name already exists.");
        }
        int numAddedFiles = 0;
        long totalUncompressedSize = 0L;
        if (files.isEmpty()) {
            try {
                FileOutputStream fos = new FileOutputStream(zipFile);
                fos.flush();
                fos.close();
            }
            catch (Exception e) {
                ErrorWarningHandler.reportErrorAndExit("Unable to create ZIP volume \"" + zipFileName + "\":\n" + ErrorWarningHandler.getExceptionMessage(e));
            }
        } else {
            ZipOutputStream zos = null;
            try {
                zos = new ZipOutputStream(new FileOutputStream(zipFile));
            }
            catch (Exception e) {
                ErrorWarningHandler.reportErrorAndExit("Unable to create ZIP volume \"" + zipFileName + "\":\n" + ErrorWarningHandler.getExceptionMessage(e));
            }
            zos.setLevel(ZipSnap.compressionLevel);
            byte[] byteBuffer = new byte[0x100000];
            int i = 0;
            for (FileUnit u : files) {
                boolean useDeflate;
                ++i;
                ZipEntry ze = new ZipEntry(u.name);
                ze.setTime(u.time);
                boolean bl = useDeflate = u.size >= 256L;
                if (useDeflate) {
                    System.out.print("\n  [" + i + "] \"" + u.nativeName + "\"");
                    ze.setMethod(8);
                } else {
                    System.out.print("\n  [" + i + "] \"" + u.nativeName + "\"");
                    ze.setCrc(u.getCrc());
                    ze.setSize(u.size);
                    ze.setMethod(0);
                }
                System.out.flush();
                try {
                    zos.putNextEntry(ze);
                    if (!u.isDirectory) {
                        int byteCount;
                        FileInputStream fis = new FileInputStream(u.file);
                        while ((byteCount = fis.read(byteBuffer, 0, 0x100000)) != -1) {
                            zos.write(byteBuffer, 0, byteCount);
                        }
                        fis.close();
                    }
                    zos.closeEntry();
                }
                catch (Exception e) {
                    if (u.isDirectory) {
                        ErrorWarningHandler.reportWarning("Unable to add directory \"" + u.nativeName + "\" to ZIP volume \"" + zipFileName + "\":\n" + ErrorWarningHandler.getExceptionMessage(e) + "\nThis directory will be ignored.");
                        continue;
                    }
                    ErrorWarningHandler.reportWarning("Unable to add file \"" + u.nativeName + "\" to ZIP volume \"" + zipFileName + "\":\n" + ErrorWarningHandler.getExceptionMessage(e) + "\nThis file will be ignored.");
                    continue;
                }
                if (useDeflate) {
                    u.setCrc(ze.getCrc());
                    System.out.print(" (" + (int)(100.0 * (double)(ze.getSize() - ze.getCompressedSize()) / (double)ze.getSize()) + "%)");
                }
                addedFiles.add(u);
                totalUncompressedSize += u.size;
                ++numAddedFiles;
            }
            try {
                zos.flush();
                zos.close();
            }
            catch (Exception e) {
                ErrorWarningHandler.reportWarning("Unable to close ZIP volume \"" + zipFileName + "\"\n(ZIP volume may not be written successfully):\n" + ErrorWarningHandler.getExceptionMessage(e));
            }
        }
        System.out.print("\n  -------------------------------\n  No. of files/directories added: " + numAddedFiles + " out of " + files.size() + "\n  Uncompressed size             : " + StringManipulator.formattedLong(totalUncompressedSize) + " bytes" + "\n  Compressed size (ratio)       : " + StringManipulator.formattedLong(zipFile.length()) + " bytes (" + (totalUncompressedSize > 0L ? Integer.valueOf((int)(100.0 * (double)(totalUncompressedSize - zipFile.length()) / (double)totalUncompressedSize)) : "-") + "%)");
        System.out.flush();
        FileIO.FileIOResult result = FileIO.setFileTime(zipFile, ZipSnap.currentTime.getTime());
        if (!result.success) {
            ErrorWarningHandler.reportWarning("Unable to set last-modified time of ZIP volume \"" + zipFileName + "\".");
        }
        return numAddedFiles;
    }

    public static int jarFiles(File jarFile, List<FileUnit> files, List<FileUnit> addedFiles) {
        String jarFileName = jarFile.getName();
        if (ZipSnap.simulateOnly) {
            return CompressionIO.simulateProcessFiles("\n\nSimulating addition of " + files.size() + " files/directories to new JAR volume \"" + jarFileName + "\":", "", "No. of files/directories added:", true, files, addedFiles);
        }
        System.out.print("\n\nAdding " + files.size() + " files/directories to new JAR volume \"" + jarFileName + "\":");
        File parentDir = jarFile.getParentFile();
        if (!parentDir.exists()) {
            parentDir.mkdirs();
        }
        if (!parentDir.isDirectory()) {
            ErrorWarningHandler.reportErrorAndExit("Unable to create JAR volume \"" + jarFileName + "\":\nThe parent directory \"" + parentDir.getPath() + "\" does not exist, and cannot be created.");
        }
        if (jarFile.exists()) {
            ErrorWarningHandler.reportErrorAndExit("Unable to create JAR volume \"" + jarFileName + "\":\nA " + (jarFile.isDirectory() ? "directory" : "file") + " of the same name already exists.");
        }
        int numAddedFiles = 0;
        long totalUncompressedSize = 0L;
        if (files.isEmpty()) {
            try {
                FileOutputStream fos = new FileOutputStream(jarFile);
                fos.flush();
                fos.close();
            }
            catch (Exception e) {
                ErrorWarningHandler.reportErrorAndExit("Unable to create JAR volume \"" + jarFileName + "\":\n" + ErrorWarningHandler.getExceptionMessage(e));
            }
        } else {
            JarOutputStream jos = null;
            try {
                jos = new JarOutputStream(new FileOutputStream(jarFile));
            }
            catch (Exception e) {
                ErrorWarningHandler.reportErrorAndExit("Unable to create JAR volume \"" + jarFileName + "\":\n" + ErrorWarningHandler.getExceptionMessage(e));
            }
            jos.setLevel(ZipSnap.compressionLevel);
            byte[] byteBuffer = new byte[0x100000];
            int i = 0;
            for (FileUnit u : files) {
                boolean useDeflate;
                ++i;
                JarEntry je = new JarEntry(u.name);
                je.setTime(u.time);
                boolean bl = useDeflate = u.size >= 256L;
                if (useDeflate) {
                    System.out.print("\n  [" + i + "] \"" + u.nativeName + "\"");
                    je.setMethod(8);
                } else {
                    System.out.print("\n  [" + i + "] \"" + u.nativeName + "\"");
                    je.setCrc(u.getCrc());
                    je.setSize(u.size);
                    je.setMethod(0);
                }
                System.out.flush();
                try {
                    jos.putNextEntry(je);
                    if (!u.isDirectory) {
                        int byteCount;
                        FileInputStream fis = new FileInputStream(u.file);
                        while ((byteCount = fis.read(byteBuffer, 0, 0x100000)) != -1) {
                            jos.write(byteBuffer, 0, byteCount);
                        }
                        fis.close();
                    }
                    jos.closeEntry();
                }
                catch (Exception e) {
                    if (u.isDirectory) {
                        ErrorWarningHandler.reportWarning("Unable to add directory \"" + u.nativeName + "\" to JAR volume \"" + jarFileName + "\":\n" + ErrorWarningHandler.getExceptionMessage(e) + "\nThis directory will be ignored.");
                        continue;
                    }
                    ErrorWarningHandler.reportWarning("Unable to add file \"" + u.nativeName + "\" to JAR volume \"" + jarFileName + "\":\n" + ErrorWarningHandler.getExceptionMessage(e) + "\nThis file will be ignored.");
                    continue;
                }
                if (useDeflate) {
                    u.setCrc(je.getCrc());
                    System.out.print(" (" + (int)(100.0 * (double)(je.getSize() - je.getCompressedSize()) / (double)je.getSize()) + "%)");
                }
                addedFiles.add(u);
                totalUncompressedSize += u.size;
                ++numAddedFiles;
            }
            try {
                jos.flush();
                jos.close();
            }
            catch (Exception e) {
                ErrorWarningHandler.reportWarning("Unable to close JAR volume \"" + jarFileName + "\"\n(JAR volume may not be written successfully):\n" + ErrorWarningHandler.getExceptionMessage(e));
            }
        }
        System.out.print("\n  -------------------------------\n  No. of files/directories added: " + numAddedFiles + " out of " + files.size() + "\n  Uncompressed size             : " + StringManipulator.formattedLong(totalUncompressedSize) + " bytes" + "\n  Compressed size (ratio)       : " + StringManipulator.formattedLong(jarFile.length()) + " bytes (" + (totalUncompressedSize > 0L ? Integer.valueOf((int)(100.0 * (double)(totalUncompressedSize - jarFile.length()) / (double)totalUncompressedSize)) : "-") + "%)");
        System.out.flush();
        FileIO.FileIOResult result = FileIO.setFileTime(jarFile, ZipSnap.currentTime.getTime());
        if (!result.success) {
            ErrorWarningHandler.reportWarning("Unable to set last-modified time of JAR volume \"" + jarFileName + "\".");
        }
        return numAddedFiles;
    }

    public static int unZipFiles(File zipFile, List<FileUnit> files, List<FileUnit> extractedFiles) {
        String zipFileName;
        String string = zipFileName = ZipSnap.searchPaths.size() == 1 ? zipFile.getName() : zipFile.getPath();
        if (ZipSnap.simulateOnly) {
            return CompressionIO.simulateProcessFiles("\n\nSimulating extraction of " + files.size() + " files/directories from ZIP volume \"" + zipFileName + "\":", "", "No. of files/directories extracted:", true, files, extractedFiles);
        }
        System.out.print("\n\nExtracting " + files.size() + " files/directories from ZIP volume \"" + zipFileName + "\":");
        int numExtractedFiles = 0;
        if (!files.isEmpty()) {
            if (!zipFile.exists()) {
                ErrorWarningHandler.reportWarning("ZIP volume \"" + zipFileName + "\" does not exist;\nthe " + files.size() + " files/directories from this volume will not be extracted.");
            }
            ZipFile zf = null;
            try {
                zf = new ZipFile(zipFile);
            }
            catch (Exception e) {
                ErrorWarningHandler.reportWarning("Unable to open ZIP volume \"" + zipFileName + "\":\n" + ErrorWarningHandler.getExceptionMessage(e) + "\nThe " + files.size() + " files/directories from this volume will not be extracted.");
            }
            byte[] byteBuffer = new byte[0x100000];
            int i = 0;
            for (FileUnit u : files) {
                ++i;
                boolean extractFile = false;
                if (u.file.exists()) {
                    if (u.isDirectory == u.file.isDirectory()) {
                        if (ZipSnap.defaultActionOnOverwrite == 'Y') {
                            System.out.print("\n  [" + i + "] Overwriting \"" + u.nativeName + "\"");
                            extractFile = true;
                        } else if (ZipSnap.defaultActionOnOverwrite == 'N') {
                            System.out.print("\n  [" + i + "] Skipping existing \"" + u.nativeName + "\"");
                        } else if (ZipSnap.defaultActionOnOverwrite == '\u0000') {
                            System.out.print("\n  [" + i + "] Overwrite \"" + u.nativeName + "\"?\n  ");
                            char choice = UserIO.userCharPrompt("(Y)es/(N)o/(A)lways/Neve(R): ", "YNAR");
                            if (choice == 'Y') {
                                extractFile = true;
                            } else if (choice == 'A') {
                                ZipSnap.defaultActionOnOverwrite = (char)89;
                                extractFile = true;
                            } else if (choice == 'R') {
                                ZipSnap.defaultActionOnOverwrite = (char)78;
                            }
                        }
                    } else {
                        System.out.print("\n  [" + i + "] \"" + u.nativeName + "\"");
                        ErrorWarningHandler.reportWarning("Unable to extract " + (u.isDirectory ? "directory" : "file") + " \"" + u.nativeName + "\" from ZIP volume \"" + zipFileName + "\":\nA " + (u.file.isDirectory() ? "directory" : "file") + " of the same name already exists.");
                    }
                } else {
                    System.out.print("\n  [" + i + "] \"" + u.nativeName + "\"");
                    extractFile = true;
                }
                System.out.flush();
                if (!extractFile) continue;
                if (u.isDirectory) {
                    u.file.mkdirs();
                    if (!u.file.exists() || !u.file.isDirectory()) {
                        ErrorWarningHandler.reportWarning("Unable to extract directory \"" + u.nativeName + "\" from ZIP volume \"" + zipFileName + "\".");
                        continue;
                    }
                    String pathname = null;
                    try {
                        pathname = u.file.getCanonicalPath();
                    }
                    catch (Exception e) {
                        pathname = null;
                    }
                    if (pathname != null && !pathname.equals(u.file.getPath())) {
                        File s = new File(pathname);
                        for (File t = u.file; !(s == null || t == null || s.equals(ZipSnap.currentDir) || t.equals(ZipSnap.currentDir) || s.getPath().equals(t.getPath())); s = s.getParentFile(), t = t.getParentFile()) {
                            s.renameTo(t);
                        }
                    }
                    FileIO.FileIOResult result = FileIO.setDirTime(u.file, u.time);
                    if (!result.success) {
                        ErrorWarningHandler.reportWarning("Unable to set last-modified time of extracted directory \"" + u.nativeName + "\".");
                    }
                } else {
                    ZipEntry ze = zf.getEntry(u.name);
                    if (ze == null) {
                        ErrorWarningHandler.reportWarning("Unable to extract file \"" + u.nativeName + "\" from ZIP volume \"" + zipFileName + "\":\nCannot find the corresponding entry in the ZIP volume.");
                        continue;
                    }
                    File parentDir = u.file.getParentFile();
                    if (parentDir != null && !parentDir.exists()) {
                        parentDir.mkdirs();
                    }
                    if (parentDir == null || !parentDir.isDirectory()) {
                        ErrorWarningHandler.reportWarning("Unable to extract file \"" + u.nativeName + "\" from ZIP volume \"" + zipFileName + "\":\nThe parent directory of the file does not exist and cannot be created.");
                        continue;
                    }
                    InputStream zis = null;
                    FileOutputStream fos = null;
                    try {
                        int byteCount;
                        zis = zf.getInputStream(ze);
                        fos = new FileOutputStream(u.file);
                        while ((byteCount = zis.read(byteBuffer, 0, 0x100000)) != -1) {
                            fos.write(byteBuffer, 0, byteCount);
                        }
                    }
                    catch (Exception e) {
                        ErrorWarningHandler.reportWarning("Unable to extract file \"" + u.nativeName + "\" from ZIP volume \"" + zipFileName + "\":\n" + ErrorWarningHandler.getExceptionMessage(e));
                        continue;
                    }
                    try {
                        fos.flush();
                        fos.close();
                    }
                    catch (Exception e) {
                        ErrorWarningHandler.reportWarning("Unable to close extracted file \"" + u.nativeName + "\"\n(file may not be written successfully):\n" + ErrorWarningHandler.getExceptionMessage(e));
                    }
                    try {
                        zis.close();
                    }
                    catch (Exception e) {
                        ErrorWarningHandler.reportWarning("Unable to close ZIP volume entry \"" + u.nativeName + "\"\n(extracted file may not be written successfully):\n" + ErrorWarningHandler.getExceptionMessage(e));
                    }
                    String pathname = null;
                    try {
                        pathname = u.file.getCanonicalPath();
                    }
                    catch (Exception e) {
                        pathname = null;
                    }
                    if (pathname != null && !pathname.equals(u.file.getPath())) {
                        File s = new File(pathname);
                        for (File t = u.file; !(s == null || t == null || s.equals(ZipSnap.currentDir) || t.equals(ZipSnap.currentDir) || s.getPath().equals(t.getPath())); s = s.getParentFile(), t = t.getParentFile()) {
                            s.renameTo(t);
                        }
                    }
                    FileIO.FileIOResult result = FileIO.setFileTime(u.file, u.time);
                    if (!result.success) {
                        ErrorWarningHandler.reportWarning("Unable to set last-modified time of extracted file \"" + u.nativeName + "\".");
                    }
                }
                extractedFiles.add(u);
                ++numExtractedFiles;
            }
            try {
                zf.close();
            }
            catch (Exception e) {
                ErrorWarningHandler.reportWarning("Unable to close ZIP volume \"" + zipFileName + "\"\n(file may not be read successfully):\n" + ErrorWarningHandler.getExceptionMessage(e));
            }
        }
        System.out.print("\n  -----------------------------------\n  No. of files/directories extracted: " + numExtractedFiles + " out of " + files.size());
        System.out.flush();
        return numExtractedFiles;
    }

    public static int unJarFiles(File jarFile, List<FileUnit> files, List<FileUnit> extractedFiles) {
        String jarFileName;
        String string = jarFileName = ZipSnap.searchPaths.size() == 1 ? jarFile.getName() : jarFile.getPath();
        if (ZipSnap.simulateOnly) {
            return CompressionIO.simulateProcessFiles("\n\nSimulating extraction of " + files.size() + " files/directories from JAR volume \"" + jarFileName + "\":", "", "No. of files/directories extracted:", true, files, extractedFiles);
        }
        System.out.print("\n\nExtracting " + files.size() + " files/directories from JAR volume \"" + jarFileName + "\":");
        int numExtractedFiles = 0;
        if (!files.isEmpty()) {
            if (!jarFile.exists()) {
                ErrorWarningHandler.reportWarning("JAR volume \"" + jarFileName + "\" does not exist;\nthe " + files.size() + " files/directories from this volume will not be extracted.");
            }
            JarFile jf = null;
            try {
                jf = new JarFile(jarFile);
            }
            catch (Exception e) {
                ErrorWarningHandler.reportWarning("Unable to open JAR volume \"" + jarFileName + "\":\n" + ErrorWarningHandler.getExceptionMessage(e) + "\nThe " + files.size() + " files/directories from this volume will not be extracted.");
            }
            byte[] byteBuffer = new byte[0x100000];
            int i = 0;
            for (FileUnit u : files) {
                ++i;
                boolean extractFile = false;
                if (u.file.exists()) {
                    if (u.isDirectory == u.file.isDirectory()) {
                        if (ZipSnap.defaultActionOnOverwrite == 'Y') {
                            System.out.print("\n  [" + i + "] Overwriting \"" + u.nativeName + "\"");
                            extractFile = true;
                        } else if (ZipSnap.defaultActionOnOverwrite == 'N') {
                            System.out.print("\n  [" + i + "] Skipping existing \"" + u.nativeName + "\"");
                        } else if (ZipSnap.defaultActionOnOverwrite == '\u0000') {
                            System.out.print("\n  [" + i + "] Overwrite \"" + u.nativeName + "\"?\n  ");
                            char choice = UserIO.userCharPrompt("(Y)es/(N)o/(A)lways/Neve(R): ", "YNAR");
                            if (choice == 'Y') {
                                extractFile = true;
                            } else if (choice == 'A') {
                                ZipSnap.defaultActionOnOverwrite = (char)89;
                                extractFile = true;
                            } else if (choice == 'R') {
                                ZipSnap.defaultActionOnOverwrite = (char)78;
                            }
                        }
                    } else {
                        System.out.print("\n  [" + i + "] \"" + u.nativeName + "\"");
                        ErrorWarningHandler.reportWarning("Unable to extract " + (u.isDirectory ? "directory" : "file") + " \"" + u.nativeName + "\" from JAR volume \"" + jarFileName + "\":\nA " + (u.file.isDirectory() ? "directory" : "file") + " of the same name already exists.");
                    }
                } else {
                    System.out.print("\n  [" + i + "] \"" + u.nativeName + "\"");
                    extractFile = true;
                }
                System.out.flush();
                if (!extractFile) continue;
                if (u.isDirectory) {
                    u.file.mkdirs();
                    if (!u.file.exists() || !u.file.isDirectory()) {
                        ErrorWarningHandler.reportWarning("Unable to extract directory \"" + u.nativeName + "\" from JAR volume \"" + jarFileName + "\".");
                        continue;
                    }
                    String pathname = null;
                    try {
                        pathname = u.file.getCanonicalPath();
                    }
                    catch (Exception e) {
                        pathname = null;
                    }
                    if (pathname != null && !pathname.equals(u.file.getPath())) {
                        File s = new File(pathname);
                        for (File t = u.file; !(s == null || t == null || s.equals(ZipSnap.currentDir) || t.equals(ZipSnap.currentDir) || s.getPath().equals(t.getPath())); s = s.getParentFile(), t = t.getParentFile()) {
                            s.renameTo(t);
                        }
                    }
                    FileIO.FileIOResult result = FileIO.setDirTime(u.file, u.time);
                    if (!result.success) {
                        ErrorWarningHandler.reportWarning("Unable to set last-modified time of extracted directory \"" + u.nativeName + "\".");
                    }
                } else {
                    ZipEntry ze = jf.getEntry(u.name);
                    if (ze == null) {
                        ErrorWarningHandler.reportWarning("Unable to extract file \"" + u.nativeName + "\" from JAR volume \"" + jarFileName + "\":\nCannot find the corresponding entry in the JAR volume.");
                        continue;
                    }
                    File parentDir = u.file.getParentFile();
                    if (parentDir != null && !parentDir.exists()) {
                        parentDir.mkdirs();
                    }
                    if (parentDir == null || !parentDir.isDirectory()) {
                        ErrorWarningHandler.reportWarning("Unable to extract file \"" + u.nativeName + "\" from JAR volume \"" + jarFileName + "\":\nThe parent directory of the file does not exist and cannot be created.");
                        continue;
                    }
                    InputStream jis = null;
                    FileOutputStream fos = null;
                    try {
                        int byteCount;
                        jis = jf.getInputStream(ze);
                        fos = new FileOutputStream(u.file);
                        while ((byteCount = jis.read(byteBuffer, 0, 0x100000)) != -1) {
                            fos.write(byteBuffer, 0, byteCount);
                        }
                    }
                    catch (Exception e) {
                        ErrorWarningHandler.reportWarning("Unable to extract file \"" + u.nativeName + "\" from JAR volume \"" + jarFileName + "\":\n" + ErrorWarningHandler.getExceptionMessage(e));
                        continue;
                    }
                    try {
                        fos.flush();
                        fos.close();
                    }
                    catch (Exception e) {
                        ErrorWarningHandler.reportWarning("Unable to close extracted file \"" + u.nativeName + "\"\n(file may not be written successfully):\n" + ErrorWarningHandler.getExceptionMessage(e));
                    }
                    try {
                        jis.close();
                    }
                    catch (Exception e) {
                        ErrorWarningHandler.reportWarning("Unable to close JAR volume entry \"" + u.nativeName + "\"\n(extracted file may not be written successfully):\n" + ErrorWarningHandler.getExceptionMessage(e));
                    }
                    String pathname = null;
                    try {
                        pathname = u.file.getCanonicalPath();
                    }
                    catch (Exception e) {
                        pathname = null;
                    }
                    if (pathname != null && !pathname.equals(u.file.getPath())) {
                        File s = new File(pathname);
                        for (File t = u.file; !(s == null || t == null || s.equals(ZipSnap.currentDir) || t.equals(ZipSnap.currentDir) || s.getPath().equals(t.getPath())); s = s.getParentFile(), t = t.getParentFile()) {
                            s.renameTo(t);
                        }
                    }
                    FileIO.FileIOResult result = FileIO.setFileTime(u.file, u.time);
                    if (!result.success) {
                        ErrorWarningHandler.reportWarning("Unable to set last-modified time of extracted file \"" + u.nativeName + "\".");
                    }
                }
                extractedFiles.add(u);
                ++numExtractedFiles;
            }
            try {
                jf.close();
            }
            catch (Exception e) {
                ErrorWarningHandler.reportWarning("Unable to close JAR volume \"" + jarFileName + "\"\n(file may not be read successfully):\n" + ErrorWarningHandler.getExceptionMessage(e));
            }
        }
        System.out.print("\n  -----------------------------------\n  No. of files/directories extracted: " + numExtractedFiles + " out of " + files.size());
        System.out.flush();
        return numExtractedFiles;
    }

    public static int simulateProcessFiles(String headerString, String perFileString, String footerString, boolean success, List<FileUnit> files, List<FileUnit> processedFiles) {
        System.out.print(headerString);
        int numProcessedFiles = 0;
        int i = 0;
        for (FileUnit u : files) {
            System.out.print("\n  [" + ++i + "] " + perFileString + "\"" + u.nativeName + "\"");
            System.out.flush();
            if (!success) continue;
            processedFiles.add(u);
            ++numProcessedFiles;
        }
        System.out.print("\n  " + StringManipulator.repeat("-", footerString.length()) + "\n  " + footerString + " " + numProcessedFiles + " out of " + files.size());
        System.out.flush();
        return numProcessedFiles;
    }
}

