/*
 * Copyright (c) 2002-2005 DevTeam Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.jniwrapper.com/pages/jexcel/license
 */
package basics;

import com.jniwrapper.win32.jexcel.*;

import java.util.List;

/**
 * This sample demonstrates how to listen to workbook and worksheet events.
 *
 * @author Vladimir Kondrashchenko
 */
public class EventListenersSample
{
    public static void main(String[] args) throws ExcelException
    {
        Application application = new Application();
        GenericWorkbook workbook = application.createWorkbook(null);

        addListeners(workbook);

        runEventsGenerator(workbook);

        application.close();
    }

    private static void addListeners(GenericWorkbook workbook)
    {
        WorkbookEventListenerImpl workbookEventListener = new WorkbookEventListenerImpl();
        WorksheetEventListenerImpl worksheetEventListener = new WorksheetEventListenerImpl();

        workbook.addWorkbookEventListener(workbookEventListener);

        List worksheets = workbook.getWorksheets();
        for (int i = 0; i < worksheets.size(); i++)
        {
            Worksheet worksheet = (Worksheet)worksheets.get(i);
            worksheet.addWorksheetEventListener(worksheetEventListener);
        }
    }

    private static void runEventsGenerator(GenericWorkbook workbook) throws ExcelException
    {
        List worksheets = workbook.getWorksheets();
        for (int i = 0; i < worksheets.size(); i++)
        {
            Worksheet worksheet = (Worksheet)worksheets.get(i);
            worksheet.activate();
        }

        Worksheet worksheet = workbook.addWorksheet("Custom sheet");
        worksheet.addWorksheetEventListener(new WorksheetEventListenerImpl());

        for (int i = 1; i < 3; i++)
            for (int j = 1; j < 3; j++)
            {
                Cell cell = worksheet.getCell(i, j);
                cell.setValue(i * j);
            }

        worksheet.getRange("A1:D3").clear();
    }

    public static void log(String message)
    {
        System.out.println(message);
    }

    public static class WorkbookEventListenerImpl extends WorkbookEventAdapter
    {
        public void activate(WorkbookEventObject eventObject)
        {
            log("\"" + eventObject.getWorkbook().getWorkbookName() + "\" is activated.");
        }

        public void deactivate(WorkbookEventObject eventObject)
        {
            log("\"" + eventObject.getWorkbook().getWorkbookName() + "\" is deactivated.");
        }

        public void newSheet(WorkbookEventObject eventObject)
        {
            log("\"" + eventObject.getWorksheet().getName() + "\" is added to \"" +
                    eventObject.getWorkbook().getWorkbookName() + "\".");
        }

        public void beforeClose(WorkbookEventObject eventObject)
        {
            log("\"" + eventObject.getWorkbook().getWorkbookName() + "\" is closed.");
        }
    }

    public static class WorksheetEventListenerImpl extends WorksheetEventAdapter
    {
        public void changed(WorksheetEventObject eventObject)
        {
            log(eventObject.getRange().getAddress() + " is changed.");
        }

        public void activated(WorksheetEventObject eventObject)
        {
            log("\"" + eventObject.getWorksheet().getName() + "\" is activated.");
        }

        public void deactivated(WorksheetEventObject eventObject)
        {
            log("\"" + eventObject.getWorksheet().getName() + "\" is deactivated.");
        }
    }

}
