/*
 * Copyright (c) 2002-2005 DevTeam Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.jniwrapper.com/pages/jexcel/license
 */
package basics;

import com.jniwrapper.win32.jexcel.Application;
import com.jniwrapper.win32.jexcel.ApplicationEventListener;
import com.jniwrapper.win32.jexcel.ApplicationEventObject;

/**
 * This sample demonstrates addition of a listener of application events.
 *
 * @author Vladimir Kondrashchenko
 */
public class ApplicationEventsSample
{
    public static void main(String[] args) throws Exception
    {
        Application application = new Application();
        application.addApplicationEventListener(new ApplicationEventListener()
        {
            public void newWorkbook(ApplicationEventObject eventObject)
            {
                System.out.println(eventObject.getWorkbook().getWorkbookName() + " workbook is created.");
            }

            public void openWorkbook(ApplicationEventObject eventObject)
            {
                System.out.println(eventObject.getWorkbook().getWorkbookName() + " workbook is opened.");
            }
        });

        application.setVisible(true);

        System.out.println("Press <Enter> to close the application...");
        System.in.read();

        application.close();
    }
}
