/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.process.monitoring;

import com.jniwrapper.Bool;
import com.jniwrapper.Function;
import com.jniwrapper.NativeResource;
import com.jniwrapper.Parameter;
import com.jniwrapper.UInt32;
import com.jniwrapper.util.FlagSet;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.LastErrorException;
import com.jniwrapper.win32.process.monitoring.HeapEntry;
import com.jniwrapper.win32.process.monitoring.HeapEntryIterator;
import com.jniwrapper.win32.process.monitoring.HeapList;
import com.jniwrapper.win32.process.monitoring.HeapListIterator;
import com.jniwrapper.win32.process.monitoring.ModuleEntry;
import com.jniwrapper.win32.process.monitoring.ModuleEntryIterator;
import com.jniwrapper.win32.process.monitoring.ProcessEntry;
import com.jniwrapper.win32.process.monitoring.ProcessEntryIterator;
import com.jniwrapper.win32.process.monitoring.ThreadEntry;
import com.jniwrapper.win32.process.monitoring.ThreadEntryIterator;
import com.jniwrapper.win32.system.Kernel32;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class Snapshot
extends Handle
implements Runnable {
    private static final int ALL_PROCESSES = 0;
    private static final String FUNCTION_CreateSnapshot = "CreateToolhelp32Snapshot";
    private static final String FUNCTION_CloseHandle = "CloseHandle";
    private Options _options;
    private long _processID;

    Snapshot(long value) {
        super(value);
    }

    public Snapshot(Options options) {
        this(options, 0L);
    }

    public Snapshot(Options options, long processID) {
        this._options = options;
        this._processID = processID;
        this.run();
    }

    public Options getOptions() {
        return this._options;
    }

    public long getProcessID() {
        return this._processID;
    }

    public void setProcessID(long processID) {
        this._processID = processID;
    }

    public void run() {
        this.close();
        Function function = Kernel32.getInstance().getFunction(FUNCTION_CreateSnapshot);
        function.invoke((Parameter)this, (Parameter)new UInt32(this._options.getFlags()), (Parameter)new UInt32(this._processID));
    }

    public Iterator getProcessIterator() {
        return new ProcessEntryIterator(this);
    }

    public List getProcesses() {
        LinkedList<ProcessEntry> result = new LinkedList<ProcessEntry>();
        Iterator i = this.getProcessIterator();
        while (i.hasNext()) {
            ProcessEntry processEntry = (ProcessEntry)((Object)i.next());
            result.add(processEntry);
        }
        return result;
    }

    public Iterator getModuleIterator() {
        return new ModuleEntryIterator(this);
    }

    public List getModules() {
        LinkedList<ModuleEntry> result = new LinkedList<ModuleEntry>();
        Iterator i = this.getModuleIterator();
        while (i.hasNext()) {
            ModuleEntry moduleEntry = (ModuleEntry)((Object)i.next());
            result.add(moduleEntry);
        }
        return result;
    }

    public Iterator getHeapEntriesIterator(long processID, long heapID) {
        return new HeapEntryIterator(processID, heapID);
    }

    public List getHeapEntries(long processID, long heapID) {
        LinkedList<HeapEntry> result = new LinkedList<HeapEntry>();
        Iterator i = this.getHeapEntriesIterator(processID, heapID);
        while (i.hasNext()) {
            HeapEntry heapEntry = (HeapEntry)((Object)i.next());
            result.add(heapEntry);
        }
        return result;
    }

    public Iterator getHeapListIterator() {
        return new HeapListIterator(this);
    }

    public List getHeapList() {
        LinkedList<HeapList> result = new LinkedList<HeapList>();
        Iterator i = this.getHeapListIterator();
        while (i.hasNext()) {
            HeapList heapList = (HeapList)((Object)i.next());
            result.add(heapList);
        }
        return result;
    }

    public Iterator getThreadIterator() {
        return new ThreadEntryIterator(this);
    }

    public List getThreadList() {
        LinkedList<ThreadEntry> result = new LinkedList<ThreadEntry>();
        Iterator i = this.getThreadIterator();
        while (i.hasNext()) {
            ThreadEntry threadEntry = (ThreadEntry)((Object)i.next());
            result.add(threadEntry);
        }
        return result;
    }

    public void close() {
        Snapshot.close(this);
    }

    private static void close(Snapshot snapshot) {
        if (!snapshot.isNull()) {
            Function function = Kernel32.getInstance().getFunction(FUNCTION_CloseHandle);
            Bool functionResult = new Bool();
            long errorCode = function.invoke((Parameter)functionResult, (Parameter)snapshot);
            if (!functionResult.getValue()) {
                throw new LastErrorException(errorCode);
            }
        }
    }

    public static class Options
    extends FlagSet {
        static final int TH32CS_SNAPHEAPLIST = 1;
        static final int TH32CS_SNAPPROCESS = 2;
        static final int TH32CS_SNAPTHREAD = 4;
        static final int TH32CS_SNAPMODULE = 8;
        static final int TH32CS_SNAPALL = 15;
        static final int TH32CS_INHERIT = Integer.MIN_VALUE;

        public Options() {
        }

        public Options(long flags) {
            super(flags);
        }

        public Options(boolean snapAll) {
            this.setSnapAll(snapAll);
        }

        public void setSnapHeapList(boolean set) {
            this.setupFlag(1L, set);
        }

        public boolean isSnapHeapList() {
            return this.contains(1L);
        }

        public void setSnapProcess(boolean set) {
            this.setupFlag(2L, set);
        }

        public boolean isSnapProcess() {
            return this.contains(2L);
        }

        public void setSnapThread(boolean set) {
            this.setupFlag(4L, set);
        }

        public boolean isSnapThread() {
            return this.contains(4L);
        }

        public void setSnapModule(boolean set) {
            this.setupFlag(8L, set);
        }

        public boolean isSnapModule() {
            return this.contains(8L);
        }

        public void setInherit(boolean set) {
            this.setupFlag(Integer.MIN_VALUE, set);
        }

        public boolean isInherit() {
            return this.contains(Integer.MIN_VALUE);
        }

        public void setSnapAll(boolean set) {
            this.setupFlag(15L, set);
        }

        public boolean isSnapAll() {
            return this.contains(15L);
        }
    }

    protected static class SnapshotResource
    implements NativeResource {
        private long _handle;

        public SnapshotResource(long handle) {
            this._handle = handle;
        }

        public void release() throws Throwable {
            Snapshot.close(new Snapshot(this._handle));
        }
    }
}

