using System;
using System.Collections;
using System.Text;
using System.IO;
using System.Threading;

namespace NI.Mime4Net.Samples.InfiniteMimeStream {
	
	public class DelayedMemoryStream : Stream {

		MemoryStream RepeatStream;
		byte[] RepeatBuffer;

		public DelayedMemoryStream(byte[] startBuffer, byte[] repeatBuffer) {
			RepeatStream = new MemoryStream(startBuffer);
			RepeatBuffer = repeatBuffer;
		}

		public override int ReadByte() {
			int b = RepeatStream.ReadByte();
			
			if (b==-1) {
				Thread.Sleep(2000); // 2 secs
				RepeatStream = new MemoryStream(RepeatBuffer);
				b = RepeatStream.ReadByte();
			}

			return b;
		}


		public override bool CanRead {
			get { return RepeatStream.CanRead; }
		}

		public override bool CanSeek {
			get { return RepeatStream.CanSeek; }
		}

		public override bool CanWrite {
			get { return RepeatStream.CanWrite; }
		}

		public override void Flush() {
			RepeatStream.Flush();
		}

		public override long Length {
			get { return RepeatStream.Length; }
		}

		public override long Position {
			get { return RepeatStream.Position; }
			set { RepeatStream.Position = value; }
		}

		public override int Read(byte[] buffer, int offset, int count) {
			return RepeatStream.Read(buffer, offset, count);
		}

		public override long Seek(long offset, SeekOrigin origin) {
			return RepeatStream.Seek(offset, origin);
		}

		public override void SetLength(long value) {
			RepeatStream.SetLength(value);
		}

		public override void Write(byte[] buffer, int offset, int count) {
			RepeatStream.Write(buffer, offset, count);
		}
	}

}
