using System;
using System.IO;
using System.Drawing;
using System.Drawing.Imaging;

//using NI.Email.MonoWebMail;
using NI.Email.Mime.Message;
using NI.Email.Mime.Field;
using NI.Email.Mime.Util;

using NUnit.Framework;

namespace NI.Tests.Email.Mime.Message
{
	[TestFixture]
	public class MessageMHTMLTest
	{
		//[Test]
		public void test_ComposeMultipartRelated()
		{
			MimeMessage parent = new MimeMessage();
			Multipart multi = new Multipart();

			Header parentHeader = new Header();
			parentHeader.AddField(MimeField.Parse(@"From: foo_multipart1@bar.net"));
			parentHeader.AddField(MimeField.Parse(@"To: foo_multipart2@bar.net"));
			parentHeader.AddField(MimeField.Parse(@"Subject: multipart/related example"));
			parentHeader.AddField(MimeField.Parse(@"Mime-Version: 1.0"));
			parentHeader.AddField(MimeField.Parse(@"Content-Type: multipart/related; boundary=""test_long_boundary""; type=""text/html""; start=""<foo3@foo1@bar.net>"""));
			parent.Header = parentHeader;

			// 1st part
			BodyPart bodyFirst = new BodyPart();
			Header bodyFirstHeader = new Header();
			bodyFirstHeader.AddField(MimeField.Parse(@"Content-Type: text/html; charset=""US-ASCII"""));
			bodyFirstHeader.AddField(MimeField.Parse(@"Content-ID: <foo3@foo1@bar.net>"));

			bodyFirst.Header = bodyFirstHeader;
			MemoryStream streamFirst = new MemoryStream();
			StreamWriter writer = MessageBuilderUtil.GetWriter(streamFirst);
			writer.AutoFlush = true;
			writer.WriteLine("... text of the HTML document, which might contain a URI");
			writer.WriteLine("referencing a resource in another body part, for example");
			writer.WriteLine("through a statement such as:");
			writer.WriteLine(@"<img src=""cid:foo4@foo1@bar.net"" alt=""IETF logo""/>");
			writer.WriteLine();
			writer.WriteLine(@"now we reference image using some URI");
			writer.WriteLine(@"<img src=""http://www.test.com/images/test2_link.gif"" alt=""some gif""/>");
			writer.WriteLine();
			writer.WriteLine(@"and now you can simply reference some image");
			writer.WriteLine(@"just click <a href=""cid:foo5@foo2@bar1.net"">here</a>");
			streamFirst.Position = 0;
			bodyFirst.Body = new MemoryTextBody(streamFirst);

			multi.AddBodyPart(bodyFirst);

			// 2nd part (with CID)
			MemoryStream streamSecond = new MemoryStream();
			Image imgSecond = Image.FromFile("../../testmsgs/test_send.jpg");
			imgSecond.Save(streamSecond, ImageFormat.Jpeg);
			streamSecond.Position = 0;
			multi.AddRelatedBinaryPart(streamSecond, "foo4@foo1@bar.net", "image/jpg", "test1.jpg");

			// 3rd part (with Content-Location)
			BodyPart bodyThird = new BodyPart();
			Header bodyThirdHeader = new Header();
			bodyThirdHeader.AddField(MimeField.Parse(@"Content-Type: image/gif; name=""test2.gif"""));
			bodyThirdHeader.AddField(MimeField.Parse(@"Content-Transfer-Encoding: base64"));
			bodyThirdHeader.AddField(MimeField.Parse(@"Content-Location: http://www.test.com/images/test2_link.gif"));

			bodyThird.Header = bodyThirdHeader;
			MemoryStream streamThird = new MemoryStream();
			Image imgThird = Image.FromFile("../../testmsgs/test_send2.gif");
			imgThird.Save(streamThird, ImageFormat.Gif);
			streamThird.Position = 0;
			bodyThird.Body = new MemoryBinaryBody(streamThird);
			multi.AddBodyPart(bodyThird);

			// 4th part
			MemoryStream streamFourth = new MemoryStream();
			Image imgFourth = Image.FromFile("../../testmsgs/test_send3.png");
			imgFourth.Save(streamFourth, ImageFormat.Png);
			streamFourth.Position = 0;
			multi.AddRelatedBinaryPart(streamFourth, "foo5@foo2@bar1.net", "image/png", "test3.png");

			// main message continued
			parent.Body = multi;
			
			MemoryStream ms = new MemoryStream();
			parent.WriteTo(ms);

			// specify your SMTP server, 'from', 'to' and subject here
			try
			{
				/*SimpleSmtpSender sender = new SimpleSmtpSender("test_smtp_server");
				sender.Connect();
				sender.Send("your@mail.here", "your@mail.here", "SUBJ", ms);
				sender.Close();*/
			}
			catch (Exception ex)
			{
				throw ex;
			}
			finally
			{
				streamFirst.Close();
				streamSecond.Close();
				streamThird.Close();
				streamFourth.Close();
			}
		}
	}
}
