/*
 *  Copyright 2004 the mime4j project
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
using System;
using System.IO;
using System.Text;

using NI.Common;
using NI.Email.Mime.Decoder;
using NUnit.Framework;

namespace NI.Tests.Email.Mime.Decoder {

	/**
	* 
	*
	* @author Niklas Therning
	* @version $Id: Base64InputStreamTest.java,v 1.3 2004/10/04 15:36:44 ntherning Exp $
	*/
	[TestFixture]
	public class Base64InputStreamTest {

		string[] base64EncodedPatterns = new string[] {
			"VGhpcyBpcyB0aGUgcGxhaW4gdGV4dCBtZXNzYWdlIQ==",
			"VGhpcyBpcyBhIHRleHQgd2hpY2ggaGFzIHRvIGJlIHBhZGRlZCBvbmNlLi4=",
			"VGhpcyBpcyBhIHRleHQgd2hpY2ggaGFzIHRvIGJlIHBhZGRlZCB0d2ljZQ==",
			"VGhpcyBpcyBhIHRleHQgd2hpY2ggd2lsbCBub3QgYmUgcGFkZGVk",
			" &% VGhp\r\ncyBp\r\ncyB0aGUgcGxhaW4g  \tdGV4dCBtZ?!XNzY*WdlIQ==",
			
		};
		
		string[] base64DecodedPatterns = new string[] {
			"This is the plain text message!",
			"This is a text which has to be padded once..",
			"This is a text which has to be padded twice",
			"This is a text which will not be padded",
			"This is the plain text message!"
		};
	    
	    string[] base64EncodedLongPatterns = new string[] {
			"AAECAwQFBgcICQoLDA0ODxAREhMUFRYXGBkaGxwdHh8gISIjJCU"
					+ "mJygpKissLS4vMDEyMzQ1Njc4OTo7PD0+P0BBQkNERUZHSElKS0"
					+ "xNTk9QUVJTVFVWV1hZWltcXV5fYGFiY2RlZmdoaWprbG1ub3Bxc"
					+ "nN0dXZ3eHl6e3x9fn+AgYKDhIWGh4iJiouMjY6PkJGSk5SVlpeY"
					+ "mZqbnJ2en6ChoqOkpaanqKmqq6ytrq+wsbKztLW2t7i5uru8vb6"
					+ "/wMHCw8TFxsfIycrLzM3Oz9DR0tPU1dbX2Nna29zd3t/g4eLj5O"
					+ "Xm5+jp6uvs7e7v8PHy8/T19vf4+fr7/P3+/w==",
	        
			"AQIDBAUGBwgJCgsMDQ4PEBESExQVFhcYGRobHB0eHyAhIiMkJSY"
					+ "nKCkqKywtLi8wMTIzNDU2Nzg5Ojs8PT4/QEFCQ0RFRkdISUpLTE"
					+ "1OT1BRUlNUVVZXWFlaW1xdXl9gYWJjZGVmZ2hpamtsbW5vcHFyc"
					+ "3R1dnd4eXp7fH1+f4CBgoOEhYaHiImKi4yNjo+QkZKTlJWWl5iZ"
					+ "mpucnZ6foKGio6SlpqeoqaqrrK2ur7CxsrO0tba3uLm6u7y9vr/"
					+ "AwcLDxMXGx8jJysvMzc7P0NHS09TV1tfY2drb3N3e3+Dh4uPk5e"
					+ "bn6Onq6+zt7u/w8fLz9PX29/j5+vv8/f7/AA==",
	        
			"AgMEBQYHCAkKCwwNDg8QERITFBUWFxgZGhscHR4fICEiIyQlJic"
					+ "oKSorLC0uLzAxMjM0NTY3ODk6Ozw9Pj9AQUJDREVGR0hJSktMTU"
					+ "5PUFFSU1RVVldYWVpbXF1eX2BhYmNkZWZnaGlqa2xtbm9wcXJzd"
					+ "HV2d3h5ent8fX5/gIGCg4SFhoeIiYqLjI2Oj5CRkpOUlZaXmJma"
					+ "m5ydnp+goaKjpKWmp6ipqqusra6vsLGys7S1tre4ubq7vL2+v8D"
					+ "BwsPExcbHyMnKy8zNzs/Q0dLT1NXW19jZ2tvc3d7f4OHi4+Tl5u"
					+ "fo6err7O3u7/Dx8vP09fb3+Pn6+/z9/v8AAQ=="
	    };
	    
	    byte[] ReadBytes(Stream stream) {
			MemoryStream resultStream = new MemoryStream();
			int b;
			while ( (b = stream.ReadByte() ) != -1 ) {
				resultStream.WriteByte( (byte)b);
			}
			return resultStream.ToArray();			
	    }

		[Test]
		public void test_Decode() {
			MemoryStream memStream = null;
			
			Base64InputStream decoder = null;
	        
			for (int i=0; i<base64EncodedPatterns.Length; i++) {
				memStream = new MemoryStream(Encoding.ASCII.GetBytes(base64EncodedPatterns[i]));
				decoder = new Base64InputStream(memStream);
				byte[] data = ReadBytes(decoder);
				Assert.AreEqual(
					Encoding.ASCII.GetString(data),
					base64DecodedPatterns[i], "Pattern "+i.ToString());
			}
	        
	        
			/*
			* Test that the bytes 0-255 shifted 0, 1 and 2 positions are
			* decoded properly.
			*/
			for (int i=0; i<base64EncodedLongPatterns.Length; i++) {
				memStream = new MemoryStream(Encoding.ASCII.GetBytes(base64EncodedLongPatterns[i]));
				decoder = new Base64InputStream(memStream);

				byte[] data = ReadBytes(decoder);

				for (int j = 0; j < data.Length; j++) {
					Assert.AreEqual( data[j], (byte)(j+i), "Position " + i.ToString() );
				}				
			}
			
	        
		}
	    
	    

	}


}