using System;

namespace NI.Tests
{
	/// <summary>
	/// Utility class
	/// </summary>
	public class CustomAssert
	{
		public static void Equal(object currentValue, object testValue) {
			Equal(currentValue, testValue, "Failure");
		}
		
		static bool IsEqual(object a, object b) {
			if (a==null) return b==null;
			return a.Equals(b);
		}
		
		public static void Equal(object currentValue, object testValue, string message) {
			if ( !IsEqual(currentValue,testValue)) {
				string msg = String.Format("Assert.Equal failed: {0} (test value: [{1}], expected [{2}]", message, currentValue, testValue);
				Console.WriteLine(msg);
				throw new Exception(msg);
			}
		} 
		
		public static void NotEqual(object currentValue, object testValue, string message) {
			if ( IsEqual(currentValue,testValue)) {
				string msg = String.Format("Assert.NotEqual failed: {0} (test value: [{1}], expected NOT [{2}]",
					message, currentValue, testValue);
				Console.WriteLine(msg);
				throw new Exception(msg);
			}
		}
		
		
	}
}
