/*

  Copyright (C) 2003-2005 Smardec. All rights reserved.

  http://www.smardec.com

*/

package com.smardec.license4j.demo;

import com.smardec.license4j.License;
import com.smardec.license4j.LicenseManager;

import java.util.Iterator;
import java.util.List;


/**
 * Shows how to validate license.
 */
public class ValidateLicense {
    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("You must specify license file name.");
            System.exit(0);
        }
        try {
            // init public key. Public key is generated by CreateKeyPair class.
            LicenseManager.setPublicKey("308201B83082012C06072A8648CE3804013082011F02818100FD7F53811D75122952DF4A9C2EECE4E7F611B7523CEF4400C31E3F80B6512669455D402251FB593D8D58FABFC5F5BA30F6CB9B556CD7813B801D346FF26660B76B9950A5A49F9FE8047B1022C24FBBA9D7FEB7C61BF83B57E7C6A8A6150F04FB83F6D3C51EC3023554135A169132F675F3AE2B61D72AEFF22203199DD14801C70215009760508F15230BCCB292B982A2EB840BF0581CF502818100F7E1A085D69B3DDECBBCAB5C36B857B97994AFBBFA3AEA82F9574C0B3D0782675159578EBAD4594FE67107108180B449167123E84C281613B7CF09328CC8A6E13C167A8B547C8D28E0A3AE1E2BB3A675916EA37F0BFA213562F1FB627A01243BCCA4F1BEA8519089A883DFE15AE59F06928B665E807B552564014C3BFECF492A0381850002818100B347C285F5C57E187D620C7BBF4809B90E1E954E01360FD254D943C9984C2E8C228130EC3D73D67B3CD4E9A37703D0F7F1418E987F10ABF7A5AD656E09B265AC0818831870579B0FAFEF86FEB1D11EDFA2228C76EACCF34343DACC113E9A6D9F3E2286CC94B2E3C5CD76126E28DF5179A66229B0EB8414B079DB9EC60103D79B");
            License license = LicenseManager.loadLicense(args[0]);
            if (LicenseManager.isValid(license))
                System.out.println("\nLicense is VALID\n");
            else
                System.out.println("\nLicense is NOT VALID\n");
            List featureNames = license.getFeatureList();
            System.out.println("Features:");
            for (Iterator i = featureNames.iterator(); i.hasNext();) {
                String featureName = (String) i.next();
                Object featureValue = license.getFeature(featureName);
                System.out.println(featureName + " = " + featureValue);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
