﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;

using HiMap.Carto;
using HiMap.MapControls.Tools;
using HiMap.Geometry;

namespace HiMap
{
    /// <summary>
    /// Class for updating geometry
    /// </summary>
    public class UpdateGeometry
    {
        IFeature _feat;
        //pic control class

        protected PicCtrl MePic = null;
        protected int StaX, StaY;
        protected bool isMouseDown;
        protected IFeatureLayer _layer;
        protected Panel _pl;
        protected Button _bt2;
        protected Button _bt3;
        protected Button _btExit;
        protected Form _frm;
        protected ComboBox _cmb;
        //Map points
        protected List<IPoint> listPoint;
        //Selected Picture
        protected PictureBox picSd;
        //Screen coordinate
        protected List<System.Drawing.Point> listPoint1;
        protected MapControls.MapControl Map;

        public UpdateGeometry(Form frm,MapControls.MapControl map) 
        {
            _frm = frm;
            Map = map;
            isMouseDown = false;
            picSd = null;
        }

        //Add combobox item
        private void setCmd()
        {
            int index = listPoint1.Count - 1;
            _cmb.Items.Add("Point" + index.ToString());
            _cmb.SelectedIndex = _cmb.Items.Count - 1;
        }

        //Display all of the geometry points
        public void Show(IFeature feat) 
        {
            this.CreateControls();
            _feat = feat;
            listPoint = new List<IPoint>();
            listPoint1 = new List<System.Drawing.Point>();
            IGeometry geo = null;
            IPointCollection ptColl=null;
            switch (feat.Shape.Type)
            {
                case GeometryType.Point:
                    MePic = new PicCtrl(_frm, Map, listPoint, listPoint1, PicType.Point);
                    IPoint pt = (IPoint) feat.Shape;
                    listPoint.Add(pt);
                    listPoint1.Add(Map.MapToScreen(pt.X, pt.Y));
                    this.MePic.CreatePic(listPoint1[listPoint1.Count - 1].X, listPoint1[listPoint1.Count - 1].Y);
                    setCmd();
                    break;
                case GeometryType.Polygon:
                    MePic = new PicCtrl(_frm, Map, listPoint, listPoint1, PicType.Polygon);
                    geo = feat.Shape;
                    break;
                case GeometryType.Polyline:
                    MePic = new PicCtrl(_frm, Map, listPoint, listPoint1, PicType.Polyline);
                    geo = feat.Shape;
                    break;
            }

            if (geo != null) 
            {
                IPoint temppt=null;
                ptColl = (IPointCollection)geo;
                for (int i = 0; i < ptColl.PointCount; i++) 
                {
                    temppt = ptColl.GetPoint(i);
                    listPoint.Add(temppt);
                    listPoint1.Add(Map.MapToScreen(temppt.X, temppt.Y));
                    this.MePic.CreatePic(listPoint1[listPoint1.Count - 1].X, listPoint1[listPoint1.Count - 1].Y);
                    setCmd();
                }
            }
            MePic.Draw();
            _pl.Visible = true;
        }

        //Create controls which used by itself
        private void CreateControls()
        {
            _pl = new Panel();
            _bt2 = new Button();
            _bt3 = new Button();
            _btExit = new Button();
            _cmb = new ComboBox();

            _pl.Width = 240;
            _pl.Height = 27;
            _pl.BackColor = System.Drawing.Color.FromArgb(192, 192, 192);
            _pl.MouseDown += new MouseEventHandler(this.panCtrl_MouseDown);
            _pl.MouseMove += new MouseEventHandler(this.panCtrl_MouseMove);
            _pl.MouseUp += new MouseEventHandler(this.panCtrl_MouseUp);
            _pl.Visible = false;
            _frm.Controls.Add(_pl);
            _frm.Controls.SetChildIndex(_pl, 0);

            _cmb.Location = new System.Drawing.Point(3, 3);
            _cmb.Width = 75;
            _cmb.Height = 22;
            _cmb.SelectedIndexChanged += new EventHandler(this.CmbSelectedIndexChanged);
            _pl.Controls.Add(_cmb);

            _bt2.Text = "Del";
            _bt2.Location = new System.Drawing.Point(84, 3);
            _bt2.Width = 47;
            _bt2.Height = 20;
            _bt2.Click += new EventHandler(this.Btn2Click);
            _pl.Controls.Add(_bt2);


            _bt3.Text = "Save";
            _bt3.Location = new System.Drawing.Point(137, 3);
            _bt3.Width = 47;
            _bt3.Height = 20;
            _bt3.Click += new EventHandler(this.Btn3Click);
            _pl.Controls.Add(_bt3);


            _btExit.Text = "Cancel";
            _btExit.Location = new System.Drawing.Point(190, 3);
            _btExit.Width = 47;
            _btExit.Height = 20;
            _btExit.Click += new EventHandler(this.BtnExitClick);
            _pl.Controls.Add(_btExit);

            _cmb.Items.Add("All");
            _cmb.SelectedIndex = 0;
        }

        private void panCtrl_MouseMove(object sender, MouseEventArgs e)
        {
            if (isMouseDown == true)
            {
                this._pl.Location = new System.Drawing.Point(0, this._pl.Location.Y + e.Y - StaY);
            }
        }

        private void panCtrl_MouseDown(object sender, MouseEventArgs e)
        {
            StaX = e.X;
            StaY = e.Y;
            isMouseDown = true;
        }

        private void panCtrl_MouseUp(object sender, MouseEventArgs e)
        {
            isMouseDown = false;
        }

        //Delete Nodes
        private void Btn2Click(object sender, EventArgs e)
        {
            if (_cmb.SelectedItem.ToString() == "All")
            {
                BtnExitClick(null, null);
            }
            else
            {
                MePic.Delete(_cmb.SelectedIndex - 1);
                _cmb.Items.RemoveAt(_cmb.SelectedIndex);
                picSd = null;
                _cmb.SelectedIndex = _cmb.Items.Count - 1;
            }
        }
        //Save changes
        protected virtual void Btn3Click(object sender, EventArgs e)
        {
            IGeometry geo = null;
            IPointCollection ptColl = null;
            switch (_feat.Shape.Type)
            {
                case GeometryType.Point:

                    if (listPoint.Count > 0)
                    {
                        geo = (IGeometry)listPoint[0];
                    }
                    break;
                case GeometryType.Polygon:
                    ptColl = new PolygonClass();
                    break;
                case GeometryType.Polyline:
                    ptColl = new PolylineClass();
                    break;
            }
            if (listPoint.Count == 0)
            {
                _feat.Shape = null;
            }
            else 
            {
                if (geo == null) 
                {
                    for (int i = 0; i < listPoint.Count; i++) 
                    {
                        ptColl.AddPoint(listPoint[i]);
                    }
                    geo = (IGeometry)ptColl;
                }
                _feat.Shape = geo;
            }
            _feat.Save();
            this.Map.MapRefresh();
            _pl.Visible = false;
            BtnExitClick(null, null);
        }

        //Cancel
        protected virtual void BtnExitClick(object sender, EventArgs e)
        {
            listPoint.Clear();
            listPoint1.Clear();
            this.MePic.Clear();
            this.Map.MapRefresh();
            _pl.Visible = false;

            _cmb.Items.Clear();
            _cmb.Items.Add("All");
            _cmb.SelectedIndex = 0;
        }

        private void CmbSelectedIndexChanged(object sender, EventArgs e)
        {
            if (picSd != null)
            {
                picSd.BackColor = System.Drawing.Color.Red;
            }
            if (_cmb.SelectedItem.ToString() != "All")
            {
                MePic[_cmb.SelectedIndex - 1].BackColor = System.Drawing.Color.Blue;
                picSd = MePic[_cmb.SelectedIndex - 1];
            }
        }
    }
}
