﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;

using HiMap.Carto;
using HiMap.MapControls.Tools;
using HiMap.Geometry;

namespace HiMap
{
    public class ToolSelected:ToolClass
    {
        protected IFeatureLayer _layer;
        protected int StaX, StaY;
        protected bool isMouseDown;
        protected Panel _pl;
        protected Button _bt3;
        protected Button _btExit;
        protected Form _frm;
        protected ComboBox _cmb;
       
        internal List<IFeature> list;
        public ToolSelected(Form frm, IFeatureLayer layer) 
        {
            _frm=frm;
            
            _layer = layer;
            
            list = new List<IFeature>();
            this.CreateControls();
        }


        protected override void OnMouseDown(object sender, MouseEventArgs e)
        {
            //Spatial query
            IPoint pt = this.Map.PointToMapPoint(e.X, e.Y);
            IEnvelope el = Map.Map.Envelope;
            ISpatialFilter sf = new SpatialFilterClass();
            sf.Geometry = pt;
            sf.Buffer = 20;

            IFeature feat = null;
            IFeatureCursor fc = null;
            IFeatureClass cls = null;
            IFeatureLayer layer = null;
            list = new List<IFeature>();
            _cmb.Items.Clear();

            //Get data by querying
            for (int i = 0; i < this.Map.Map.LayerCount; i++)
            {
                layer = (IFeatureLayer)Map.Map.GetLayer(i);
                cls = (IFeatureClass)Map.Map.GetLayer(i).Class;
                fc = cls.Search(sf);
                fc.Flush();
                feat = fc.Next();
                while (feat != null)
                {
                    list.Add(feat);
                    _cmb.Items.Add("Layer: " + layer.Caption + " " + "Name: " + feat.GetValue(0).ToString());
                    feat = fc.Next();
                }
            }
            //Calculate the location where toolbar at
            if (e.Y + _pl.Height + 5 > this.Map.Height)
            {
                _pl.Location = new System.Drawing.Point(_pl.Location.X, e.Y - 5);
            }
            else
            {
                _pl.Location = new System.Drawing.Point(_pl.Location.X, e.Y + _pl.Height + 5);
            }

            if (_cmb.Items.Count > 0)
            {
                _cmb.SelectedIndex = 0;
            }


            _pl.Visible = true;

        }
        //Get all points of a geometry
        private IPoint[] getPts(IGeometry geo) 
        {
            IPointCollection ptColl = (IPointCollection)geo;
            IPoint[] pts = new PointClass[ptColl.PointCount];
            for (int i = 0; i < ptColl.PointCount; i++) 
            {
                pts[i] = new PointClass();
                pts[i] = ptColl.GetPoint(i);
            }
            return pts;
        }

        //Select the feature which has beed selected in combobox
        protected virtual void Btn3Click(object sender, EventArgs e)
        {
            if (_cmb.SelectedIndex == -1) 
            {
                return;
            }

            IFeature feat = list[_cmb.SelectedIndex];
            AppInfo.SelectedFeature = feat;
            IGeometry geo = feat.Shape;

            Map.MapRefresh();

            switch (geo.Type)
            {
                case GeometryType.Point:
                    IPoint pt = (IPoint)geo;
                    System.Drawing.Point pt1 = Map.MapToScreen(pt.X, pt.Y);

                    Map.DrawPoint(new System.Drawing.Pen(System.Drawing.Color.FromArgb(128, 255, 255))
                        , new System.Drawing.SolidBrush(System.Drawing.Color.FromArgb(128, 255, 255))
                        , new System.Drawing.Rectangle(pt1.X - 4, pt1.Y - 4, 7, 7));
                    break;
                case GeometryType.Polygon:
                    Map.DrawPolygon(new System.Drawing.Pen(System.Drawing.Color.FromArgb(128, 255, 255))
                        , new System.Drawing.SolidBrush(System.Drawing.Color.FromArgb(128, 255, 255))
                        , getPts(geo));
                    break;
                case GeometryType.Polyline:
                    Map.DrawLine(new System.Drawing.Pen(System.Drawing.Color.FromArgb(128, 255, 255))
                        , getPts(geo));
                    break;
            }
            _pl.Visible = false;
        }

        //Cancel
        protected virtual void BtnExitClick(object sender, EventArgs e)
        {
            AppInfo.SelectedFeature = null;
            this.Map.MapRefresh();
            _pl.Visible = false;
            _cmb.Items.Clear();
        }

        private void CmbSelectedIndexChanged(object sender, EventArgs e)
        {
            
        }

        //Create controls which used by itself
        private void CreateControls()
        {
            _pl = new Panel();
            _bt3 = new Button();
            _btExit = new Button();
            _cmb = new ComboBox();


            _pl.Width = 240;
            _pl.Height = 27;
            _pl.BackColor = System.Drawing.Color.FromArgb(192, 192, 192);
            _pl.MouseDown += new MouseEventHandler(this.panCtrl_MouseDown);
            _pl.MouseMove += new MouseEventHandler(this.panCtrl_MouseMove);
            _pl.MouseUp += new MouseEventHandler(this.panCtrl_MouseUp);
            _pl.Visible = false;
            _frm.Controls.Add(_pl);
            _frm.Controls.SetChildIndex(_pl, 0);



            _cmb.Location = new System.Drawing.Point(3, 3);
            _cmb.Width = 131;
            _cmb.Height = 22;
            _cmb.SelectedIndexChanged += new EventHandler(this.CmbSelectedIndexChanged);
            _pl.Controls.Add(_cmb);



            _bt3.Text = "V";
            _bt3.Location = new System.Drawing.Point(137, 3);
            _bt3.Width = 47;
            _bt3.Height = 20;
            _bt3.Click += new EventHandler(this.Btn3Click);
            _pl.Controls.Add(_bt3);


            _btExit.Text = "X";
            _btExit.Location = new System.Drawing.Point(190, 3);
            _btExit.Width = 47;
            _btExit.Height = 20;
            _btExit.Click += new EventHandler(this.BtnExitClick);
            _pl.Controls.Add(_btExit);


        }

        private void panCtrl_MouseMove(object sender, MouseEventArgs e)
        {
            if (isMouseDown == true)
            {
                this._pl.Location = new System.Drawing.Point(0, this._pl.Location.Y + e.Y - StaY);
            }
        }

        private void panCtrl_MouseDown(object sender, MouseEventArgs e)
        {
            StaX = e.X;
            StaY = e.Y;
            isMouseDown = true;
        }

        private void panCtrl_MouseUp(object sender, MouseEventArgs e)
        {
            isMouseDown = false;
        }

        protected override void OnToolUpdated(object sender, EventArgs e)
        {
            _frm.Controls.Remove(_bt3);
            _frm.Controls.Remove(_btExit);
            _frm.Controls.Remove(_cmb);
            _frm.Controls.Remove(_pl);
            BtnExitClick(null, null);
        }
    }
}
