﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using HiMap.Carto;
using HiMap.MapControls.Tools;
using HiMap.Geometry;

namespace HiMap
{
    public partial class FrmLayers : Form
    {
        MapControls.MapControl _Map;
        IFeatureLayer lyr;
        public FrmLayers(MapControls.MapControl Map)
        {
            InitializeComponent();
            _Map = Map;
            this.layerControlForCombox1.Map = Map;
        }

        private void layerControlForCombox1_LayerSelect(object sender, TreeViewEventArgs e)
        {
            lyr = (IFeatureLayer)this.layerControlForCombox1.GetLayer();

            this.txtName.Text = lyr.Caption;

            IFeatureClass cls = (IFeatureClass)lyr.Class;

            this.Cmblabel.Items.Clear();
            this.Cmblabel.Items.Add("Nothing");
            for (int i = 0; i < cls.Fields.FieldCount; i++) 
            {
                this.Cmblabel.Items.Add(cls.Fields.GetField(i).Name);
            }
            int labelIndex = lyr.LableFieldIndex;
            if (labelIndex < 0)
            {
                this.Cmblabel.SelectedIndex = 0;
            }
            else 
            {
                this.Cmblabel.SelectedIndex = labelIndex + 1;
            }
            this.cmbVisible.SelectedIndex = Convert.ToInt32(lyr.Visible);
            this.txtLayerMaxScale.Text = lyr.MaxVisibleScale.ToString();
            this.txtLayerMinScale.Text = lyr.MinVisibleScale.ToString();
            this.txtLabelMaxScale.Text = lyr.MaxLabelVisibleScale.ToString();
            this.txtLabelMinScale.Text = lyr.MinLabelVisibleScale.ToString();
        }

        private void menuItem1_Click(object sender, EventArgs e)
        {
            if (lyr == null) 
            {
                MessageBox.Show("Please select a layer");
            }
            lyr.Caption = this.txtName.Text;

            IFeatureClass cls = (IFeatureClass)lyr.Class;
            if (Cmblabel.SelectedItem.ToString() == "Nothing")
            {
                lyr.LableFieldIndex = -1;
            }
            else 
            {
                int index = cls.Fields.FindField(Cmblabel.SelectedItem.ToString());
                lyr.LableFieldIndex = index;
            }
            lyr.Visible = Convert.ToBoolean(this.cmbVisible.SelectedIndex);
            lyr.MaxVisibleScale = Convert.ToDouble(this.txtLayerMaxScale.Text);
            lyr.MinVisibleScale = Convert.ToDouble(this.txtLayerMinScale.Text);
            lyr.MaxLabelVisibleScale = Convert.ToDouble(this.txtLabelMaxScale.Text);
            lyr.MinLabelVisibleScale = Convert.ToDouble(this.txtLabelMinScale.Text);
            MessageBox.Show("Layer" + lyr.Caption + ": property setup successful!");
        }

        private void menuItem2_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void FrmLayers_Load(object sender, EventArgs e)
        {
            if (_Map != null)
            {
                try
                {
                    this.txtCurrentScale.Text = _Map.Map.MapScale.ToString("G");
                }
                catch (Exception ex)
                {
                    this.txtCurrentScale.Text = "";
                }
            }
        }
    }
}