unit Login;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls;

type
  TFormLogin = class(TForm)
    efUser: TEdit;
    efPassword: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    btnLogin: TButton;
    Label3: TLabel;
    lstDatabase: TListView;
    btnCancel: TButton;
    efDb: TEdit;
    procedure btnLoginClick(Sender: TObject);
    procedure btnCancelClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure lstDatabaseClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FormLogin: TFormLogin;

implementation

uses Main, ZylVSS;

{$R *.dfm}

procedure TFormLogin.btnLoginClick(Sender: TObject);
var
  Error: WideString;
begin
  if (efUser.Text <> '') and (Trim(efDb.Text) <> '') then
  begin
    if frmMain.cmpVSS.OpenDatabase(efDb.Text, efUser.Text, efPassword.Text, Error) then
      ModalResult := mrOK
    else
      MessageDlg('Invalid User Name or Password!', mtError, [mbOK], 0);
  end;
end;

procedure TFormLogin.btnCancelClick(Sender: TObject);
begin
  Close;
end;

procedure TFormLogin.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
end;

procedure TFormLogin.FormCreate(Sender: TObject);
var
  lstDbName, lstDbPath: TStringList;
  i: Integer;
  li: TListItem;
begin
  lstDbName := frmMain.cmpVss.GetDatabaseNames;
  lstDbPath := frmMain.cmpVss.GetDatabasePaths;
  for i := 0 to lstDbName.Count - 1 do
  begin
    li := lstDatabase.Items.Add;
    li.Caption := lstDbName[i];
    li.SubItems.Add(lstDbPath[i]);
  end;
  lstDbName.Free;
  lstDbPath.Free;
end;

procedure TFormLogin.lstDatabaseClick(Sender: TObject);
begin
  if lstDatabase.Selected <> nil then
  begin
    efDb.Text := lstDatabase.Selected.SubItems[0]
  end;
end;

end.
