unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, ZylIdleTimer, StdCtrls, ExtCtrls, AppEvnts;

type
  TForm1 = class(TForm)
    tmIdle: TZylIdleTimer;
    Timer1: TTimer;
    Label1: TLabel;
    Memo: TMemo;
    Label2: TLabel;
    rgKind: TRadioGroup;
    btnStart: TButton;
    btnStop: TButton;
    procedure Timer1Timer(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure tmIdleIdle(Sender: TObject);
    procedure tmIdleResume(Sender: TObject);
    procedure rgKindClick(Sender: TObject);
    procedure btnStartClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.Timer1Timer(Sender: TObject);
begin
  Label1.Caption := 'System Idle Time: ' + IntToStr(tmIdle.GetSystemIdleTime) + ' ms';
  Label2.Caption := 'Application Idle Time: ' + IntToStr(tmIdle.GetApplicationIdleTime) + ' ms';
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  tmIdle.Enabled := false;
end;

procedure TForm1.tmIdleIdle(Sender: TObject);
begin
  if tmIdle.Kind = itSystem then
    Memo.Lines.Add('System Idle Time Expired!')
  else
    Memo.Lines.Add('Application Idle Time Expired!');
end;

procedure TForm1.tmIdleResume(Sender: TObject);
begin
  if tmIdle.Kind = itSystem then
    Memo.Lines.Add('System Idle Time Resumed!')
  else
    Memo.Lines.Add('Application Idle Time Resumed!');
end;

procedure TForm1.rgKindClick(Sender: TObject);
begin
  if rgKind.ItemIndex = 0 then
    tmIdle.Kind := itSystem
  else
    tmIdle.Kind := itApplication;  
end;

procedure TForm1.btnStartClick(Sender: TObject);
begin
  if rgKind.ItemIndex = 0 then
    tmIdle.Kind := itSystem
  else
    tmIdle.Kind := itApplication;
  tmIdle.Enabled := True;
end;

procedure TForm1.btnStopClick(Sender: TObject);
begin
  tmIdle.Enabled := False;
end;

end.
