unit FDemo;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, ZylAppCommunicator, StdCtrls, ComCtrls;

type
  TTestStruct = record
    Id: ShortString;
    Name: ShortString;
    DateOfBirth: TDateTime;
  end;


  TForm1 = class(TForm)
    appComm: TZylAppCommunicator;
    btnSendString: TButton;
    btnSendData: TButton;
    efText: TEdit;
    efId: TEdit;
    efName: TEdit;
    efDate: TDateTimePicker;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    procedure btnSendStringClick(Sender: TObject);
    procedure appCommReceive(Sender: TObject; SenderHandle: HWND;
      BufferType: Integer; Buffer: TStream);
    procedure btnSendDataClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.btnSendStringClick(Sender: TObject);
begin
  if Trim(efText.Text) <> '' then
    appComm.SendString(efText.Text);
end;

procedure TForm1.appCommReceive(Sender: TObject; SenderHandle: HWND;
  BufferType: Integer; Buffer: TStream);
var
  strPacket: String;
  data: TTestStruct;
begin
  //string
  if BufferType = 0 then
  begin
    SetLength(strPacket, Buffer.Size);
    Buffer.ReadBuffer(strPacket[1], Length(strPacket));
    ShowMessage(strPacket);
  end
  else
  //custom
  begin
    Buffer.ReadBuffer(data, SizeOf(TTestStruct));
    ShowMessage('Id: ' + data.Id + #10#13 + 'Name: ' + data.Name + #10#13 + 'DateOfBirth: ' + DateTimeToStr(data.DateOfBirth));
  end;
end;

procedure TForm1.btnSendDataClick(Sender: TObject);
var
  data: TTestStruct;
begin
  data.Id := efId.Text;
  data.Name := efName.Text;
  data.DateOfBirth := efDate.DateTime;
  appComm.SendBuffer(data, SizeOf(TTestStruct), 1);
end;

end.
