unit IWUnit1;
{PUBDIST}

interface

uses
  IWAppForm, IWApplication, IWTypes, HBarcode, Graphics, IWCompButton, Classes,
  Controls, IWControl, IWExtCtrls, IWCompEdit, IWCompListbox,
  IWCompCheckbox, IWCompLabel, SysUtils, SWSystem;

type
  TformMain = class(TIWAppForm)
    IWButton1: TIWButton;
    edtBarcode: TIWEdit;
    IWImage1: TIWImage;
    IWLabel1: TIWLabel;
    IWLabel2: TIWLabel;
    IWLabel3: TIWLabel;
    IWLabel4: TIWLabel;
    chkCheckSum: TIWCheckBox;
    IWLabel5: TIWLabel;
    edtLeft: TIWEdit;
    IWLabel6: TIWLabel;
    edtTop: TIWEdit;
    IWLabel7: TIWLabel;
    edtHeight: TIWEdit;
    IWLabel8: TIWLabel;
    edtAngle: TIWEdit;
    cmbBarType: TIWComboBox;
    cmbModul: TIWComboBox;
    cmbRatio: TIWComboBox;
    cmbBackColor: TIWComboBox;
    cmbBarColor: TIWComboBox;
    cmbSpaceColor: TIWComboBox;
    cmbTextColor: TIWComboBox;
    labBackColor: TIWLabel;
    labBarColor: TIWLabel;
    IWLabel9: TIWLabel;
    TextSize: TIWLabel;
    cmbTextSize: TIWComboBox;
    IWLabel10: TIWLabel;
    cmbTextFont: TIWComboBox;
    IWLabel11: TIWLabel;
    IWLabel12: TIWLabel;
    cmbTextBackColor: TIWComboBox;
    IWLabel13: TIWLabel;
    cmbTextPost: TIWComboBox;
    IWLabel14: TIWLabel;
    IWLabel15: TIWLabel;
    cmbTextShow: TIWComboBox;
    chkBold: TIWCheckBox;
    chkItalic: TIWCheckBox;
    chkUnderline: TIWCheckBox;
    chkStrikeOut: TIWCheckBox;
    chkBitmap: TIWCheckBox;
    procedure IWButton1Click(Sender: TObject);
  public
  end;

implementation
{$R *.dfm}

uses
  ServerController;

procedure TformMain.IWButton1Click(Sender: TObject);
const
  Color : array[0..17] of TColor = (
    TColor($000000),
    TColor($000080),
    TColor($008000),
    TColor($008080),
    TColor($800000),
    TColor($800080),
    TColor($808000),
    TColor($808080),
    TColor($C0C0C0),
    TColor($0000FF),
    TColor($00FF00),
    TColor($00FFFF),
    TColor($FF0000),
    TColor($FF00FF),
    TColor($FFFF00),
    TColor($C0C0C0),
    TColor($808080),
    TColor($FFFFFF)
  );

var
 Bmp: TBitmap;
 F: TFont;
 c: TCheckSum;

begin
  Bmp := TBitmap.Create ;
  try
    Bmp.Height :=200;
    Bmp.Width := 500;
    Bmp.Canvas.Brush.Color := Color[cmbBackColor.ItemIndex];
    Bmp.Canvas.Rectangle(0,0,Bmp.Width,Bmp.Height);
    if chkBitmap.Checked then Bmp.LoadFromFile(gsAppPath + 'Back.bmp');
    IWImage1.Picture.Bitmap := Bmp;
    if chkCheckSum.Checked then c := csModulo10 else c := csNone;
    F := TFont.Create;
    try
      if cmbTextFont.ItemIndex <> -1 then
        F.Name := cmbTextFont.Text;
      F.Size := cmbTextSize.ItemIndex + 7;
      F.Color := Color[cmbTextColor.ItemIndex];
      F.Style := [];
      if chkBold.Checked then F.Style := F.Style + [fsBold];
      if chkItalic.Checked then F.Style := F.Style + [fsItalic];
      if chkUnderLine.Checked then F.Style := F.Style + [fsUnderline];
      if chkStrikeOut.Checked then F.Style := F.Style + [fsStrikeOut];
      H_DrawBar(
        IWImage1.Picture.Bitmap.Canvas ,
        TBarType(cmbBarType.ItemIndex),
        Trim(edtBarcode.Text),
        cmbModul.ItemIndex + 1 ,
        (cmbRatio.ItemIndex + 1)*0.5+1,
        c,
        StrToIntDef(edtLeft.Text,10),
        StrToIntDef(edtTop.Text,10),
        StrToIntDef(edtHeight.Text,50),
        F,
        TTextShow(cmbTextShow.ItemIndex),
        TTextPosition(cmbTextPost.ItemIndex),
        Color[cmbBarColor.ItemIndex],
        Color[cmbSpaceColor.ItemIndex],
        Color[cmbTextBackColor.ItemIndex],
        StrToIntDef(edtAngle.Text,0)
        );
    finally
      F.Free;
    end;
  finally
    Bmp.Free;
  end;
end;

end.
