<?php
$sql="

DROP TABLE `address`;
DROP TABLE `people`;
DROP TABLE `connects`;
DROP TABLE `groups`;
DROP TABLE `projects`;
DROP TABLE `products`;
DROP TABLE `jpeopeo`;
DROP TABLE `jpeoadd`;
DROP TABLE `jpeocon`;
DROP TABLE `jpeoprj`;
DROP TABLE `jpeoprd`;
DROP TABLE `jpeogrp`;
DROP TABLE `jgrpcon`;
DROP TABLE `jgrpadd`;
DROP TABLE `jgrpprd`;
DROP TABLE `jgrpprj`;
DROP TABLE `jgrpgrp`;
DROP TABLE `jprjprj`;
DROP TABLE `login`;
DROP TABLE `notes`;


CREATE TABLE `address` (
  `add_id` int(11) NOT NULL auto_increment,
  `st_number` varchar(255) collate latin1_general_ci default NULL,
  `address1` varchar(255) collate latin1_general_ci default NULL,
  `address2` varchar(255) collate latin1_general_ci default NULL,
  `city` varchar(255) collate latin1_general_ci default NULL,
  `state` varchar(255) collate latin1_general_ci default NULL,
  `zip` varchar(255) collate latin1_general_ci default NULL,
  `country` varchar(255) collate latin1_general_ci default NULL,
  `user_id` int(11) NOT NULL default '0',
  `created` datetime default NULL,
  `updated` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`add_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci AUTO_INCREMENT=11 ;




CREATE TABLE `connects` (
  `con_id` int(11) NOT NULL auto_increment,
  `con_type` varchar(255) collate latin1_general_ci default NULL,
  `con_value` varchar(255) collate latin1_general_ci default NULL,
  `user_id` int(11) NOT NULL default '0',
  `created` datetime default NULL,
  `updated` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`con_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci AUTO_INCREMENT=54 ;




CREATE TABLE `groups` (
  `grp_id` int(11) NOT NULL auto_increment,
  `name` varchar(255) collate latin1_general_ci default NULL,
  `user_id` int(11) NOT NULL default '0',
  `notes` tinyint(4) NOT NULL default '0',
  `created` datetime default NULL,
  `updated` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`grp_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci AUTO_INCREMENT=9 ;



CREATE TABLE `jgrpadd` (
  `id` int(11) NOT NULL auto_increment,
  `grp_id` int(11) NOT NULL default '0',
  `add_id` int(11) NOT NULL default '0',
  `rel` varchar(100) collate latin1_general_ci default NULL,
  `user_id` int(11) NOT NULL default '0',
  `created` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci AUTO_INCREMENT=1 ;




CREATE TABLE `jgrpcon` (
  `id` int(11) NOT NULL auto_increment,
  `grp_id` int(11) NOT NULL default '0',
  `con_id` int(11) NOT NULL default '0',
  `rel` varchar(100) collate latin1_general_ci default NULL,
  `user_id` int(11) NOT NULL default '0',
  `created` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci AUTO_INCREMENT=1 ;


CREATE TABLE `jgrpgrp` (
  `id` int(11) NOT NULL auto_increment,
  `p_grp_id` int(11) NOT NULL default '0',
  `c_grp_id` int(11) NOT NULL default '0',
  `rel` varchar(100) collate latin1_general_ci default NULL,
  `user_id` int(11) NOT NULL default '0',
  `created` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci AUTO_INCREMENT=1 ;




CREATE TABLE `jgrpprd` (
  `id` int(11) NOT NULL auto_increment,
  `grp_id` int(11) NOT NULL default '0',
  `prd_id` int(11) NOT NULL default '0',
  `rel` varchar(100) collate latin1_general_ci default NULL,
  `user_id` int(11) NOT NULL default '0',
  `created` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci AUTO_INCREMENT=1 ;




CREATE TABLE `jgrpprj` (
  `id` int(11) NOT NULL auto_increment,
  `grp_id` int(11) NOT NULL default '0',
  `prj_id` int(11) NOT NULL default '0',
  `rel` varchar(100) collate latin1_general_ci default NULL,
  `user_id` int(11) NOT NULL default '0',
  `created` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci AUTO_INCREMENT=1 ;


CREATE TABLE `jpeoadd` (
  `id` int(11) NOT NULL auto_increment,
  `peo_id` int(11) NOT NULL default '0',
  `add_id` int(11) NOT NULL default '0',
  `rel` varchar(100) collate latin1_general_ci default NULL,
  `user_id` int(11) NOT NULL default '0',
  `created` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci AUTO_INCREMENT=2 ;



CREATE TABLE `jpeocon` (
  `id` int(11) NOT NULL auto_increment,
  `peo_id` int(11) NOT NULL default '0',
  `con_id` int(11) NOT NULL default '0',
  `rel` varchar(100) collate latin1_general_ci default NULL,
  `user_id` int(11) NOT NULL default '0',
  `created` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci AUTO_INCREMENT=6 ;


CREATE TABLE `jpeogrp` (
  `id` int(11) NOT NULL auto_increment,
  `peo_id` int(11) default NULL,
  `grp_id` int(11) default NULL,
  `rel` varchar(100) collate latin1_general_ci default NULL,
  `user_id` int(11) NOT NULL default '0',
  `created` datetime default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci AUTO_INCREMENT=2 ;



CREATE TABLE `jpeopeo` (
  `id` int(11) NOT NULL auto_increment,
  `p_peo_id` int(11) default NULL,
  `c_peo_id` int(11) default NULL,
  `rel` varchar(100) collate latin1_general_ci default NULL,
  `user_id` int(11) NOT NULL default '0',
  `created` datetime default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci AUTO_INCREMENT=2 ;




CREATE TABLE `jpeoprd` (
  `id` int(11) NOT NULL auto_increment,
  `peo_id` int(11) NOT NULL default '0',
  `prd_id` int(11) NOT NULL default '0',
  `rel` varchar(100) collate latin1_general_ci default NULL,
  `user_id` int(11) NOT NULL default '0',
  `created` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci AUTO_INCREMENT=2 ;



CREATE TABLE `jpeoprj` (
  `id` int(11) NOT NULL auto_increment,
  `peo_id` int(11) NOT NULL default '0',
  `prj_id` int(11) NOT NULL default '0',
  `rel` varchar(100) collate latin1_general_ci default NULL,
  `user_id` int(11) NOT NULL default '0',
  `created` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci AUTO_INCREMENT=2 ;



CREATE TABLE `jprjprj` (
  `id` int(11) NOT NULL auto_increment,
  `p_prj_id` int(11) NOT NULL default '0',
  `c_prj_id` int(11) NOT NULL default '0',
  `rel` varchar(100) collate latin1_general_ci default NULL,
  `user_id` int(11) NOT NULL default '0',
  `created` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci AUTO_INCREMENT=1 ;




CREATE TABLE `login` (
  `usr_id` int(11) NOT NULL auto_increment,
  `firstname` varchar(50) collate latin1_general_ci NOT NULL default '',
  `lastname` varchar(50) collate latin1_general_ci NOT NULL default '',
  `username` varchar(50) collate latin1_general_ci NOT NULL default '',
  `password` varchar(50) collate latin1_general_ci NOT NULL default '',
  `created` datetime default NULL,
  `permision` varchar(10) collate latin1_general_ci NOT NULL default 'user',
  `active` int(10) NOT NULL default '0',
  `peo_id` int(10) NOT NULL,
  `email_valid` varchar(32) collate latin1_general_ci NOT NULL,
  PRIMARY KEY  (`usr_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci AUTO_INCREMENT=23 ;




CREATE TABLE `notes` (
  `nts_id` int(11) NOT NULL auto_increment,
  `table_` varchar(50) collate latin1_general_ci default NULL,
  `join_id` int(11) NOT NULL default '0',
  `rel` varchar(100) collate latin1_general_ci default NULL,
  `category` varchar(255) collate latin1_general_ci default NULL,
  `notes` varchar(255) collate latin1_general_ci default NULL,
  `user_id` int(11) default NULL,
  `created` datetime default NULL,
  `updated` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`nts_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci AUTO_INCREMENT=1 ;




CREATE TABLE `people` (
  `peo_id` int(11) NOT NULL auto_increment,
  `prefix` varchar(255) collate latin1_general_ci default NULL,
  `first` varchar(255) collate latin1_general_ci default NULL,
  `middle` varchar(255) collate latin1_general_ci default NULL,
  `last` varchar(255) collate latin1_general_ci default NULL,
  `title` varchar(255) collate latin1_general_ci default NULL,
  `introduced` varchar(255) collate latin1_general_ci default '',
  `user_id` int(11) NOT NULL default '0',
  `notes` tinyint(4) NOT NULL default '0',
  `created` datetime default NULL,
  `updated` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`peo_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci AUTO_INCREMENT=26 ;


CREATE TABLE `products` (
  `prd_id` int(11) NOT NULL auto_increment,
  `name` varchar(255) collate latin1_general_ci default NULL,
  `code` varchar(255) collate latin1_general_ci default NULL,
  `part_number` varchar(255) collate latin1_general_ci default NULL,
  `price` varchar(50) collate latin1_general_ci default NULL,
  `user_id` int(11) NOT NULL default '0',
  `notes` tinyint(4) NOT NULL default '0',
  `created` datetime default NULL,
  `updated` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`prd_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci AUTO_INCREMENT=5 ;




CREATE TABLE `projects` (
  `prj_id` int(11) NOT NULL auto_increment,
  `name` varchar(255) collate latin1_general_ci default NULL,
  `descr` varchar(255) collate latin1_general_ci default NULL,
  `start_date` varchar(255) collate latin1_general_ci default NULL,
  `end_date` varchar(255) collate latin1_general_ci default NULL,
  `user_id` int(11) NOT NULL default '0',
  `notes` tinyint(4) NOT NULL default '0',
  `created` datetime default NULL,
  `updated` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`prj_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci AUTO_INCREMENT=5 




";
?>
