CREATE TABLE `%prefix%backlinks` (
  `id` int(11) NOT NULL auto_increment,
  `user_code` text NOT NULL,
  `check_code` text,
  `check_url` text,
  `check_preg` text,
  `check_method` enum('code','url','preg') NOT NULL default 'code',
  `sort_order` int(11) NOT NULL default '1000',
  `disabled` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `sort_order` (`sort_order`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `%prefix%bwlist` (
  `id` int(11) NOT NULL auto_increment,
  `type` enum('black','white') NOT NULL default 'black',
  `check_method` enum('substr','regexp') NOT NULL default 'substr',
  `check_str` varchar(80) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `%prefix%cats` (
  `id` int(11) NOT NULL auto_increment,
  `id_full` varchar(255) NOT NULL default '',
  `is_link` tinyint(4) NOT NULL default '0',
  `id_real` int(20) NOT NULL default '0',
  `title` varchar(255) NOT NULL default '',
  `title_full` text NOT NULL,
  `path` varchar(255) NOT NULL default '',
  `path_full` text NOT NULL,
  `parent_id` int(11) NOT NULL default '0',
  `child_id_list` text NOT NULL,
  `tree_level` int(11) NOT NULL default '0',
  `item_count` int(11) NOT NULL default '0',
  `item_count_full` int(11) NOT NULL default '0',
  `sort_order` int(11) NOT NULL default '1000',
  `sort_order_global` int(11) NOT NULL default '0',
  `meta_keywords` text,
  `meta_descr` text,
  `image` longblob NOT NULL,
  `image_mime` varchar(20) default NULL,
  `descr` text,
  `theme_id` int(11) NOT NULL default '0',
  `disable_add` tinyint(4) NOT NULL default '0',
  `disable_child_add` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `sort_order` (`parent_id`,`sort_order`,`title`),
  KEY `path_full` (`path_full`(255)),
  FULLTEXT KEY `title` (`title`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `%prefix%cnkey` (
  `cnkey` text
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `%prefix%config` (
  `name` varchar(255) NOT NULL default '',
  `value` tinytext,
  PRIMARY KEY  (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `%prefix%filters` (
  `id` int(11) NOT NULL auto_increment,
  `title` varchar(255) NOT NULL default '',
  `required` tinyint(4) NOT NULL default '0',
  `sort_order` int(11) NOT NULL default '1000',
  PRIMARY KEY  (`id`),
  KEY `sort_order` (`sort_order`,`title`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `%prefix%filtvals` (
  `id` int(11) NOT NULL auto_increment,
  `filter_id` int(11) NOT NULL default '0',
  `title` varchar(255) NOT NULL default '',
  `sort_order` int(11) NOT NULL default '1000',
  PRIMARY KEY  (`id`),
  KEY `filter_id` (`filter_id`),
  KEY `sort_order` (`sort_order`,`title`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `%prefix%itemcat` (
  `item_id` int(11) NOT NULL default '0',
  `cat_id` int(11) NOT NULL default '0',
  `priority` smallint(6) NOT NULL default '0',
  `item_status` tinyint(4) NOT NULL default '0',
  `item_type` tinyint(4) NOT NULL default '0',
  KEY `item_id` (`item_id`),
  KEY `item_status` (`item_status`,`cat_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `%prefix%itemfilt` (
  `item_id` int(11) NOT NULL default '0',
  `filtval_id` int(11) NOT NULL default '0',
  KEY `link_id` (`item_id`,`filtval_id`),
  KEY `filtval_id` (`filtval_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `%prefix%items` (
  `item_id` int(11) NOT NULL auto_increment,
  `item_status` tinyint(4) NOT NULL default '0',
  `item_type` tinyint(4) NOT NULL default '0',
  `item_title` varchar(255) default NULL,
  `item_descr` text,
  `item_descr_full` text,
  `item_meta_keywords` text,
  `item_meta_descr` text,
  `item_image` mediumblob NOT NULL,
  `item_image_mime` varchar(20) default NULL,
  `item_display_ext` tinyint(4) NOT NULL default '0',
  `item_insert_date` datetime NOT NULL default '0000-00-00 00:00:00',
  `item_submit_date` datetime NOT NULL default '0000-00-00 00:00:00',
  `item_favour` tinyint(4) NOT NULL default '0',
  `item_favour_neg` tinyint(4) NOT NULL default '0',
  `item_rating_moder` tinyint(4) NOT NULL default '0',
  `item_rating_moder_neg` int(11) NOT NULL default '0',
  `item_rating_users` tinyint(4) NOT NULL default '0',
  `item_rating_users_neg` int(11) NOT NULL default '0',
  `item_author_ip` varchar(20) default NULL,
  `item_author_email` varchar(255) default NULL,
  `item_author_name` varchar(255) default NULL,
  `item_mail_sended` tinyint(4) NOT NULL default '0',
  `link_url` text,
  `link_back_link_url` text,
  `link_favicon` blob,
  `link_favicon_url` varchar(255) default NULL,
  `link_favicon_mime` varchar(20) default NULL,
  `link_region_id` int(11) NOT NULL default '0',
  `link_broken_warning` tinyint(4) default '0',
  `link_target` tinyint(4) NOT NULL default '0',
  `link_jumps_from` int(11) NOT NULL default '0',
  `link_jumps_from_neg` int(11) NOT NULL default '0',
  `link_jumps_to` int(11) NOT NULL default '0',
  `link_jumps_to_neg` int(11) NOT NULL default '0',
  `link_rating_pr` int(11) NOT NULL default '-1',
  `link_rating_pr_neg` int(11) NOT NULL default '1',
  `link_rating_cy` int(11) NOT NULL default '-1',
  `link_rating_cy_neg` int(11) NOT NULL default '1',
  `link_pr_date` datetime NOT NULL default '0000-00-00 00:00:00',
  `link_cy_date` datetime NOT NULL default '0000-00-00 00:00:00',
  `link_chk_flag` tinyint(4) NOT NULL default '0',
  `link_chk_work_res` tinyint(4) NOT NULL default '0',
  `link_chk_work_date` datetime NOT NULL default '0000-00-00 00:00:00',
  `link_chk_back_res` tinyint(4) NOT NULL default '0',
  `link_chk_back_date` datetime NOT NULL default '0000-00-00 00:00:00',
  `link_chk_comment` text,
  `ext_text1` text,
  `ext_text2` text,
  `ext_text3` text,
  `ext_varchar1` varchar(255) default NULL,
  `ext_int1` int(11) default NULL,
  `ext_double1` double default NULL,
  `ext_datetime1` datetime default NULL,
  PRIMARY KEY  (`item_id`),
  KEY `rating_users` (`item_status`,`item_favour_neg`,`item_rating_users_neg`,`item_title`),
  KEY `rating_pr` (`item_status`,`item_favour_neg`,`link_rating_pr_neg`,`item_title`),
  KEY `rating_moder` (`item_status`,`item_favour_neg`,`item_rating_moder_neg`,`item_title`),
  KEY `rating_cy` (`item_status`,`item_favour_neg`,`link_rating_cy_neg`,`item_title`),
  KEY `title` (`item_status`,`item_favour_neg`,`item_title`),
  KEY `insert_date` (`item_status`,`item_favour`,`item_insert_date`),
  KEY `submit_date` (`item_status`,`item_favour`,`item_submit_date`,`item_insert_date`),
  KEY `new_items` (`item_status`,`item_submit_date`,`item_insert_date`),
  KEY `popularity` (`item_favour_neg`,`link_jumps_from_neg`,`link_jumps_to_neg`,`item_title`),
  KEY `status` (`item_status`),
  FULLTEXT KEY `fulltext` (`item_title`,`item_descr`,`item_descr_full`,`item_meta_keywords`,`item_meta_descr`,`link_url`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `%prefix%jumps` (
  `item_id` int(11) NOT NULL default '0',
  `ip` int(10) unsigned NOT NULL default '0',
  `type` enum('to','from') NOT NULL default 'to',
  `time` datetime NOT NULL default '0000-00-00 00:00:00',
  KEY `item_id` (`item_id`),
  KEY `ip` (`ip`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `%prefix%linkcheck` (
  `moder_id` int(11) NOT NULL default '0',
  `item_id` int(11) NOT NULL default '0',
  `check_flag` tinyint(4) NOT NULL default '0',
  KEY `moder_id` (`moder_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `%prefix%modercat` (
  `mid` int(11) default '0',
  `cid` int(11) default '0',
  KEY `mid` (`mid`),
  KEY `cid` (`cid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `%prefix%moders` (
  `id` int(11) NOT NULL auto_increment,
  `login` varchar(255) NOT NULL default '',
  `email` varchar(255) NOT NULL default '',
  `pass` varchar(32) NOT NULL default '',
  `cat_edit` tinyint(4) NOT NULL default '0',
  `cats` text NOT NULL,
  `cats_child` text NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
