<?php
/**********************************************
* 	FlippingBook Joomla! Component.
*	 Mediaparts Interactive. All rights reserved.
* 	Released under Commercial License.
*	www.page-flip-tools.com
**********************************************/
defined('_JEXEC') or die();

jimport( 'joomla.application.component.controller' );

$lang = & JFactory::getLanguage();
$lang->load('flippingbook', JPATH_COMPONENT);

class FlippingBook_config {
	var $flipOnClick = null;
	var $moveSpeed = null;
	var $closeSpeed = null;
	var $flipSound = null;
	var $loadOnDemand = null;
	var $cachePages = null;
	var $cacheSize = null;
	var $preloaderType = null;
	var $book_list_title = null;
	var $style = null;
	var $columns = null;
	var $allowPagesUnload = null;
	var $flashCookie = null;
	var $gotoSpeed = null;
	var $showUnderlyingPages = null;
	var $printIcon = null;
	var $emailIcon = null;
}

class FlippingBookController extends JController {

	function __construct( $default = array())
	{
		parent::__construct( $default );
		$this->registerTask( 'add_book' , 'editBook' );
		$this->registerTask( 'edit_book', 'editBook' );
		$this->registerTask( 'book_manager', 'showBooks' );
		$this->registerTask( 'add_page' , 'editPage' );
		$this->registerTask( 'edit_page', 'editPage' );
		$this->registerTask( 'page_manager', 'showPages' );
		$this->registerTask( 'main', 'showMain' );
		$this->registerTask( 'configuration', 'Configuration' );
		$this->registerTask( 'save_configuration', 'saveConfiguration' );
		$this->registerTask( 'apply_configuration', 'saveConfiguration' );
		$this->registerTask( 'cancel_configuration', 'cancelConfiguration' );
		$this->registerTask( 'save_book', 'saveBook');
		$this->registerTask( 'apply_book', 'saveBook');
		$this->registerTask( 'remove_book', 'removeBook');
		$this->registerTask( 'save_page', 'savePage');
		$this->registerTask( 'apply_page', 'savePage');
		$this->registerTask( 'remove_page', 'removePage');
		$this->registerTask( 'publish', 'publish');
		$this->registerTask( 'unpublish', 'publish');
		$this->registerTask( 'cancel_book', 'cancelBook');
		$this->registerTask( 'cancel_page', 'cancelPage');
		$this->registerTask( 'orderup_book', 'reorder_books' );
		$this->registerTask( 'orderdown_book', 'reorder_books' );
		$this->registerTask( 'orderup_page', 'reorder_pages' );
		$this->registerTask( 'orderdown_page', 'reorder_pages' );
		$this->registerTask( 'savepageorder', 'savePageOrder' );
		$this->registerTask( 'file_manager', 'manageFiles' );
		$this->registerTask( 'upload_file', 'saveUploadedFiles' );
		$this->registerTask( 'delete_file', 'remove_rename_File' );
		$this->registerTask( 'rename_file', 'remove_rename_File' );
	}
	
	function reorder_books() {
		global $mainframe;
		$db		=& JFactory::getDBO();
		$this->setRedirect( 'index.php?option=com_flippingbook&task=book_manager' );

		$cid 	= JRequest::getVar( 'cid', array(), 'post', 'array' );
		JArrayHelper::toInteger($cid);

		$task	= $this->getTask();
		$inc	= ($task == 'orderup_book' ? -1 : 1);

		if (empty( $cid )) {
			return JError::raiseWarning( 500, 'No items selected' );
		}

		$row =& JTable::getInstance('flippingbook', 'Table');
		$row->load( (int) $cid[0] );
		$row->move( $inc );
		$row->reorder();
	}
	
	function reorder_pages() {
		global $mainframe;
		$db		=& JFactory::getDBO();
		$this->setRedirect( 'index.php?option=com_flippingbook&task=page_manager' );

		$cid 	= JRequest::getVar( 'cid', array(), 'post', 'array' );
		JArrayHelper::toInteger($cid);

		$task	= $this->getTask();
		$inc	= ($task == 'orderup_page' ? -1 : 1);

		if (empty( $cid )) {
			return JError::raiseWarning( 500, 'No items selected' );
		}

		$row =& JTable::getInstance('flippingpage', 'Table');
		$row->load( (int) $cid[0] );
		$row->move( $inc, "book_id = $row->book_id" );
		$row->reorder("book_id = $row->book_id");
	}
	
	function savePageOrder() {
		global $mainframe;
		$db			= & JFactory::getDBO();
		$cid		= JRequest::getVar( 'cid', array(0), 'post', 'array' );
		$order		= JRequest::getVar( 'order', array (0), 'post', 'array' );
		$total		= count( $cid );
		
		JArrayHelper::toInteger($cid, array(0));
		JArrayHelper::toInteger($order, array(0));

		$conditions = array();

		$row =& JTable::getInstance('flippingpage', 'Table');
		
		for( $i=0; $i < $total; $i++ ) {
		echo $cid[$i].'<br>';
			$row->load( (int) $cid[$i] );
			if ($row->ordering != $order[$i]) {
				$row->ordering = $order[$i];
				if (!$row->store()) {
					echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
					exit();
				}
			$condition = "book_id = $row->book_id";
				$found = false;
				foreach ( $conditions as $cond )
					if ($cond[1]==$condition) {
						$found = true;
						break;
					}
				if (!$found) $conditions[] = array($row->id, $condition);
			}
		}
		foreach ( $conditions as $cond ) {
			$row->load( $cond[0] );
			$row->reorder( $cond[1] );
		}
		$link = 'index.php?option=com_flippingbook&task=page_manager';
		$this->setRedirect($link);
}
	
	function showMain() {
		require_once( JPATH_COMPONENT.DS.'views'.DS.'books'.DS.'view.php' );
		BookView::showMain();
	}
	
	function Configuration() {
		//Loading configuration
		$db	=& JFactory::getDBO();
		$query = "SELECT name, value FROM #__flippingbook_config";
		$db->setQuery($query);
		$db->query() or die($db->stderr());
		$rows = $db->loadObjectList();
		foreach ( $rows as $row ) {
			eval ('$FlippingBook_config->' . $row->name . " = '" . $row->value . "';");
		}
		
		$folder = JPATH_SITE.DS.'components'.DS.'com_flippingbook'.DS.'css';
		$files = JFolder::files($folder, '.css$');
		if (count($files) > 0) {
			foreach ($files as $file) {
				$filecss[] = JHTML::_('select.option', $file, $file);
			}
		} else {
			$filecss[] = JHTML::_('select.option', '', JText::_( 'None' ));
		}
		$lists['css_files'] = JHTML::_('select.genericlist',  $filecss, 'style', 'class="inputbox" size="1"', 'value', 'text', $FlippingBook_config->style);
		
		$folderMP3 = JPATH_SITE.DS.'images'.DS.'flippingbook';
		$filesMP3 = JFolder::files($folderMP3, '.mp3$');
		if (count($filesMP3) > 0) {
			foreach ($filesMP3 as $file) {
				$fileMP3[] = JHTML::_('select.option', 'images/flippingbook/'.$file, $file);
			}
		} else {
				$fileMP3[] = JHTML::_('select.option', '', JText::_( 'None' ));
		}
		$lists['mp3_files'] = JHTML::_('select.genericlist',  $fileMP3, 'flipSound', 'class="inputbox" size="1"', 'value', 'text', $FlippingBook_config->flipSound);
		
		for ($i=1; $i<11; $i++) {
			$columns[] = JHTML::_('select.option', $i, $i);
			$lists['columns'] = JHTML::_('select.genericlist',  $columns, 'columns', 'class="inputbox" size="1"', 'value', 'text', $FlippingBook_config->columns);
		}
		
		$bookListStyle[] = JHTML::_('select.option', 'blog', JText::_( 'Blog style' ) );
		$bookListStyle[] = JHTML::_('select.option', 'images', JText::_( 'Images' ) );
		$bookListStyle[] = JHTML::_('select.option', 'images_title', JText::_( 'Images with title' ) );
		$bookListStyle[] = JHTML::_('select.option', 'list', JText::_( 'List' ) );
		$lists['bookListStyle'] = JHTML::_('select.genericlist',  $bookListStyle, 'bookListStyle', 'class="inputbox" size="1"', 'value', 'text', $FlippingBook_config->bookListStyle);
		
		$preloader[] = JHTML::_('select.option', 'None', JText::_( 'None' ) );
		$preloader[] = JHTML::_('select.option', 'Round', JText::_( 'Round' ) );
		$preloader[] = JHTML::_('select.option', 'Progress Bar', JText::_( 'Progress Bar' ) );
		$lists['preloader'] = JHTML::_('select.genericlist',  $preloader, 'preloaderType', 'class="inputbox" size="1"', 'value', 'text', $FlippingBook_config->preloaderType);
		
		require_once( JPATH_COMPONENT.DS.'views'.DS.'books'.DS.'view.php' );
		BookView::Configuration($FlippingBook_config, $lists);
	}
	
	function saveConfiguration() {
		global $option, $task;
		$db	=& JFactory::getDBO();
		$query = array();
		$query[] = "UPDATE #__flippingbook_config SET value = '".JRequest::getVar( 'flipOnClick', 0, '', 'int' )."' WHERE name = 'flipOnClick'";
		$query[] = "UPDATE #__flippingbook_config SET value = '".JRequest::getVar( 'moveSpeed', 0, '', 'int' )."' WHERE name = 'moveSpeed'";
		$query[] = "UPDATE #__flippingbook_config SET value = '".JRequest::getVar( 'closeSpeed', 0, '', 'int' )."' WHERE name = 'closeSpeed'";
		$query[] = "UPDATE #__flippingbook_config SET value = '".JRequest::getVar( 'flipSound', 0, '', 'path' )."' WHERE name = 'flipSound'";
		$query[] = "UPDATE #__flippingbook_config SET value = '".JRequest::getVar( 'loadOnDemand', 0, '', 'int' )."' WHERE name = 'loadOnDemand'";
		$query[] = "UPDATE #__flippingbook_config SET value = '".JRequest::getVar( 'cachePages', 0, '', 'int' )."' WHERE name = 'cachePages'";
		$query[] = "UPDATE #__flippingbook_config SET value = '".JRequest::getVar( 'cacheSize', 0, '', 'int' )."' WHERE name = 'cacheSize'";
		$query[] = "UPDATE #__flippingbook_config SET value = '".JRequest::getVar( 'preloaderType', 0, '', 'string' )."' WHERE name = 'preloaderType'";
		$query[] = "UPDATE #__flippingbook_config SET value = '".JRequest::getVar( 'book_list_title', 0, '', 'string' )."' WHERE name = 'book_list_title'";
		$query[] = "UPDATE #__flippingbook_config SET value = '".JRequest::getVar( 'bookListStyle', 0, '', 'string' )."' WHERE name = 'bookListStyle'";
		$query[] = "UPDATE #__flippingbook_config SET value = '".JRequest::getVar( 'style', 0, '', 'string' )."' WHERE name = 'style'";
		$query[] = "UPDATE #__flippingbook_config SET value = '".JRequest::getVar( 'columns', 0, '', 'int' )."' WHERE name = 'columns'";
		$query[] = "UPDATE #__flippingbook_config SET value = '".JRequest::getVar( 'allowPagesUnload', 0, '', 'int' )."' WHERE name = 'allowPagesUnload'";
		$query[] = "UPDATE #__flippingbook_config SET value = '".JRequest::getVar( 'flashCookie', 0, '', 'int' )."' WHERE name = 'flashCookie'";
		$query[] = "UPDATE #__flippingbook_config SET value = '".JRequest::getVar( 'gotoSpeed', 0, '', 'int' )."' WHERE name = 'gotoSpeed'";
		$query[] = "UPDATE #__flippingbook_config SET value = '".JRequest::getVar( 'showUnderlyingPages', 0, '', ' int' )."' WHERE name = 'showUnderlyingPages'";
		$query[] = "UPDATE #__flippingbook_config SET value = '".JRequest::getVar( 'printIcon', 0, '', ' int' )."' WHERE name = 'printIcon'";
		$query[] = "UPDATE #__flippingbook_config SET value = '".JRequest::getVar( 'emailIcon', 0, '', ' int' )."' WHERE name = 'emailIcon'";
		foreach ($query as $query_string) {
			$db->setQuery($query_string);
			$db->query() or die($db->stderr());
		}
		switch ($this->_task)
		{
			case 'apply_configuration':
				$msg = JText::_( 'Changes to Book saved' );
				$link = 'index.php?option=com_flippingbook&task=configuration';
				break;

			case 'save_configuration':
			default:
				$msg = JText::_( 'Book saved' );
				$link = 'index.php?option=com_flippingbook&task=main';
				break;
		}
		$this->setRedirect($link);
	}
	
	function cancelConfiguration() {
		require_once( JPATH_COMPONENT.DS.'views'.DS.'books'.DS.'view.php' );
		BookView::showMain();
	}
	
	function showBooks() {
		global $mainframe, $option;

		$db					=& JFactory::getDBO();
		$filter_order		= $mainframe->getUserStateFromRequest( "$option.filter_order_book",		'filter_order',		'm.ordering',	'cmd' );
		$filter_order_Dir	= $mainframe->getUserStateFromRequest( "$option.filter_order_Dir_book",	'filter_order_Dir',	'',		'word' );
		$filter_state		= $mainframe->getUserStateFromRequest( "$option.filter_state_book",		'filter_state',		'',		'word' );
		$search				= $mainframe->getUserStateFromRequest( "$option.search_book",			'search',			'',		'string' );
		$search				= JString::strtolower( $search );

		$limit		= $mainframe->getUserStateFromRequest( 'global.list.limit', 'limit', $mainframe->getCfg('list_limit'), 'int' );
		$limitstart	= $mainframe->getUserStateFromRequest( $option.'limitstart_book', 'limitstart', 0, 'int' );

		$where = array();

		if ( $filter_state )
		{
			if ( $filter_state == 'P' )
			{
				$where[] = 'm.published = 1';
			}
			else if ($filter_state == 'U' )
			{
				$where[] = 'm.published = 0';
			}
		}
		if ($search)
		{
			$where[] = 'LOWER(m.title) LIKE '.$db->Quote('%'.$search.'%');
		}

		$where 		= ( count( $where ) ? ' WHERE ' . implode( ' AND ', $where ) : '' );
		$orderby 	= ' ORDER BY '. $filter_order .' '. $filter_order_Dir;

		$query = 'SELECT COUNT(m.id)'
		. ' FROM #__flippingbook_books AS m'
		. $where
		;
		$db->setQuery( $query );
		$total = $db->loadResult();

		jimport('joomla.html.pagination');
		$pageNav = new JPagination( $total, $limitstart, $limit );

		$query = 'SELECT m.*, COUNT(d.id) AS numoptions'
		. ' FROM #__flippingbook_books AS m'
		. ' LEFT JOIN #__flippingbook_pages AS d ON d.book_id = m.id'
		. $where
		. ' GROUP BY m.id'
		. $orderby
		;
		$db->setQuery( $query, $pageNav->limitstart, $pageNav->limit );
		$rows = $db->loadObjectList();

		if ($db->getErrorNum())
		{
			echo $db->stderr();
			return false;
		}

		// state filter
		$lists['state']	= JHTML::_('grid.state',  $filter_state );

		// table ordering
		$lists['order_Dir']	= $filter_order_Dir;
		$lists['order']		= $filter_order;

		// search filter
		$lists['search']= $search;

		require_once( JPATH_COMPONENT.DS.'views'.DS.'books'.DS.'view.php' );
		BookView::showBooks( $rows, $pageNav, $option, $lists );
	}

	function editBook() {
		$db		=& JFactory::getDBO();
		$user 	=& JFactory::getUser();

		$cid 	= JRequest::getVar( 'cid', array(0), '', 'array' );
		$option = JRequest::getCmd( 'option');
		$uid 	= (int) @$cid[0];

		$row =& JTable::getInstance('flippingbook', 'Table');
		// load the row from the db table
		$row->load( $uid );
		
		$javascript = ' ';
		$lists['background_image'] = JHTML::_('list.images', 'background_image', $row->background_image, $javascript , 'images/flippingbook' );
		$lists['preview_image'] = JHTML::_('list.images', 'preview_image', $row->preview_image, $javascript , 'images/flippingbook' );
		
		require_once( JPATH_COMPONENT.DS.'views'.DS.'books'.DS.'view.php' );
		BookView::editBook( $row, $lists );
	}

	function saveBook() {
		$db		=& JFactory::getDBO();
		$row	=& JTable::getInstance('flippingbook', 'Table');
		$post	= JRequest::get( 'post' );
		if (!$row->bind( $_POST )) {
			JError::raiseError(500, $row->getError() );
		}
		$isNew = ($row->id == 0);

		if (!$row->check()) {
			JError::raiseError(500, $row->getError() );
		}

		if (!$row->store()) {
			JError::raiseError(500, $row->getError() );
		}
		$row->checkin();

		switch ($this->_task)
		{
			case 'apply_book':
				$msg = JText::_( 'Changes to Book saved' );
				$link = 'index.php?option=com_flippingbook&task=edit_book&cid[]='. $row->id .'';
				break;

			case 'save_book':
			default:
				$msg = JText::_( 'Book saved' );
				$link = 'index.php?option=com_flippingbook&task=book_manager';
				break;
		}
		$this->setRedirect($link);
	}
	
	function savePage() {
		$db		=& JFactory::getDBO();
		$row	=& JTable::getInstance('flippingpage', 'Table');
		$post	= JRequest::get( 'post' );
		if (!$row->bind( $post )) {
			JError::raiseError(500, $row->getError() );
		}
		$isNew = ($row->id == 0);
		if (!$row->check()) {
			JError::raiseError(500, $row->getError() );
		}
		if (!$row->store()) {
			JError::raiseError(500, $row->getError() );
		}
		$row->checkin();

		$row->reorder("book_id = $row->book_id");
		
		switch ($this->_task)
		{
			case 'apply_page':
				$msg = JText::_( 'Changes to Page saved' );
				$link = 'index.php?option=com_flippingbook&task=edit_page&cid[]='. $row->id .'';
				break;

			case 'save_page':
			default:
				$msg = JText::_( 'Page saved' );
				$link = 'index.php?option=com_flippingbook&task=page_manager';
				break;
		}
		$this->setRedirect($link);
	}
	
	function removePage() {
		$db		=& JFactory::getDBO();
		$cid	= JRequest::getVar( 'cid', array(), '', 'array' );
		JArrayHelper::toInteger($cid);
		$msg = '';
		for ($i=0, $n=count($cid); $i < $n; $i++) {
				$book =& JTable::getInstance('flippingpage', 'Table');
				if (!$book->delete( $cid[$i] )) {
					$msg .= $book->getError();
				}
			}
		$this->setRedirect( 'index.php?option=com_flippingbook&task=page_manager', $msg );
	}

	function removeBook() {
		$db		=& JFactory::getDBO();
		$cid	= JRequest::getVar( 'cid', array(), '', 'array' );
		JArrayHelper::toInteger($cid);
		$msg = '';
		for ($i=0, $n=count($cid); $i < $n; $i++) {
			$book =& JTable::getInstance('flippingbook', 'Table');
			if (!$book->delete( $cid[$i] )) {
				$msg .= $book->getError();
			}
		}
		$this->setRedirect( 'index.php?option=com_flippingbook&task=book_manager', $msg );
	}

	function publish() {
		global $mainframe;

		$db 	=& JFactory::getDBO();
		$user 	=& JFactory::getUser();

		$cid		= JRequest::getVar( 'cid', array(), '', 'array' );
		$publish	= ( $this->_task == 'publish' ? 1 : 0 );
		$option		= JRequest::getCmd( 'option', 'com_flippingbook', '', 'string' );

		JArrayHelper::toInteger($cid);

		if (count( $cid ) < 1) {
			$action = $publish ? 'publish' : 'unpublish';
			JError::raiseError(500, JText::_( 'Select an item to '.$action, true ) );
		}
		$cids = implode( ',', $cid );
		switch (JRequest::getVar( 'section', '', 'post', 'string' )) {
			case 'book_manager':
				$query = 'UPDATE #__flippingbook_books'
				. ' SET published = ' . (int) $publish
				. ' WHERE id IN ( '. $cids .' )'
				;
				$db->setQuery( $query );
				if (!$db->query()) {
					JError::raiseError(500, $db->getErrorMsg() );
				}

				if (count( $cid ) == 1) {
					$row =& JTable::getInstance('flippingbook', 'Table');
					$row->checkin( $cid[0] );
				}
				$link = 'index.php?option=com_flippingbook&task=book_manager';
				$this->setRedirect($link);
			break;
			
			case 'page_manager':
			default:
				$query = 'UPDATE #__flippingbook_pages'
				. ' SET published = ' . (int) $publish
				. ' WHERE id IN ( '. $cids .' )'
			//	. ' AND ( checked_out = 0 OR ( checked_out = '.(int) $user->get('id').' ) )'
				;
				$db->setQuery( $query );
				if (!$db->query()) {
					JError::raiseError(500, $db->getErrorMsg() );
				}

				if (count( $cid ) == 1) {
					$row =& JTable::getInstance('flippingpage', 'Table');
					$row->checkin( $cid[0] );
				}
				$link = 'index.php?option=com_flippingbook&task=page_manager';
				$this->setRedirect($link);
			break;
		}
	}

	function cancelBook() {
		global $option;
		$this->setRedirect( 'index.php?option='. $option .'&task=book_manager' );
	}

	function cancelPage() {
		global $option;
		$this->setRedirect( 'index.php?option='. $option .'&task=page_manager' );
	}
	
	function showPages() {
		global $mainframe, $option;
		$db					=& JFactory::getDBO();
		$filter_order		= $mainframe->getUserStateFromRequest( "$option.filter_order",		'filter_order',		'b.title',	'cmd' );
		$filter_order_Dir	= $mainframe->getUserStateFromRequest( "$option.filter_order_Dir",	'filter_order_Dir',	'',		'word' );
		$filter_state		= $mainframe->getUserStateFromRequest( "$option.filter_state",		'filter_state',		'',		'word' );
		$filter_book		= $mainframe->getUserStateFromRequest( "$option.filter_book",		'filter_book',		'-1',		'string' );
		$search				= $mainframe->getUserStateFromRequest( "$option.search",			'search',			'',		'string' );
		$search				= JString::strtolower( $search );

		$limit		= $mainframe->getUserStateFromRequest( 'global.list.limit', 'limit', $mainframe->getCfg('list_limit'), 'int' );
		$limitstart	= $mainframe->getUserStateFromRequest( $option.'limitstart_page', 'limitstart', 0, 'int' );

		$where = array();

		if ( $filter_state ) {
			if ( $filter_state == 'P' )
			{
				$where[] = 'm.published = 1';
			}
			else if ($filter_state == 'U' )
			{
				$where[] = 'm.published = 0';
			}
		}
		
		if ( $filter_book > -1) {
			$where[] = '(m.book_id = ' . $filter_book . ')';
		}
		
		if ($search) {
			$where[] = '(LOWER(m.file) LIKE '.$db->Quote('%'.$search.'%').' OR LOWER(m.link_url) LIKE '.$db->Quote('%'.$search.'%').' OR LOWER(m.zoom_url) LIKE '.$db->Quote('%'.$search.'%').')';
		}

		$where 		= ( count( $where ) ? ' WHERE ' . implode( ' AND ', $where ) : '' );
		$orderby 	= ' ORDER BY '. $filter_order .' '. $filter_order_Dir . ', m.ordering';

		$query = 'SELECT COUNT(m.id)'
		. ' FROM #__flippingbook_pages AS m'
		. $where
		;
		$db->setQuery( $query );
		$total = $db->loadResult();

		jimport('joomla.html.pagination');
		$pageNav = new JPagination( $total, $limitstart, $limit );
		
		$query = 'SELECT m.*, b.title'
		. ' FROM #__flippingbook_pages AS m LEFT JOIN #__flippingbook_books AS b ON (m.book_id=b.id)'
		. $where
		. $orderby
		;
		$db->setQuery( $query, $pageNav->limitstart, $pageNav->limit );
		$rows = $db->loadObjectList();

		if ($db->getErrorNum()) {
			echo $db->stderr();
			return false;
		}

		$lists['state']	= JHTML::_('grid.state',  $filter_state );

		$lists['order_Dir']	= $filter_order_Dir;
		$lists['order']		= $filter_order;
		
		$query = 'SELECT id, title FROM #__flippingbook_books ORDER BY title';
		$db->setQuery( $query );
		$rows2 = $db->loadObjectList();
		$book_filter[] = JHTML::_('select.option', -1, '- '. JText::_( 'Select Book' ) .' -' );
		foreach ( $rows2 as $row ) {
			$book_filter[] = JHTML::_('select.option', $row->id, $row->title );
		}
		$lists['book']		 = JHTML::_('select.genericlist',   $book_filter, 'filter_book', 'class="inputbox" size="1" onchange="submitform( );"', 'value', 'text', $filter_book );

		$lists['search']= $search;

		require_once( JPATH_COMPONENT.DS.'views'.DS.'books'.DS.'view.php' );
		BookView::showPages( $rows, $pageNav, $option, $lists );
	}
	
	function editPage()	{
		$db		=& JFactory::getDBO();
		$user 	=& JFactory::getUser();
		
		$cid 	= JRequest::getVar( 'cid', array(0), '', 'array' );
		$option = JRequest::getCmd( 'option');
		$uid 	= (int) @$cid[0];
		
		$row =& JTable::getInstance('flippingpage', 'Table');
		$row->load( $uid );
		
		$image_folder = JPATH_SITE.DS.'images'.DS.'flippingbook';
		$image_files = JFolder::files($image_folder, '.(jpg|jpeg|swf)$');
		$img_file[] = JHTML::_('select.option', '', '- '. JText::_( 'Select Image' ) .' -');
		if (count($image_files) > 0) {
			foreach ($image_files as $file) {
				$img_file[] = JHTML::_('select.option', $file, $file);
			}
		} else {
			$img_file[] = JHTML::_('select.option', '', JText::_( 'Files not found' ));
		}
		$lists['zoomed_image'] = JHTML::_('select.genericlist',  $img_file, 'zoom_url', 'class="inputbox" size="1"', 'value', 'text', $row->zoom_url);
		unset($img_file[0]); // delete - Select Image - value from list
		$lists['files'] = JHTML::_('select.genericlist',  $img_file, 'file', 'class="inputbox" size="1"', 'value', 'text', $row->file);	
		
		$query = 'SELECT id, title FROM #__flippingbook_books ORDER BY title';
		$db->setQuery( $query );
		$book_rows = $db->loadObjectList();
		$book_filter[] = JHTML::_('select.option', -1, '- '. JText::_( 'Select Book' ) .' -' );
		foreach ( $book_rows as $book_row ) {
			$book_option[] = JHTML::_('select.option', $book_row->id, $book_row->title );
		}
		$lists['books'] = JHTML::_('select.genericlist', $book_option, 'book_id', 'class="inputbox" size="1"', 'value', 'text', $row->book_id );
		
		if (($row->zoom_url_target != 1)&&($row->zoom_url_target != 2)&&($row->zoom_url_target != 3)&&($row->zoom_url_target != 4)) $row->zoom_url_target = 4;
		$zoom_url_target[] = JHTML::_('select.option', '1', JText::_( 'Parent Window With Browser Navigation' ) );
		$zoom_url_target[] = JHTML::_('select.option', '2', JText::_( 'New Window With Browser Navigation' ) );
		$zoom_url_target[] = JHTML::_('select.option', '3', JText::_( 'New Window Without Browser Navigation' ) );
		$zoom_url_target[] = JHTML::_('select.option', '4', JText::_( 'New Layer in Parent Window' ) );
		$lists['zoom_url_target'] = JHTML::_('select.genericlist',  $zoom_url_target, 'zoom_url_target', 'class="inputbox" size="4" onchange="check_zoom_window_target()"', 'value', 'text', $row->zoom_url_target);
		
		if (($row->link_url_target != 1)&&($row->link_url_target != 2)&&($row->link_url_target != 3)) $row->link_url_target = 1;
		$link_url_target[] = JHTML::_('select.option', '1', JText::_( 'Parent Window With Browser Navigation' ) );
		$link_url_target[] = JHTML::_('select.option', '2', JText::_( 'New Window With Browser Navigation' ) );
		$link_url_target[] = JHTML::_('select.option', '3', JText::_( 'New Window Without Browser Navigation' ) );
		$lists['link_url_target'] = JHTML::_('select.genericlist',  $link_url_target, 'link_url_target', 'class="inputbox" size="3" onchange="check_page_link_target()"', 'value', 'text', $row->link_url_target);
		
		require_once( JPATH_COMPONENT.DS.'views'.DS.'books'.DS.'view.php' );
		BookView::editPage( $row, $lists );
	}
	
	function manageFiles () {
		require_once( JPATH_COMPONENT.DS.'views'.DS.'books'.DS.'view.php' );
		BookView::fileManager( '' );
	}
	
	function remove_rename_File () {
		require_once( JPATH_COMPONENT.DS.'views'.DS.'books'.DS.'view.php' );
		$db		=& JFactory::getDBO();
		$user 	=& JFactory::getUser();
		$file = JRequest::getVar( 'file_to_delete', '', 'get', 'string' );
		if ($file == '') $file = JRequest::getVar( 'file_to_rename', '', 'get', 'string' );
		$query = "SELECT * FROM #__flippingbook_pages"
			. "\n WHERE file IN ( '".$file."' )";
		$db->setQuery($query);
		$rows = $db->loadObjectList();
		$query = "SELECT * FROM #__flippingbook_books"
			. "\n WHERE preview_image IN ( '".$file."' )";
		$db->setQuery($query);
		$rows2 = $db->loadObjectList();
		$query = "SELECT * FROM #__flippingbook_books"
			. "\n WHERE background_image IN ( '".$file."' )";
		$db->setQuery($query);
		$rows3 = $db->loadObjectList();
		if (((count($rows) > 0)||((count($rows2) > 0))||((count($rows3) > 0)))&&(JRequest::getVar( 'old_file_name', '', 'post', 'string' ) == '')) {
			$report = '<fieldset class="adminform"><legend>'.JText::_( 'Rename/Remove Report' ) . ':</legend>'.$file . ' ' . JText::_( "can't be deleted or renamed" ) . '</fieldset>';
			BookView::fileManager( @$report );
		} else {
			switch ($this->_task) {
			case 'delete_file':
				unlink (JPATH_SITE.DS.'images'.DS.'flippingbook'.DS.$file);
				$report = '<fieldset class="adminform"><legend>'.JText::_( 'Rename/Remove Report' ) . ':</legend>'.$file.' deleted.</fieldset>';
				BookView::fileManager( @$report );
				break;
			case 'rename_file':
			default:
				if (JRequest::getVar( 'file_to_rename', '', 'get', 'string' ) != '') {
					require_once( JPATH_COMPONENT.DS.'views'.DS.'books'.DS.'view.php' );
					BookView::renameFileForm( $file );
				} else {
					$old_file_name = JRequest::getVar( 'old_file_name', '', 'post', 'string' );
					$new_file_name = JRequest::getVar( 'new_file_name', '', 'post', 'string' );
					if (preg_match('/\.(php|php3|php4|php5|php6|js|htm|html|phtml|cgi|pl|perl|asp)$/i', $new_file_name)) {
						$report = '<fieldset class="adminform"><legend>'.JText::_( 'Rename/Remove Report' ) . ':</legend>Incorrect file extension.</fieldset>';
						BookView::fileManager( @$report );
					} else {
						$old = JPATH_SITE.DS.'images'.DS.'flippingbook'.DS.$old_file_name;
						$new = JPATH_SITE.DS.'images'.DS.'flippingbook'.DS.$new_file_name;
						if (@rename ($old, $new)) {
							$report = '<fieldset class="adminform"><legend>'.JText::_( 'Rename/Remove Report' ) . ':</legend>File was renamed.</fieldset>';
							BookView::fileManager( @$report );
						} else {
							$report = '<fieldset class="adminform"><legend>'.JText::_( 'Rename/Remove Report' ) . ':</legend>Rename error.</fieldset>';
							BookView::fileManager( @$report );
						}
					}
				}
				break;
			}
		}
	}
	
	function saveUploadedFiles () {
		global $clearUploads;
		global $mainframe;
		$report = '<fieldset class="adminform"><legend>'.JText::_( 'Upload Report' ) . ':</legend><table>';
		$userfile = JRequest::getVar( 'upload', null, 'files', 'array' );
		jimport('joomla.filesystem.path');
		jimport('joomla.filesystem.file');
		
		for ($i = 0; $i < count($userfile); $i++) {
			if (@$userfile['name'][$i] != '') {
				$tmp_dest = JPATH_SITE.DS.'images'.DS.'flippingbook'.DS.$userfile['name'][$i];
				$tmp_src = $userfile['tmp_name'][$i];
				$format = substr( $tmp_dest, -3 );
				$allowable = array ('jpg', 'png', 'gif', 'bmp', 'swf', 'mp3');
				$match = 0;
				foreach( $allowable as $ext ) {
					if ( strcasecmp( $format, $ext ) == 0 ) $match = 1;
				}
				if ($match == 0) {
					$report .= '<tr><td align="right">' . $userfile['name'][$i] . '</td><td> ' . JText::_( 'Unsupported file type' ) . '</td></tr>';
				} else {
					if (JFile::upload($tmp_src, $tmp_dest)) {
						$report .= '<tr><td align="right">' . $userfile['name'][$i] . '</td><td> OK </td></tr>';
					} else {
						$report .= '<tr><td align="right">' . $userfile['name'][$i] . '</td><td> ERROR </td></tr>';
					}
				}
			}
		}
		$report .= '</table></fieldset>';
		
		require_once( JPATH_COMPONENT.DS.'views'.DS.'books'.DS.'view.php' );
		BookView::fileManager( $report );
	}
}
?>