@prototype class COM {
	function connectObject(object:COM, prefix:String):void;
	function createObject(progID:String):COM;
	function disconnectObject(object:COM):void;
}

class FileInfo {
	var size:Number;
	var lastModified:Number;
	
	function isDirectory():Boolean;
	function isHidden():Boolean;
	
}

class Trash {
	var size:Number;
	var numItems:String[];
}

class Volume {
	var path:String;
	var freeBytes:Number;
	var totalBytes:Number;
}

@prototype class filesystem {
	var volumes:Volume;
	function copy(path:String, destination:String):Boolean;
	function emptyRecycleBin():void;
	function emptyTrash():void;
	function getDirectoryContents(directory:String, recurse:Boolean):String[];
	function getDisplayName(path:String):String;
	function getFileInfo(path:String):FileInfo;
	function getRecycleBinInfo():Trash;
	function getTrashInfo():Trash;
	function isDirectory(path:String):Boolean;
	function itemExists(path:String):Boolean;
	function move(path:String, destination:String):void;
	function moveToRecycleBin(files:String[]):void;
	function moveToTrash(files:String[]):void;
	function open(path:String):void;
	function openRecycleBin():void;
	function openTrash():void;
	function readFile(path:String, asLines:Boolean=false):String||String[];
	function reveal(path:String):void;
	function writeFile(path:String, data:String||String[]):void;
}

@prototype class screen {
	var availHeight:Number;
	var availLeft:Number;
	var availTop:Number;
	var availWidth:Number;
	var colorDepth:Number;
	var height:Number;
	var pixelDepth:Number;
	var resolution:Number;
	var width:Number;
}

class WiFi {
	var available:Boolean;
	var info:String; // a summary of WiFi/AirPort status.
	var network:String; // the name of the current network.
	var noise:Number; // the connection's noise level.
	var powered:Boolean; // true if WiFi/AirPort is powered on.
	var signal:Number; // the connection's signal level.
}

class Battery {
	var currentCapacity:Number;
	var isCharging:Boolean;
	var isPresent:Boolean;
	var maximumCapacity:Number;
	var name:String;
	var powerSourceState:String;
	var timeToEmpty:Number;
	var timeToFullCharge:Number;
	var transportType:String;
}

class CPU {
	var activity:Number;
	var idle:Number;
	var nice:Number;
	var numProcessors:Number;
	var sys:Number;
	var user:String;
}

class Event {
	var hOffset:Number;
	var vOffset:Number;
	var key:Number;
	var keyString:String;
	var modifiers:Number;
	var screenX:Number;
	var screenY:Number;
	var scrollDelta:Number;
	var timestamp:Number;
	var x:Number;
	var y:Number;
}

class Memory {
	var availPhysical:Number;
	var availVirtual:Number;
	var load:Number;
	var totalPhysical:Number;
	var totalVirtual:Number;
}

@prototype class system {
	var airport:WiFi;
	var wireless:WiFi;
	var appearance:String;
	var battery:Battery[];
	var batteryCount:Number;
	var clipboard:String;
	var cpu:CPU;
	var event:Event;
	var languages:String;
	var memory:Memory;
	var mute:Boolean;
	var platform:String;
	
	var userDocumentsFolder:String;
	var userDesktopFolder:String;
	var userPicturesFolder:String;
	var userMoviesFolder:String;
	var userMusicFolder:String;
	var userWidgetsFolder:String;
	var applicationsFolder:String;
	var temporaryFolder:String;
	var trashFolder:String;
	
	var volume:Number;
	var widgetDataFolder:String;
}

@prototype class iTunes {
	var playerPosition:Number;
	var playerStatus:String;
	var random:Boolean;
	var shuffle:Boolean;
	var repeatMode:String;
	var running:Boolean;
	var streamURL:String;
	var trackAlbum:String;
	var trackArtist:String;
	var trackLength:Number;
	var trackRating:Number;
	var trackTitle:String;
	var trackType:String;
	var version:String;
	var volume:Number;
	
	function backTrack():void;
	function fastForward():void;
	function nextTrack():void;
	function pause():void;
	function play():void;
	function playPause():void;
	function resume():void;
	function rewind():void;
	function stop():void;
}

class URL {
	var autoRedirect:Boolean;
	var location:String;
	var outputFile:String;
	var postData:String;
	var response:Number;
	var responseData:String;
	var result:String;
	
	function addPostFile(path:String):void;
	function cancel():void;
	function clear():void;
	function fetch(location:String=null):String;
	function fetchAsync(callback:Function):void;
	function getResponseHeaders(name:String):String[];
	function setRequestHeader(name:String, value:String):void;
}

class Animator {
	static const kEaseIn;
	static const kEaseOut;
	static const kEaseInOut;
	static const kEaseNone;
	
	var milliseconds:Number;
	
	function ease(start:Number, end:Number, percent:Number, easeType):Number;
	function runUntilDone(obj:Object||Array):void;
	function start(obj:Object||Array):void;
	function kill():void;
}

class CustomAnimation {
	 function CustomAnimation(interval:Number, updateFunc:Functon ,doneFunc:Function=null);
}

class FadeAnimation {
	function FadeAnimation(object:Object, toOpacity:Number, duration:Number, easeType:Number, doneFunc:Function=null);
}

class MoveAnimation {
	function MoveAnimation(object:Object, toX:Number, toY:Number, duration:Number, easeType:Number, doneFunc:Function=null);
}

class RotateAnimation {
	function RotateAnimation(image:Image, toAngle:Number, duration:Number, easeType:Number, doneFunc:Function=null);
}

class Shadow {
	var color:String;
	var colour:String;
	var hOffset:Number;
	var opacity:Number;
	var vOffset:Number;
}

abstract class Control {
	var superview:View;
	//Attribute
	var name:String;
	var hAlign:String;
	var height:Number;
	var hOffset:Number;
	var opacity:Number;
	var visible:Boolean;
	var vAlign:String;
	var vOffset:Number;
	var width:Number;
	var window:window;
	var zOrder:Number;
	var contextMenuItems:MenuItem[];
	//Event
	var onContextMenu:String;
	var onDragDrop:String;
	var onDragEnter:String;
	var onDragExit:String;
	var onMouseDown:String;
	var onMouseEnter:String;
	var onMouseExit:String;
	var onMouseMove:String;
	var onMouseUp:String;
	var onMultiClick:String;
	
	function removeFromSuperview():void;
}

tag["menuItem"] class MenuItem {
	var checked:Boolean;
	var enabled:Boolean;
	var onSelect:String;
	
	var name:String;
	var title:String;
}

tag["image"] class Image extends Control {
	var alignment:String;
	var clipRect:String;
	var colorize:String;
	var fillMode:String;
	var hRegistrationPoint:Number;
	var hslAdjustment:String;
	var hslTinting:String;
	var loadingSrc:String;
	var missingSrc:String;
	var onImageLoaded:String;
	var remoteAsync:Boolean;
	var rotation:Number;
	var src:String;
	var srcHeight:Number
	var srcWidth:Number;
	var tileOrigin:String;
	var tooltip:String;
	var tracking:String;
	var useFileIcon:Boolean;
	var vRegistrationPoint:String;

	function fade(start:Number, end:Number, duration:Number):void;
	function moveTo(newX:Number, newY:Number, duration:Number):void;
	function reload():void;
	function slide(direction:String, amountOfImageToConceal:Number, duration:Number):void;
}

abstract class View extends Control {
	var subviews:Control[];
	
	function addSubview(object:Control):void;
}

class Root extends View {
}

class ScrollBar {
	var superview:View;
	//Attribute
	var name:String;
	var hAlign:String;
	var height:Number;
	var hOffset:Number;
	var opacity:Number;
	var visible:Boolean;
	var vAlign:String;
	var vOffset:Number;
	var width:Number;
	var window:window;
	var zOrder:Number;
	var contextMenuItems:MenuItem[];
	
	function removeFromSuperview():void;
	
	var autoHide:Boolean;
	var max:Number;
	var min:Number;
	var onValueChanged:String;
	var orientation:String;
	var pageSize:Number;
	var thumbColor:String;
	var value:Number;
	
	function setRange(min:Number, max:Number):void;
	function setThumbInfo(offset:Number, images:String||String[]):void;
	function setTrackInfo(offset:Number, topLimit:Number, bottomLimit:Number, images:String||String[]):void;
}

tag["frame"] class Frame extends View {
	var onMouseWheel:String;
	var hLineSize:Number;
	var hScrollBar:ScrollBar;
	var scrollX:String;
	var scrollY:String;
	var vLineSize:Number;
	var vScrollBar:ScrollBar;
	
	function home():void;
	function end():void;
	function lineDown():void;
	function lineLeft():void;
	function lineRight():void;
	function lineUp():void;
	function pageDown():void;
	function pageLeft():void;
	function pageRight():void;
	function pageUp():void;
}

tag["text"] class Text extends Control {
	var onKeyUp:String;
	var onKeyDown:String;
	
	var alignment:String;
	var bgColor:String;
	var bgOpacity:String;
	var color:String;
	var data:String;
	var font:String;
	var size:Number;
	var style:String;
	var tooltip:String;
	
	var shadow:Shadow;
	var truncation:String;
	
	function fade(start:Number, end:Number, duration:Number):void;
	function moveTo(newX:Number, newY:Number, duration:Number):void;
	function slide(direction:String, amountOfImageToConceal:Number, duration:Number):void;
}

tag["textarea"] class TextArea extends Control {
	var onKeyUp:String;
	var onKeyDown:String;
	
	var alignment:String;
	var bgColor:String;
	var bgOpacity:Number;
	var color:String;
	var data:String;
	var font:String;
	var size:Number;
	var style:String;
	var tooltip:String;
	
	var columns:Number;
	var editable:Boolean;
	var lines:Number;
	var onGainFocus:String;
	var onKeyPress:String;
	var onLoseFocus:String;
	var secure:Boolean;
	var scrollbar:Boolean;
	var spellcheck:Boolean;
	var thumbColor:String;

	function focus():void;
	function loseFocus():void;
	function rejectKeyPress():void;
	function replaceSelection(text:String):void;
	function select(start:Number, end:Number):void;
}

tag["timer"] class Timer {
	var name:String;
	var interval:Number;
	var ticking:Boolean;
	var onTimerFired:String;
	
	function reset():void;
}

tag["widget"] class Widget {
	var locale:String;
	var name:String;
	var author:String;
	var company:String;
	var copyright:String;
	var debug:String;
	var defaultTracking:String;
	var image:String;
	var option:String;
	var requiredEngineVersion:String;
	var requiredPlatform:String;
	var version:String;
	
	function extractFile(file:String):String;
	function getLocalizedString(key:String):String;
}

tag["window"] class Window {
	var locked:Boolean;
	var root:Root;
	
	var alignment:String;
	var name:String;
	var height:Number;
	var hOffset:Number;
	var level:String;
	var onFirstDisplay:String;
	var onGainFocus:String;
	var onLoseFocus:String;
	var onMultiClick:String;
	var opacity:Number;
	var shadow:Boolean;
	var title:String;
	var visible:Boolean;
	var vOffset:Number;
	var width:Number;
	
	function focus():void;
	function moveTo(newX:Number, newY:Number, duration:Number):void;
	function recalcShadow():void;	
}

tag["hotkey"] class HotKey {
	var key:Number;
	var modifier:Number;
	var name:String;
	
	var onKeyUp:String;
	var onKeyDown:String;
}

class Global {
	var animator:Animator;
	var widget:Widget;
}