/*
 * Decompiled with CFR 0.152.
 */
package com.spket.wpfe.model.render;

import com.spket.as.internal.compiler.util.HashtableOfInt;
import com.spket.widget.Colors;
import com.spket.wpfe.model.WPFEHelper;
import com.spket.xml.XMLAttr;
import com.spket.xml.XMLElement;
import com.spket.xml.XMLUtils;
import java.awt.Color;
import java.awt.geom.Point2D;

public class XAMLHandler {
    public static Color toColor(XMLAttr xMLAttr) {
        return XAMLHandler.toColor(XMLUtils.getValue((XMLAttr)xMLAttr));
    }

    public static Color toColor(String string) {
        int n;
        if (string == null || string.length() == 0) {
            return null;
        }
        if (string.charAt(0) == '#') {
            int n2;
            try {
                switch (string.length()) {
                    case 4: 
                    case 5: {
                        n2 = 0;
                        for (int i = 1; i < string.length(); ++i) {
                            int n3 = Character.digit(string.charAt(i), 16);
                            if (n3 < 0) {
                                return null;
                            }
                            n2 = n2 << 8 | n3 << 4 | n3;
                        }
                        if (string.length() == 4) {
                            n2 |= 0xFF000000;
                        }
                        break;
                    }
                    case 7: {
                        n2 = Integer.parseInt(string.substring(1), 16);
                        n2 |= 0xFF000000;
                        break;
                    }
                    case 9: {
                        n2 = (int)Long.parseLong(string.substring(1), 16);
                        break;
                    }
                    default: {
                        return null;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            return new Color(n2, true);
        }
        if (!"Transparent".equalsIgnoreCase(string) && (n = Colors.rgb((String)string.toLowerCase())) != -1) {
            return new Color(n, false);
        }
        return null;
    }

    public static HashtableOfInt getAttributes(XMLElement xMLElement) {
        HashtableOfInt hashtableOfInt = null;
        int n = xMLElement.getAttrCount();
        if (n > 0) {
            XMLAttr[] xMLAttrArray = xMLElement.getAttrs();
            for (int i = 0; i < n; ++i) {
                String string;
                XMLAttr xMLAttr = xMLAttrArray[i];
                int n2 = WPFEHelper.getAttrId(xMLAttr.getName());
                if (n2 == Integer.MIN_VALUE || n2 == 97 || (string = XMLUtils.getValue((XMLAttr)xMLAttr)) == null || string.length() <= 0) continue;
                if (hashtableOfInt == null) {
                    hashtableOfInt = new HashtableOfInt(n);
                }
                hashtableOfInt.put(n2, (Object)string);
            }
        }
        return hashtableOfInt;
    }

    public static Point2D toPoint(XMLAttr xMLAttr) {
        return XAMLHandler.toPoint(XMLUtils.getValue((XMLAttr)xMLAttr));
    }

    public static Point2D toPoint(String string) {
        double[] dArray = XAMLHandler.toPoints(string);
        if (dArray != null && dArray.length == 2) {
            return new Point2D.Double(dArray[0], dArray[1]);
        }
        return null;
    }

    public static double[] toPoints(XMLAttr xMLAttr) {
        return XAMLHandler.toPoints(XMLUtils.getValue((XMLAttr)xMLAttr));
    }

    public static double[] toPoints(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        int n = string.length();
        int n2 = (n / 12 + 1) * 2;
        double[] dArray = new double[n2];
        int n3 = 0;
        int n4 = 0;
        n2 = 0;
        boolean bl = false;
        try {
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c == ',' || Character.isWhitespace(c)) {
                    if (n4 > n3) {
                        bl = c != ',';
                        double d = Double.parseDouble(string.substring(n3, n4));
                        if (n2 >= dArray.length) {
                            double[] dArray2 = new double[dArray.length * 2];
                            System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
                            dArray = dArray2;
                        }
                        dArray[n2++] = d;
                    } else if (c == ',') {
                        if (bl) {
                            bl = false;
                        } else {
                            return null;
                        }
                    }
                    n3 = i + 1;
                    continue;
                }
                if (n4 < n3) {
                    n4 = n3;
                }
                ++n4;
            }
            if (n4 > n3) {
                double d = Double.parseDouble(string.substring(n3, n4));
                if (n2 >= dArray.length) {
                    double[] dArray3 = new double[dArray.length * 2];
                    System.arraycopy(dArray, 0, dArray3, 0, dArray.length);
                    dArray = dArray3;
                }
                dArray[n2++] = d;
            }
        }
        catch (NumberFormatException numberFormatException) {
            dArray = null;
        }
        if (n2 > 0 && n2 % 2 == 0) {
            if (n2 == dArray.length) {
                return dArray;
            }
            double[] dArray4 = new double[n2];
            System.arraycopy(dArray, 0, dArray4, 0, n2);
            return dArray4;
        }
        return null;
    }

    public static Color opacity(Color color, float f) {
        int n;
        if (f >= 1.0f) {
            return color;
        }
        if (f > 0.0f && (n = (int)((double)((float)color.getAlpha() * f) + 0.5)) > 0) {
            return new Color(color.getRed(), color.getGreen(), color.getBlue(), n);
        }
        return null;
    }

    public static short toStretch(XMLAttr xMLAttr) {
        String string = XMLUtils.getValue((XMLAttr)xMLAttr);
        if (string != null) {
            if ("None".equalsIgnoreCase(string)) {
                return 0;
            }
            if ("Uniform".equalsIgnoreCase(string)) {
                return 2;
            }
            if ("UniformToFill".equalsIgnoreCase(string)) {
                return 3;
            }
        }
        return 1;
    }
}

