/*
 * Decompiled with CFR 0.152.
 */
package com.spket.wpfe.model.render;

import com.spket.lw.Widget;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public abstract class UIElement
extends Widget {
    protected static final AffineTransform IDENTITY = new AffineTransform();
    protected static final Rectangle2D EMPTY_RECT = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
    protected float opacity = 1.0f;
    protected int zIndex;
    protected double x;
    protected double y;
    protected double width = Double.NEGATIVE_INFINITY;
    protected double height = Double.NEGATIVE_INFINITY;
    private Rectangle2D bounds;
    protected Point2D transformOrigin;
    protected AffineTransform transform;
    protected AffineTransform renderTransform;

    public double getX() {
        return this.x;
    }

    public void setX(double d) {
        if (this.x == d) {
            return;
        }
        this.x = d;
        this.transform = null;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double d) {
        if (this.y == d) {
            return;
        }
        this.y = d;
        this.transform = null;
    }

    public int getZIndex() {
        return this.zIndex;
    }

    public void setZIndex(int n) {
        this.zIndex = n;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double d) {
        if (this.width == d) {
            return;
        }
        this.width = d;
        this.transform = null;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double d) {
        if (this.height == d) {
            return;
        }
        this.height = d;
        this.transform = null;
    }

    public void setRenderTransform(AffineTransform affineTransform) {
        if (this.renderTransform == affineTransform) {
            return;
        }
        this.renderTransform = affineTransform;
        this.transform = null;
    }

    public Point2D getTransformOrigin() {
        return this.transformOrigin;
    }

    public void setTransformOrigin(Point2D point2D) {
        if (point2D == this.transformOrigin) {
            return;
        }
        this.transformOrigin = point2D;
        this.transform = null;
    }

    public Rectangle2D getBounds() {
        if (this.bounds == null) {
            this.bounds = this.getPrimitiveBounds();
        }
        return this.bounds;
    }

    public Rectangle2D getTransformedBounds(AffineTransform affineTransform) {
        Rectangle2D rectangle2D = this.getPrimitiveBounds();
        if (rectangle2D == null) {
            return null;
        }
        AffineTransform affineTransform2 = affineTransform;
        AffineTransform affineTransform3 = this.getTransform();
        if (affineTransform3 != null) {
            if (affineTransform == null || affineTransform.isIdentity()) {
                affineTransform2 = new AffineTransform(affineTransform3);
            } else {
                affineTransform2 = new AffineTransform(affineTransform);
                affineTransform2.concatenate(affineTransform3);
            }
        }
        if (affineTransform2 == null || affineTransform2.isIdentity()) {
            return rectangle2D;
        }
        return affineTransform2.createTransformedShape(rectangle2D).getBounds2D();
    }

    public abstract Rectangle2D getOriginBounds();

    public abstract Rectangle2D getPrimitiveBounds();

    public float getOpacity() {
        return this.opacity;
    }

    public void setOpacity(float f) {
        this.opacity = f;
    }

    public void paint(Graphics2D graphics2D) {
        if (!this.isVisible()) {
            return;
        }
        if ((double)this.opacity < 0.001) {
            return;
        }
        Rectangle2D rectangle2D = this.getBounds();
        if (rectangle2D == null) {
            return;
        }
        AffineTransform affineTransform = null;
        AffineTransform affineTransform2 = this.getTransform();
        if (affineTransform2 != null) {
            affineTransform = graphics2D.getTransform();
            graphics2D.transform(affineTransform2);
        }
        boolean bl = true;
        Shape shape = graphics2D.getClip();
        if (shape != null) {
            Rectangle2D rectangle2D2 = shape.getBounds2D();
            bl = rectangle2D.intersects(rectangle2D2.getX(), rectangle2D2.getY(), rectangle2D2.getWidth(), rectangle2D2.getHeight());
        }
        if (bl && !this.isOffscreenBufferNeeded()) {
            this.primitivePaint(graphics2D);
        }
        if (affineTransform != null) {
            graphics2D.setTransform(affineTransform);
        }
    }

    public AffineTransform getTransform() {
        if (this.transform == null) {
            double d = 0.0;
            double d2 = 0.0;
            if (this.x != 0.0 || this.y != 0.0) {
                this.transform = AffineTransform.getTranslateInstance(this.x, this.y);
            }
            if (this.transformOrigin != null) {
                d = this.transformOrigin.getX();
                d2 = this.transformOrigin.getY();
                if (d != 0.0 || d2 != 0.0) {
                    double d3 = -1.0;
                    if (this.width == Double.NEGATIVE_INFINITY) {
                        double d4 = 0.0;
                        Rectangle2D rectangle2D = this.getOriginBounds();
                        if (rectangle2D == null) {
                            d3 = 0.0;
                        } else {
                            d4 = rectangle2D.getMaxX();
                            d3 = rectangle2D.getMaxY();
                            if (d4 < 0.0) {
                                d4 = 0.0;
                            }
                            if (d3 < 0.0) {
                                d3 = 0.0;
                            }
                        }
                        d *= d4;
                    } else {
                        d = this.width > 0.0 ? (d *= this.width) : 0.0;
                    }
                    if (this.height == Double.NEGATIVE_INFINITY) {
                        if (d3 < 0.0) {
                            Rectangle2D rectangle2D = this.getOriginBounds();
                            if (rectangle2D == null) {
                                d3 = 0.0;
                            } else {
                                d3 = rectangle2D.getMaxY();
                                if (d3 < 0.0) {
                                    d3 = 0.0;
                                }
                            }
                        }
                        d2 *= d3;
                    } else {
                        d2 = this.height > 0.0 ? (d2 *= this.height) : 0.0;
                    }
                }
            }
            if (d != 0.0 || d2 != 0.0) {
                if (this.transform == null) {
                    this.transform = AffineTransform.getTranslateInstance(d, d2);
                } else {
                    this.transform.translate(d, d2);
                }
            }
            if (this.renderTransform != null) {
                if (this.transform == null) {
                    this.transform = new AffineTransform(this.renderTransform);
                } else {
                    this.transform.concatenate(this.renderTransform);
                }
            }
            if (d != 0.0 || d2 != 0.0) {
                this.transform.translate(-d, -d2);
            }
        }
        return this.transform;
    }

    protected boolean isOffscreenBufferNeeded() {
        return false;
    }
}

