/*
 * Decompiled with CFR 0.152.
 */
package com.spket.wpfe.model.render;

import com.spket.wpfe.model.render.IRelativeBrush;
import java.awt.Color;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import org.apache.batik.ext.awt.MultipleGradientPaint;
import org.apache.batik.ext.awt.RadialGradientPaint;
import org.apache.batik.ext.awt.RadialGradientPaintContext;

public class RelativeRadialGradientPaint
extends RadialGradientPaint
implements IRelativeBrush {
    private float radiusX;
    private float radiusY;
    private boolean relative;
    private boolean relativeTransform;

    public RelativeRadialGradientPaint(Point2D point2D, float f, float f2, Point2D point2D2, float[] fArray, Color[] colorArray, MultipleGradientPaint.CycleMethodEnum cycleMethodEnum, MultipleGradientPaint.ColorSpaceEnum colorSpaceEnum) {
        super(point2D, f, point2D2, fArray, colorArray, cycleMethodEnum, colorSpaceEnum);
        this.radiusX = f;
        this.radiusY = f2;
    }

    public void setRelative(boolean bl) {
        this.relative = bl;
    }

    public void setTransform(AffineTransform affineTransform, boolean bl) {
        this.gradientTransform = affineTransform;
        this.relativeTransform = bl;
    }

    public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        if (this.relative || this.relativeTransform && this.gradientTransform != null || this.radiusX != this.radiusY) {
            float f;
            Point2D point2D = this.getCenterPoint();
            Point2D point2D2 = this.getFocusPoint();
            float f2 = this.radiusX;
            float f3 = this.radiusY;
            if (this.relative) {
                f2 = (float)((double)f2 * rectangle2D.getWidth());
                f3 = (float)((double)f3 * rectangle2D.getHeight());
                point2D.setLocation(point2D.getX() * rectangle2D.getWidth() + rectangle2D.getX(), point2D.getY() * rectangle2D.getHeight() + rectangle2D.getY());
                if (point2D2 != point2D) {
                    point2D2.setLocation(point2D2.getX() * rectangle2D.getWidth() + rectangle2D.getX(), point2D2.getY() * rectangle2D.getHeight() + rectangle2D.getY());
                }
            }
            affineTransform = new AffineTransform(affineTransform);
            if (f2 == f3 || (double)Math.abs(f2 - f3) < 0.001) {
                f = f2;
            } else {
                affineTransform.translate(rectangle2D.getCenterX(), rectangle2D.getCenterY());
                if (f2 < f3) {
                    f = f2;
                    affineTransform.scale(1.0, f3 / f2);
                } else {
                    f = f3;
                    affineTransform.scale(f2 / f3, 1.0);
                }
                affineTransform.translate(-rectangle2D.getCenterX(), -rectangle2D.getCenterY());
            }
            try {
                return new RadialGradientPaintContext(colorModel, rectangle, rectangle2D, affineTransform, renderingHints, (float)point2D.getX(), (float)point2D.getY(), f, (float)point2D2.getX(), (float)point2D2.getY(), this.fractions, this.colors, this.cycleMethod, this.colorSpace);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                throw new IllegalArgumentException("transform should be invertible");
            }
        }
        return super.createContext(colorModel, rectangle, rectangle2D, affineTransform, renderingHints);
    }
}

