/*
 * Decompiled with CFR 0.152.
 */
package com.spket.js.model;

import com.spket.as.internal.compiler.parser.BufferedScanner;
import com.spket.js.model.JSDoc;
import com.spket.js.model.JSNamespace;
import com.spket.util.Debug;
import java.util.ArrayList;
import java.util.List;

public class JSDocImpl
implements JSDoc {
    private static final int F_INIT = 1;
    private static final int F_CLASS = 2;
    private static final int F_PRIVATE = 4;
    private static final char[] ARRAY_SUFFIX = "[]".toCharArray();
    private static final String OR = "or";
    private static final String NULL = "null";
    private static final String OPTIONAL = "optional";
    private int fOffset;
    private BufferedScanner lexer;
    private String comment;
    private String[] returns;
    private JSDoc.Param[] params;
    private JSNamespace namespace;
    private int flags;
    private int start;
    private int end;
    private char[] source;

    protected static int parseType(List list, char[] cArray, int n, int n2, char c) {
        boolean bl = false;
        StringBuffer stringBuffer = null;
        boolean bl2 = false;
        boolean bl3 = false;
        block9: while (n < n2) {
            char c2 = cArray[n++];
            switch (c2) {
                case '\n': 
                case '\r': {
                    list.clear();
                    Debug.warn((String)"Should not happend");
                    break block9;
                }
                case ',': 
                case '/': 
                case '|': {
                    if (stringBuffer == null) continue block9;
                    if (bl3) {
                        bl3 = false;
                        stringBuffer.append(ARRAY_SUFFIX);
                        list.add(stringBuffer.toString());
                    } else {
                        String string = stringBuffer.toString();
                        if (!NULL.equalsIgnoreCase(string) && !OR.equalsIgnoreCase(string)) {
                            list.add(string);
                        }
                    }
                    stringBuffer = null;
                    continue block9;
                }
                case '.': 
                case '[': 
                case ']': {
                    if (stringBuffer == null) continue block9;
                    stringBuffer.append(c2);
                    continue block9;
                }
                case '*': {
                    continue block9;
                }
                case '?': {
                    bl2 = true;
                    break block9;
                }
                case '<': {
                    if (!bl3 && stringBuffer != null && stringBuffer.length() == "Array".length() && "Array".equalsIgnoreCase(stringBuffer.toString())) {
                        bl3 = true;
                        stringBuffer = null;
                        continue block9;
                    }
                    if (list.size() > 0) break block9;
                    while (n < n2 && (c2 = cArray[n++]) != '>') {
                    }
                    continue block9;
                }
                case '>': {
                    if (bl3) continue block9;
                }
                default: {
                    if (c2 == c) break block9;
                    if (c2 == '@' && n < n2 - 4) {
                        int n3 = n;
                        if (cArray[n++] == 'l' && cArray[n++] == 'i' && cArray[n++] == 'n' && cArray[n++] == 'k' && Character.isWhitespace(cArray[n])) {
                            ++n;
                            continue block9;
                        }
                        n = n3;
                    }
                    if (Character.isJavaIdentifierStart(c2)) {
                        if (stringBuffer == null) {
                            stringBuffer = new StringBuffer();
                        } else if (bl && stringBuffer.length() > 0) {
                            if (bl3) {
                                bl3 = false;
                                stringBuffer.append(ARRAY_SUFFIX);
                                list.add(stringBuffer.toString());
                            } else {
                                String string = stringBuffer.toString();
                                if (!NULL.equalsIgnoreCase(string) && !OR.equalsIgnoreCase(string)) {
                                    list.add(string);
                                }
                            }
                            stringBuffer = new StringBuffer();
                        }
                        bl = false;
                        stringBuffer.append(c2);
                        continue block9;
                    }
                    if (Character.isJavaIdentifierPart(c2)) {
                        if (stringBuffer == null) continue block9;
                        stringBuffer.append(c2);
                        continue block9;
                    }
                    if (Character.isWhitespace(c2)) {
                        bl = true;
                        continue block9;
                    }
                    --n;
                    list.clear();
                    Debug.warn((String)"Should not happend");
                    break block9;
                }
            }
        }
        if (stringBuffer != null) {
            if (bl3) {
                bl3 = false;
                stringBuffer.append(ARRAY_SUFFIX);
                list.add(stringBuffer.toString());
            } else {
                String string = stringBuffer.toString();
                if (!NULL.equalsIgnoreCase(string)) {
                    list.add(stringBuffer.toString());
                }
            }
        }
        if (bl2 && list.size() > 0) {
            list.add(Boolean.TRUE);
        }
        return n;
    }

    public static boolean getInlineType(BufferedScanner bufferedScanner, int n, List list) {
        int n2;
        int n3 = JSDocImpl.getCommentIndex(bufferedScanner, n);
        if (n3 != -1 && (n2 = bufferedScanner.commentStops[n3]) < 0) {
            int n4 = bufferedScanner.commentStarts[n3] + 2;
            n2 = -n2 - 2;
            JSDocImpl.parseType(list, bufferedScanner.source, n4, n2, '*');
            n2 = list.size();
            if (n2 > 0 && list.get(--n2) == Boolean.TRUE) {
                list.remove(n2);
                return true;
            }
        }
        return false;
    }

    public static int getCommentIndex(BufferedScanner bufferedScanner, int n) {
        if (bufferedScanner.commentPtr >= 0) {
            int n2 = 0;
            int n3 = bufferedScanner.getTokenIndex(n);
            if (n3 > 0) {
                n3 = bufferedScanner.getTokenEnd(n3 - 1);
            }
            int n4 = bufferedScanner.commentPtr;
            int[] nArray = bufferedScanner.commentStarts;
            int[] nArray2 = bufferedScanner.commentStops;
            while (n2 <= n4) {
                int n5 = n2 + n4 >> 1;
                if (n < nArray[n5]) {
                    n4 = n5 - 1;
                    continue;
                }
                int n6 = nArray2[n5];
                if (n6 < 0) {
                    n6 = -n6;
                }
                if (n3 > n6) {
                    n2 = n5 + 1;
                    continue;
                }
                return n5;
            }
        }
        return -1;
    }

    public JSDocImpl(int n, BufferedScanner bufferedScanner) {
        this.fOffset = n;
        this.lexer = bufferedScanner;
    }

    public JSDocImpl(char[] cArray, int n, int n2) {
        this.source = cArray;
        this.start = n;
        this.end = n2;
    }

    protected int getDocIndex(BufferedScanner bufferedScanner, int n) {
        int n2 = JSDocImpl.getCommentIndex(bufferedScanner, n);
        if (n2 != -1) {
            for (int i = n2 + 1; i <= bufferedScanner.commentPtr && bufferedScanner.commentStarts[i] < n; ++i) {
                if (bufferedScanner.commentStops[i] <= 0) continue;
                n2 = i;
            }
            if (bufferedScanner.commentStops[n2] < 0) {
                n2 = -1;
            }
        }
        return n2;
    }

    protected int getCommentIndex() {
        int n;
        int n2 = this.getDocIndex(this.lexer, this.fOffset);
        if (n2 == -1 && (n = this.lexer.getTokenIndex(this.fOffset)) > 0 && n < this.lexer.getSize()) {
            int n3 = this.lexer.getToken(--n);
            switch (n3) {
                case 50: 
                case 67: 
                case 68: {
                    n2 = this.getDocIndex(this.lexer, this.lexer.getTokenStart(n));
                }
            }
        }
        return n2;
    }

    protected void prepare() {
        if ((this.flags & 1) == 0) {
            this.flags |= 1;
            if (this.source == null) {
                int n = this.getCommentIndex();
                if (n != -1) {
                    this.source = this.lexer.source;
                    this.start = this.lexer.commentStarts[n];
                    this.end = this.lexer.commentStops[n];
                    this.comment = new String(this.source, this.start, this.end - this.start);
                    this.parseComment();
                }
                this.lexer = null;
            } else {
                this.comment = new String(this.source, this.start, this.end - this.start);
                this.parseComment();
            }
            this.source = null;
        }
    }

    public String getComment() {
        this.prepare();
        return this.comment;
    }

    public JSNamespace getNamespace() {
        return this.namespace;
    }

    public void setNamespace(JSNamespace jSNamespace) {
        this.namespace = jSNamespace;
    }

    public boolean hasClassTag() {
        this.prepare();
        return (this.flags & 2) != 0;
    }

    public boolean hasPrivateTag() {
        this.prepare();
        return (this.flags & 4) != 0;
    }

    public String[] getTypes() {
        this.prepare();
        return this.returns;
    }

    public boolean isValid() {
        if ((this.flags & 1) == 0 && this.lexer != null) {
            return this.getCommentIndex() != -1;
        }
        return this.end > this.start;
    }

    public JSDoc.Param[] getParameters() {
        this.prepare();
        return this.params;
    }

    public int getNumberOfParameters() {
        this.prepare();
        return this.params == null ? 0 : this.params.length;
    }

    public JSDoc.Param getParameter(int n) {
        this.prepare();
        if (this.params != null && n < this.params.length) {
            return this.params[n];
        }
        return null;
    }

    public JSDoc.Param getParameter(String string) {
        this.prepare();
        if (this.params != null) {
            for (int i = 0; i < this.params.length; ++i) {
                if (!string.equals(this.params[i].name)) continue;
                return this.params[i];
            }
        }
        return null;
    }

    protected void parseComment() {
        char[] cArray = this.source;
        ArrayList<JSDoc.Param> arrayList = new ArrayList<JSDoc.Param>(4);
        try {
            while (this.start < this.end) {
                char c;
                if ((c = cArray[this.start++]) != '@') continue;
                switch (cArray[this.start++]) {
                    case 'c': {
                        if (cArray[this.start++] == 'l' && cArray[this.start++] == 'a' && cArray[this.start++] == 's' && cArray[this.start++] == 's') {
                            if (!Character.isWhitespace(cArray[this.start])) break;
                            this.flags |= 2;
                            break;
                        }
                        if (cArray[this.start - 1] != 'o' || cArray[this.start++] != 'n' || cArray[this.start++] != 's' || cArray[this.start++] != 't' || cArray[this.start++] != 'r' || cArray[this.start++] != 'u' || cArray[this.start++] != 'c' || cArray[this.start++] != 't' || cArray[this.start++] != 'o' || cArray[this.start++] != 'r' || !Character.isWhitespace(cArray[this.start])) break;
                        this.flags |= 2;
                        break;
                    }
                    case 'p': {
                        if (cArray[this.start++] == 'a' && cArray[this.start++] == 'r' && cArray[this.start++] == 'a' && cArray[this.start++] == 'm') {
                            JSDoc.Param param;
                            if (!Character.isWhitespace(cArray[this.start]) || (param = this.parseParameter()) == null) break;
                            arrayList.add(param);
                            break;
                        }
                        if (cArray[this.start - 1] != 'r' || cArray[this.start++] != 'i' || cArray[this.start++] != 'v' || cArray[this.start++] != 'a' || cArray[this.start++] != 't' || cArray[this.start++] != 'e' || !Character.isWhitespace(cArray[this.start])) break;
                        this.flags |= 4;
                        break;
                    }
                    case 'r': {
                        if (cArray[this.start++] != 'e' || cArray[this.start++] != 't' || cArray[this.start++] != 'u' || cArray[this.start++] != 'r' || cArray[this.start++] != 'n' || !Character.isWhitespace(cArray[this.start])) break;
                        this.returns = this.parseReturn();
                        break;
                    }
                    case 't': {
                        if (cArray[this.start++] != 'y' || cArray[this.start++] != 'p' || cArray[this.start++] != 'e' || !Character.isWhitespace(cArray[this.start])) break;
                        this.returns = this.parseTypes();
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        if (arrayList.size() > 0) {
            this.params = new JSDoc.Param[arrayList.size()];
            arrayList.toArray(this.params);
        }
    }

    protected boolean parseType(List list, char c) {
        this.start = JSDocImpl.parseType(list, this.source, this.start, this.end, c);
        int n = list.size();
        if (n > 0 && list.get(--n) == Boolean.TRUE) {
            list.remove(n);
            return true;
        }
        return false;
    }

    protected String[] parseReturn() {
        char c;
        char[] cArray = this.source;
        while (this.start < this.end && (c = cArray[this.start++]) != '\n' && c != '\r') {
            if (c == '{') {
                --this.start;
                return this.parseTypes();
            }
            if (Character.isWhitespace(c)) continue;
            if (!Character.isJavaIdentifierStart(c)) break;
            int n = -1;
            int n2 = this.start - 1;
            while (this.start < this.end) {
                if ((c = cArray[this.start++]) == '\n' || c == '\r') {
                    n = this.start - 1;
                    break;
                }
                if (c == '.') continue;
                if (Character.isJavaIdentifierPart(c)) {
                    if (n == -1) continue;
                    return null;
                }
                if (Character.isWhitespace(c)) {
                    n = this.start - 1;
                    continue;
                }
                return null;
            }
            if (n == -1) {
                n = this.start;
            }
            return new String[]{new String(cArray, n2, n - n2)};
        }
        return null;
    }

    protected String[] parseTypes() {
        char[] cArray = this.source;
        while (this.start < this.end) {
            char c;
            if ((c = cArray[this.start++]) == '{') {
                ArrayList arrayList = new ArrayList(4);
                this.parseType(arrayList, '}');
                if (arrayList.size() <= 0) break;
                String[] stringArray = new String[arrayList.size()];
                arrayList.toArray(stringArray);
                return stringArray;
            }
            if (c != '\n' && c != '\r' && Character.isWhitespace(c)) continue;
            break;
        }
        return null;
    }

    protected boolean skipWhitespace() {
        while (this.start < this.end) {
            char c = this.source[this.start];
            if (c == '\n' || c == '\r') {
                return true;
            }
            if (!Character.isWhitespace(c)) break;
            ++this.start;
        }
        return false;
    }

    protected String parseName() {
        char c;
        if (this.start < this.end && Character.isJavaIdentifierStart(c = this.source[this.start])) {
            ++this.start;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(c);
            while (this.start < this.end && Character.isJavaIdentifierPart(c = this.source[this.start])) {
                ++this.start;
                stringBuffer.append(c);
            }
            return stringBuffer.toString();
        }
        return null;
    }

    protected String parseTagComment() {
        char c;
        StringBuffer stringBuffer = new StringBuffer();
        while (this.start < this.end && (c = this.source[this.start++]) != '\n' && c != '\r') {
            stringBuffer.append(c);
        }
        if (stringBuffer.length() > 0) {
            return stringBuffer.toString().trim();
        }
        return null;
    }

    protected JSDoc.Param parseParameter() {
        String string;
        JSDoc.Param param = null;
        String[] stringArray = this.parseTypes();
        if (stringArray != null) {
            param = new JSDoc.Param();
            param.types = stringArray;
        }
        if (!this.skipWhitespace() && (string = this.parseName()) != null) {
            if (param == null) {
                param = new JSDoc.Param();
            }
            param.name = string;
            if (!this.skipWhitespace()) {
                if (this.start < this.end && this.source[this.start] == '(') {
                    ++this.start;
                    if (!this.skipWhitespace()) {
                        string = this.parseName();
                        param.optional = OPTIONAL.equalsIgnoreCase(string);
                        if (!this.skipWhitespace() && this.start < this.end && this.source[this.start] == ')') {
                            ++this.start;
                            param.comment = this.parseTagComment();
                        }
                    }
                } else {
                    param.comment = this.parseTagComment();
                }
            }
        }
        return param;
    }
}

