/*
 * Decompiled with CFR 0.152.
 */
package com.spket.js.model;

import com.spket.js.internal.JSPlugin;
import com.spket.js.internal.views.UIContext;
import com.spket.js.model.JSObject;
import com.spket.js.model.ObjectImpl;
import com.spket.js.model.Profile;
import com.spket.js.parser.ExpressionEvaluator;
import com.spket.js.parser.ScriptManager;
import com.spket.js.profile.ProfileLoader;
import com.spket.util.StringUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;

public abstract class Context
implements IAdaptable {
    public static int JS_1_6 = 6;
    public static int JS_1_7 = 14;
    public static int AS_2_0 = 3088;
    public static int AS_3_0 = 5139;
    protected static final int S_LOADING = 1;
    protected static final int S_LOADED = 2;
    protected static final int S_FAILED = 3;
    private static final String PROFILE_EXTENSIONS = "com.spket.js.profiles";
    private static final String A_ID = "id";
    private static final String A_NAME = "name";
    private static final String A_CLASS = "class";
    private static final String A_DEFAULT = "default";
    private static Map gProfiles;
    private static Profile defaultProfile;
    private static Context defaultContext;
    protected int state;
    private Runnable fCallback;
    static /* synthetic */ Class class$com$spket$ui$UIItem;

    public static JSObject getTopLevelScope(JSObject jSObject) {
        JSObject jSObject2;
        while ((jSObject2 = jSObject.getParentScope()) != null && jSObject2 != jSObject) {
            jSObject = jSObject2;
        }
        return jSObject;
    }

    public static JSObject getClassPrototype(JSObject jSObject, String string) {
        JSObject jSObject2 = (jSObject = Context.getTopLevelScope(jSObject)).getProperty(string);
        if (jSObject2 != null) {
            return jSObject2.getProperty("prototype");
        }
        return null;
    }

    public static JSObject getObjectPrototype(JSObject jSObject) {
        return Context.getClassPrototype(jSObject, "Object");
    }

    public static JSObject getFunctionPrototype(JSObject jSObject) {
        return Context.getClassPrototype(jSObject, "Function");
    }

    public static Profile getDefaultProfile() {
        if (gProfiles == null) {
            gProfiles = new HashMap();
            Context.initializeProfiles(gProfiles);
        }
        return defaultProfile;
    }

    public static Context getContext(String string) {
        Context context = null;
        Profile profile = Context.getProfile(string);
        if (profile != null) {
            context = profile.context;
        }
        return context == null ? defaultContext : context;
    }

    public static Map getProfiles() {
        if (gProfiles == null) {
            gProfiles = new HashMap();
            Context.initializeProfiles(gProfiles);
        }
        return Collections.unmodifiableMap(gProfiles);
    }

    public static void update(Profile[] profileArray, String string) {
        if (gProfiles == null) {
            return;
        }
        Iterator iterator = gProfiles.values().iterator();
        gProfiles = new HashMap();
        while (iterator.hasNext()) {
            Profile profile = (Profile)iterator.next();
            if (profile.isCustom()) continue;
            gProfiles.put(profile.getId(), profile);
        }
        if (profileArray != null && profileArray.length > 0) {
            for (int i = 0; i < profileArray.length; ++i) {
                Profile profile = profileArray[i];
                gProfiles.put(profile.getId(), profile);
            }
        }
        Context.resetDefault(gProfiles, string);
    }

    public static void resetDefault(String string) {
        if (gProfiles == null) {
            return;
        }
        Context.resetDefault(gProfiles, string);
    }

    public static Context getContext(IEditorInput iEditorInput) {
        String string = null;
        if (iEditorInput instanceof IFileEditorInput) {
            return Context.getContext(((IFileEditorInput)iEditorInput).getFile());
        }
        return Context.getContext(string);
    }

    public static Context getContext(IFile iFile) {
        ProjectScope projectScope;
        IEclipsePreferences iEclipsePreferences;
        IProject iProject;
        String string = null;
        if (iFile != null && (iProject = iFile.getProject()) != null && (iEclipsePreferences = (projectScope = new ProjectScope(iProject)).getNode("com.spket.js")) != null) {
            string = iEclipsePreferences.get("js.profile", null);
        }
        return Context.getContext(string);
    }

    public static Profile getProfile(String string) {
        if (gProfiles == null) {
            gProfiles = new HashMap();
            Context.initializeProfiles(gProfiles);
        }
        if (string == null) {
            return null;
        }
        Profile profile = (Profile)gProfiles.get(string);
        if (profile != null && profile.context == null) {
            profile.context = Context.createContext(profile.id);
            if (profile.context == null) {
                profile.context = defaultContext;
            }
        }
        return profile;
    }

    protected static void initializeProfiles(Map map) {
        Object object;
        Profile profile;
        IConfigurationElement[] iConfigurationElementArray;
        String string = null;
        IPreferenceStore iPreferenceStore = JSPlugin.getDefault().getPreferenceStore();
        if (iPreferenceStore != null) {
            string = iPreferenceStore.getString("js.profile");
        }
        if ((iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(PROFILE_EXTENSIONS)).length > 0) {
            for (int i = 0; i < iConfigurationElementArray.length; ++i) {
                profile = new Profile();
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[i];
                object = iConfigurationElement.getAttribute(A_ID);
                profile.id = object;
                profile.name = iConfigurationElement.getAttribute(A_NAME);
                profile.isDefault = StringUtils.toBoolean((String)iConfigurationElement.getAttribute(A_DEFAULT));
                map.put(object, profile);
            }
        }
        object = null;
        try {
            object = ProfileLoader.loadProfiles();
        }
        catch (CoreException coreException) {
            JSPlugin.log(coreException.getStatus());
        }
        if (object != null) {
            for (int i = 0; i < ((Profile[])object).length; ++i) {
                profile = object[i];
                map.put(profile.getId(), profile);
            }
        }
        Context.resetDefault(map, string);
    }

    protected static void resetDefault(Map map, String string) {
        Profile profile = null;
        if (string != null) {
            profile = (Profile)map.get(string);
        }
        if (profile == null) {
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                Profile profile2 = (Profile)iterator.next();
                if (!profile2.isDefault()) continue;
                profile = profile2;
                break;
            }
        }
        defaultProfile = profile;
        if (profile != null) {
            if (profile.context == null && !profile.isCustom()) {
                profile.context = Context.createContext(profile.getId());
            }
            defaultContext = profile.context;
        }
        if (defaultContext == null) {
            defaultContext = new DefaultContext();
        }
    }

    protected static Context createContext(String string) {
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(PROFILE_EXTENSIONS);
        if (iConfigurationElementArray.length > 0) {
            for (int i = 0; i < iConfigurationElementArray.length; ++i) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[i];
                if (!string.equals(iConfigurationElement.getAttribute(A_ID))) continue;
                Context context = null;
                String string2 = iConfigurationElement.getAttribute(A_CLASS);
                if (string2 == null) {
                    JSPlugin.logErrorMessage("class is required for profile: " + string);
                } else {
                    try {
                        context = (Context)iConfigurationElement.createExecutableExtension(A_CLASS);
                    }
                    catch (CoreException coreException) {
                        JSPlugin.log(coreException.getStatus());
                    }
                    catch (ClassCastException classCastException) {
                        JSPlugin.log(classCastException);
                    }
                }
                return context;
            }
        }
        return null;
    }

    public ExpressionEvaluator createExpressionEvaluator() {
        return new ExpressionEvaluator(this);
    }

    public JSObject newInstance(JSObject jSObject) {
        return null;
    }

    public ScriptManager getManager() {
        return ScriptManager.getManager(this.getSourceLevel());
    }

    public int getSourceLevel() {
        return JS_1_6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        this.state = 1;
        try {
            this.loadClasses();
            this.state = 2;
        }
        catch (IOException iOException) {
            JSPlugin.log(iOException);
        }
        finally {
            if (this.state != 2) {
                this.state = 3;
            }
        }
    }

    public void initialize() {
        this.initialize(null);
    }

    public void initialize(Runnable runnable) {
        if (this.state == 0) {
            this.state = 1;
            if (runnable != null) {
                this.fCallback = runnable;
            }
            this.asyncLoadClasses();
        } else if (this.state == 1 && runnable != null) {
            this.fCallback = runnable;
        }
    }

    public final boolean isInitialized() {
        return this.state == 2;
    }

    public boolean isFailed() {
        return this.state == 3;
    }

    public Object getAdapter(Class clazz) {
        if ((class$com$spket$ui$UIItem == null ? (class$com$spket$ui$UIItem = Context.class$("com.spket.ui.UIItem")) : class$com$spket$ui$UIItem).equals(clazz)) {
            return new UIContext(this);
        }
        return null;
    }

    protected final void asyncLoadClasses() {
        Job job = new Job("Loading Context"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected IStatus run(IProgressMonitor iProgressMonitor) {
                block7: {
                    try {
                        try {
                            Context.this.loadClasses();
                            Context.this.state = 2;
                        }
                        catch (IOException iOException) {
                            JSPlugin.log(iOException);
                            Object var4_3 = null;
                            if (Context.this.state != 2) {
                                Context.this.state = 3;
                            }
                            if (Context.this.fCallback == null) return Status.OK_STATUS;
                            Runnable runnable = Context.this.fCallback;
                            Context.this.fCallback = null;
                            runnable.run();
                            return Status.OK_STATUS;
                        }
                        Object var4_2 = null;
                        if (Context.this.state == 2) break block7;
                        Context.this.state = 3;
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        if (Context.this.state != 2) {
                            Context.this.state = 3;
                        }
                        if (Context.this.fCallback == null) throw throwable;
                        Runnable runnable = Context.this.fCallback;
                        Context.this.fCallback = null;
                        runnable.run();
                        throw throwable;
                    }
                }
                if (Context.this.fCallback == null) return Status.OK_STATUS;
                Runnable runnable = Context.this.fCallback;
                Context.this.fCallback = null;
                runnable.run();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setPriority(40);
        job.schedule();
    }

    protected abstract void loadClasses() throws IOException;

    public abstract JSObject getGlobal();

    public abstract JSObject getGlobalForEdit();

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        defaultContext = new DefaultContext();
    }

    private static final class DefaultContext
    extends Context {
        private JSObject global = new ObjectImpl();

        private DefaultContext() {
        }

        public JSObject getGlobal() {
            return this.global;
        }

        public JSObject getGlobalForEdit() {
            return new ObjectImpl();
        }

        protected void loadClasses() {
        }
    }
}

