/*
 * Decompiled with CFR 0.152.
 */
package com.spket.js.internal.views;

import com.spket.js.internal.text.hover.JSTextHover;
import com.spket.js.internal.views.UIContext;
import com.spket.js.model.Context;
import com.spket.js.model.ISlot;
import com.spket.js.model.JSObject;
import com.spket.ui.UIItem;
import com.spket.ui.text.IDocumentation;
import com.spket.ui.text.html.HTMLPrinter;

public abstract class UIObject
implements UIItem,
IDocumentation {
    private UIItem parent;

    public Object getParent() {
        return this.parent;
    }

    public void setParent(UIItem uIItem) {
        this.parent = uIItem;
    }

    public String getDocument() {
        ISlot iSlot = this.getSlot();
        if (iSlot != null) {
            Object object = iSlot.getData(ISlot.P_COMMENT);
            if (object instanceof String) {
                return (String)object;
            }
            if (object instanceof IDocumentation) {
                return ((IDocumentation)object).getDocument();
            }
        }
        return null;
    }

    public String getDocumentAsHTML() {
        ISlot iSlot = this.getSlot();
        if (iSlot != null) {
            Object object = iSlot.getData(ISlot.P_COMMENT);
            if (object instanceof IDocumentation) {
                String string = JSTextHover.getHeader(this.getName(), iSlot);
                String string2 = ((IDocumentation)object).getDocumentAsHTML();
                if (string == null) {
                    return string2;
                }
                StringBuffer stringBuffer = new StringBuffer();
                HTMLPrinter.addSmallHeader((StringBuffer)stringBuffer, (String)string);
                if (string2 != null) {
                    stringBuffer.append(string2);
                }
                return stringBuffer.toString();
            }
            return JSTextHover.getHoverInfo(this.getName(), iSlot);
        }
        String string = this.getDocument();
        if (string != null && string.length() > 0) {
            StringBuffer stringBuffer = new StringBuffer(string.length());
            JSTextHover.toHTML(stringBuffer, string);
            if (stringBuffer.length() > 0) {
                return stringBuffer.toString();
            }
        }
        return null;
    }

    public String getStyleSheet() {
        Object object;
        ISlot iSlot = this.getSlot();
        if (iSlot != null && (object = iSlot.getData(ISlot.P_COMMENT)) instanceof IDocumentation) {
            return ((IDocumentation)object).getStyleSheet();
        }
        return null;
    }

    protected ISlot getSlot() {
        return null;
    }

    protected Context getContext() {
        Object object = this.getParent();
        while (object != null) {
            if (object instanceof UIContext) {
                return ((UIContext)object).getContext();
            }
            if (object instanceof UIItem) {
                object = ((UIItem)object).getParent();
                continue;
            }
            object = null;
        }
        return null;
    }

    protected JSObject getGlobal() {
        Context context = this.getContext();
        if (context == null) {
            return null;
        }
        return context.getGlobal();
    }
}

