/*
 * Decompiled with CFR 0.152.
 */
package com.spket.js.internal.views;

import com.spket.js.internal.JSImages;
import com.spket.js.internal.JSMessages;
import com.spket.js.internal.JSPlugin;
import com.spket.js.internal.views.IFlatNode;
import com.spket.js.internal.views.JSNode;
import com.spket.js.model.Context;
import com.spket.js.model.Profile;
import com.spket.ui.DefaultUIContentProvider;
import com.spket.ui.DefaultUILabelProvider;
import com.spket.ui.UIElement;
import com.spket.ui.UIItem;
import com.spket.ui.internal.UIImages;
import com.spket.ui.util.SelectionDispatcher;
import com.spket.util.IDragSource;
import com.spket.widget.BorderLayout;
import com.spket.widget.UIUtils;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;

public class ProfileView
extends ViewPart {
    private static final String PROFILE = "pv.pid";
    private static final String LAYOUT = "pv.flat";
    private Watcher fWatcher;
    private Profile fProfile;
    private TreeViewer fViewer;
    private TableViewer fMemberViewer;
    private JSNode fNode;
    private SelectionDispatcher fSelectionProvider;
    private boolean usingFlatLayout;
    static /* synthetic */ Class class$com$spket$ui$UIItem;

    public void createPartControl(Composite composite) {
        IToolBarManager iToolBarManager;
        Composite composite2 = new Composite(composite, 0);
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.attach(composite2);
        this.fViewer = new TreeViewer(composite2, 772);
        this.fMemberViewer = new TableViewer(composite2, 512);
        borderLayout.addLayoutControl((Control)this.fViewer.getTree(), 0);
        borderLayout.addLayoutControl((Control)this.fMemberViewer.getTable(), 2, 40);
        this.fViewer.setLabelProvider((IBaseLabelProvider)new DefaultUILabelProvider());
        this.fViewer.setContentProvider((IContentProvider)new DefaultUIContentProvider());
        this.fMemberViewer.setLabelProvider((IBaseLabelProvider)new DefaultUILabelProvider());
        this.fMemberViewer.setContentProvider((IContentProvider)new MemberContentProvider());
        this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                ProfileView.this.onDoubleClick(doubleClickEvent);
            }
        });
        this.fViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                ProfileView.this.onSelectionChanged(selectionChangedEvent);
            }
        });
        this.initDragAndDrop();
        IPreferenceStore iPreferenceStore = JSPlugin.getDefault().getPreferenceStore();
        this.usingFlatLayout = iPreferenceStore.getBoolean(LAYOUT);
        IActionBars iActionBars = this.getViewSite().getActionBars();
        IMenuManager iMenuManager = iActionBars.getMenuManager();
        if (iMenuManager != null) {
            iMenuManager.add((IContributionItem)new SwitchProfileMenu());
        }
        if ((iToolBarManager = iActionBars.getToolBarManager()) != null) {
            iToolBarManager.add((IAction)new LayoutAction(this.usingFlatLayout));
        }
        this.fSelectionProvider = new SelectionDispatcher();
        this.fSelectionProvider.setSelectionProvider((ISelectionProvider)this.fViewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this.fSelectionProvider);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (event.widget instanceof Tree) {
                    ProfileView.this.fSelectionProvider.setSelectionProvider((ISelectionProvider)ProfileView.this.fViewer);
                } else {
                    ProfileView.this.fSelectionProvider.setSelectionProvider((ISelectionProvider)ProfileView.this.fMemberViewer);
                }
            }
        };
        this.fViewer.getTree().addListener(15, listener);
        this.fMemberViewer.getTable().addListener(15, listener);
        String string = iPreferenceStore.getString(PROFILE);
        if (string == null || string.length() == 0) {
            string = iPreferenceStore.getString("js.profile");
        }
        this.fProfile = string == null || string.length() == 0 ? Context.getDefaultProfile() : Context.getProfile(string);
        this.loading();
    }

    public void dispose() {
        if (this.fSelectionProvider != null) {
            this.fSelectionProvider.dispose();
            this.fSelectionProvider = null;
        }
        super.dispose();
    }

    public void setFocus() {
        Table table;
        boolean bl = true;
        if (this.fSelectionProvider != null) {
            boolean bl2 = bl = this.fSelectionProvider.getSelectionProvider() == this.fViewer;
        }
        if (bl && this.fViewer != null) {
            Tree tree = this.fViewer.getTree();
            if (UIUtils.okToUse((Widget)tree)) {
                tree.setFocus();
            }
        } else if (this.fMemberViewer != null && UIUtils.okToUse((Widget)(table = this.fMemberViewer.getTable()))) {
            table.setFocus();
        }
    }

    protected void onDoubleClick(DoubleClickEvent doubleClickEvent) {
        Object object;
        ISelection iSelection = doubleClickEvent.getSelection();
        if (iSelection instanceof IStructuredSelection && this.fViewer.isExpandable(object = ((IStructuredSelection)iSelection).getFirstElement())) {
            this.fViewer.setExpandedState(object, !this.fViewer.getExpandedState(object));
        }
    }

    protected void onProfileChanged(Event event) {
        String string;
        MenuItem menuItem;
        if (event.widget instanceof MenuItem && (menuItem = (MenuItem)event.widget).getSelection() && (string = (String)menuItem.getData(PROFILE)) != null) {
            JSPlugin.getDefault().getPreferenceStore().setValue(PROFILE, string);
            Profile profile = Context.getProfile(string);
            if (profile != this.fProfile) {
                this.fProfile = profile;
                this.loading();
            }
        }
    }

    protected void initDragAndDrop() {
        int n = 23;
        Transfer[] transferArray = new Transfer[]{LocalSelectionTransfer.getTransfer(), TextTransfer.getInstance()};
        DragSourceListener dragSourceListener = new DragSourceListener(){

            public void dragFinished(DragSourceEvent dragSourceEvent) {
                LocalSelectionTransfer.getTransfer().setSelection(null);
            }

            public void dragSetData(DragSourceEvent dragSourceEvent) {
                ISelection iSelection;
                LocalSelectionTransfer localSelectionTransfer = LocalSelectionTransfer.getTransfer();
                if (localSelectionTransfer.isSupportedType(dragSourceEvent.dataType)) {
                    dragSourceEvent.data = localSelectionTransfer.getSelection();
                } else if (TextTransfer.getInstance().isSupportedType(dragSourceEvent.dataType) && (iSelection = localSelectionTransfer.getSelection()) instanceof IStructuredSelection) {
                    Object object = ((IStructuredSelection)iSelection).getFirstElement();
                    dragSourceEvent.data = object instanceof IDragSource ? ((IDragSource)object).toSource() : object.toString();
                }
            }

            public void dragStart(DragSourceEvent dragSourceEvent) {
                Object object = null;
                ISelection iSelection = null;
                if (dragSourceEvent.widget instanceof DragSource) {
                    Control control = ((DragSource)dragSourceEvent.widget).getControl();
                    iSelection = control instanceof Tree ? ProfileView.this.fViewer.getSelection() : ProfileView.this.fMemberViewer.getSelection();
                }
                if (iSelection instanceof IStructuredSelection) {
                    object = ((IStructuredSelection)iSelection).getFirstElement();
                }
                if (object instanceof IDragSource) {
                    dragSourceEvent.doit = true;
                    LocalSelectionTransfer.getTransfer().setSelection(iSelection);
                } else {
                    dragSourceEvent.doit = false;
                }
            }
        };
        this.fViewer.addDragSupport(n, transferArray, dragSourceListener);
        this.fMemberViewer.addDragSupport(n, transferArray, dragSourceListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loading() {
        Object object;
        if (this.fWatcher != null) {
            object = this.fViewer;
            synchronized (object) {
                if (this.fWatcher != null) {
                    this.fWatcher.cancel();
                    this.fWatcher = null;
                }
            }
        }
        object = null;
        if (this.fProfile != null) {
            object = this.fProfile.getContext();
        }
        if (object == null) {
            this.fViewer.setInput(null);
        } else if (((Context)object).isInitialized()) {
            this.show((Context)object);
        } else {
            Tree tree = this.fViewer.getTree();
            tree.setCursor(tree.getDisplay().getSystemCursor(3));
            UIElement uIElement = new UIElement();
            UIElement uIElement2 = new UIElement(JSMessages.PV_loading);
            uIElement2.setParent((Object)uIElement);
            uIElement2.setImage(JSImages.get("c.s.js.event_obj.gif"));
            uIElement.setChildren(new Object[]{uIElement2});
            this.fViewer.setInput((Object)uIElement);
            this.fWatcher = new Watcher();
            ((Context)object).initialize(this.fWatcher);
        }
    }

    protected void show(Context context) {
        if (context == null) {
            this.fViewer.setInput(null);
        } else {
            UIItem uIItem = null;
            if (context instanceof IAdaptable) {
                uIItem = (UIItem)context.getAdapter(class$com$spket$ui$UIItem == null ? (class$com$spket$ui$UIItem = ProfileView.class$("com.spket.ui.UIItem")) : class$com$spket$ui$UIItem);
            }
            if (uIItem instanceof IFlatNode) {
                ((IFlatNode)uIItem).setFlat(this.usingFlatLayout);
            }
            this.fViewer.setInput((Object)uIItem);
        }
    }

    protected void toggleFlatLayout() {
        this.usingFlatLayout = !this.usingFlatLayout;
        JSPlugin.getDefault().getPreferenceStore().setValue(LAYOUT, this.usingFlatLayout);
        Object object = this.fViewer.getInput();
        if (object instanceof IFlatNode) {
            IFlatNode iFlatNode = (IFlatNode)object;
            iFlatNode.setFlat(this.usingFlatLayout);
            Tree tree = this.fViewer.getTree();
            Shell shell = tree.getShell();
            shell.setCursor(shell.getDisplay().getSystemCursor(1));
            tree.setRedraw(false);
            Object[] objectArray = iFlatNode.getFlatNodes();
            if (objectArray != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] == null) continue;
                    this.fViewer.setExpandedState(objectArray[i], false);
                }
            }
            this.fViewer.refresh();
            tree.setRedraw(true);
            shell.setCursor(null);
        }
    }

    protected void onSelectionChanged(SelectionChangedEvent selectionChangedEvent) {
        Object object;
        JSNode jSNode = null;
        ISelection iSelection = selectionChangedEvent.getSelection();
        if (iSelection instanceof IStructuredSelection && (object = ((IStructuredSelection)iSelection).getFirstElement()) instanceof JSNode) {
            jSNode = (JSNode)object;
        }
        if (jSNode == this.fNode) {
            return;
        }
        this.fNode = jSNode;
        this.fMemberViewer.setInput((Object)this.fNode);
    }

    static /* synthetic */ Watcher access$302(ProfileView profileView, Watcher watcher) {
        profileView.fWatcher = watcher;
        return profileView.fWatcher;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Watcher
    implements Runnable {
        private boolean fCancelled;

        public void run() {
            Tree tree;
            if (this.fCancelled) {
                return;
            }
            if (ProfileView.this.fWatcher == this && ProfileView.this.fViewer != null && UIUtils.okToUse((Widget)(tree = ProfileView.this.fViewer.getTree()))) {
                tree.getDisplay().asyncExec(new Runnable(this){
                    private final /* synthetic */ Watcher this$1;
                    {
                        this.this$1 = watcher;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        if (ProfileView.access$400(Watcher.access$500(this.this$1)) != null) {
                            Tree tree = ProfileView.access$400(Watcher.access$500(this.this$1)).getTree();
                            if (!Watcher.access$600(this.this$1) && UIUtils.okToUse((Widget)tree)) {
                                tree.setCursor(null);
                                TreeViewer treeViewer = ProfileView.access$400(Watcher.access$500(this.this$1));
                                synchronized (treeViewer) {
                                    if (!Watcher.access$600(this.this$1)) {
                                        ProfileView.access$302(Watcher.access$500(this.this$1), null);
                                        Context context = null;
                                        if (ProfileView.access$200(Watcher.access$500(this.this$1)) != null) {
                                            context = ProfileView.access$200(Watcher.access$500(this.this$1)).getContext();
                                        }
                                        Watcher.access$500(this.this$1).show(context);
                                    }
                                }
                            }
                        }
                    }
                });
            }
        }

        public void cancel() {
            this.fCancelled = true;
        }

        static /* synthetic */ ProfileView access$500(Watcher watcher) {
            return watcher.ProfileView.this;
        }

        static /* synthetic */ boolean access$600(Watcher watcher) {
            return watcher.fCancelled;
        }
    }

    private class SwitchProfileMenu
    extends ContributionItem {
        private SwitchProfileMenu() {
        }

        public void fill(Menu menu, int n) {
            Map map = Context.getProfiles();
            if (map.size() > 0) {
                Profile[] profileArray = new Profile[map.size()];
                map.values().toArray(profileArray);
                Arrays.sort(profileArray, new ProfileComparator());
                Listener listener = new Listener(){

                    public void handleEvent(Event event) {
                        ProfileView.this.onProfileChanged(event);
                    }
                };
                String string = JSPlugin.getDefault().getPreferenceStore().getString(ProfileView.PROFILE);
                for (int i = 0; i < profileArray.length; ++i) {
                    MenuItem menuItem = new MenuItem(menu, 16);
                    Profile profile = profileArray[i];
                    menuItem.setText(profile.getName());
                    menuItem.setData(ProfileView.PROFILE, (Object)profile.getId());
                    if (string == null || string.length() == 0) {
                        if (ProfileView.this.fProfile == profile) {
                            menuItem.setSelection(true);
                        }
                    } else if (string.equals(profile.getId())) {
                        menuItem.setSelection(true);
                    }
                    menuItem.addListener(13, listener);
                }
            }
        }
    }

    private class LayoutAction
    extends Action {
        public LayoutAction(boolean bl) {
            super("", 2);
            this.setText(JSMessages.PV_Layout_text);
            this.setToolTipText(JSMessages.PV_Layout_tooltip);
            this.setImageDescriptor(UIImages.getImageDescriptor((String)"com.spket.ui", (int)2, (String)"tree_mode.gif"));
            if (!bl) {
                this.setChecked(true);
            }
        }

        public void run() {
            ProfileView.this.toggleFlatLayout();
        }
    }

    private static class MemberContentProvider
    implements IStructuredContentProvider {
        private MemberContentProvider() {
        }

        public Object[] getElements(Object object) {
            if (object instanceof JSNode) {
                return ((JSNode)object).getMembers();
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    private static class ProfileComparator
    implements Comparator {
        private ProfileComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object instanceof Profile && object2 instanceof Profile) {
                return ((Profile)object).getName().compareTo(((Profile)object2).getName());
            }
            return 0;
        }
    }
}

