/*
 * Decompiled with CFR 0.152.
 */
package com.spket.js.internal.text.hover;

import com.spket.as.internal.compiler.parser.BufferedScanner;
import com.spket.as.internal.compiler.parser.ScannerHelper;
import com.spket.js.internal.JSMessages;
import com.spket.js.internal.text.IInformationControlExtension4;
import com.spket.js.internal.text.JSDoc2HTMLTextReader;
import com.spket.js.internal.text.JSDocCommentReader;
import com.spket.js.internal.text.JSWordDetector;
import com.spket.js.model.ILexerContext;
import com.spket.js.model.ILexerProvider;
import com.spket.js.model.ISlot;
import com.spket.js.model.JSDoc;
import com.spket.js.model.JSFunction;
import com.spket.js.model.JSObject;
import com.spket.js.model.Param;
import com.spket.js.parser.CompletionEngine;
import com.spket.ui.text.AbstractReusableInformationControlCreator;
import com.spket.ui.text.DefaultInformationControlCreator;
import com.spket.ui.text.ProblemAnnotation;
import com.spket.ui.text.html.HTMLPrinter;
import com.spket.ui.text.html.HTMLTextPresenter;
import com.spket.util.StringUtils;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.Iterator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;

public class JSTextHover
implements ITextHover,
ITextHoverExtension,
IInformationProviderExtension2 {
    private ILexerContext fContext;
    private IBindingService fBindingService;
    private String fPartitioning;
    private IInformationControlCreator fHoverControlCreator;
    private IInformationControlCreator fPresenterControlCreator;
    static /* synthetic */ Class class$org$eclipse$ui$keys$IBindingService;

    public static String getHeader(String string, ISlot iSlot) {
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        JSObject jSObject = iSlot.getObject();
        if (jSObject instanceof JSFunction) {
            int n;
            JSFunction jSFunction = (JSFunction)jSObject;
            Object object = jSFunction.getValue();
            if (object instanceof String) {
                stringBuffer.append((String)object).append(' ');
            }
            if ((string2 = jSFunction.getFunctionName()) == null) {
                string2 = string;
            }
            if (string2 == null) {
                stringBuffer.append("Function");
            } else {
                stringBuffer.append(string2);
            }
            stringBuffer.append('(');
            if (jSFunction.prototype() == 2 && (n = jSFunction.getNumberOfParameters()) > 0) {
                boolean bl = false;
                Param[] paramArray = jSFunction.getParameters();
                for (int i = 0; i < n; ++i) {
                    Param param = paramArray[i];
                    int n2 = param.getFlags();
                    if (!bl && (n2 & 0x400) != 0) {
                        bl = true;
                        stringBuffer.append('[');
                    }
                    if (i > 0) {
                        stringBuffer.append(", ");
                    }
                    if ((n2 & 0x40) != 0) {
                        if ((n2 & 0x80) == 0) {
                            stringBuffer.append("in ");
                        } else {
                            stringBuffer.append("inout ");
                        }
                    } else if ((n2 & 0x80) != 0) {
                        stringBuffer.append("out ");
                    }
                    if ((n2 & 0x200) == 0) {
                        String[] stringArray = param.getTypes();
                        if (stringArray != null && stringArray.length > 0) {
                            for (int j = 0; j < stringArray.length; ++j) {
                                if (j > 0) {
                                    stringBuffer.append('/');
                                }
                                stringBuffer.append(stringArray[j]);
                            }
                            stringBuffer.append(' ');
                        }
                    } else {
                        stringBuffer.append("...");
                    }
                    stringBuffer.append(param.getName());
                    if ((n2 & 0x100) == 0) continue;
                    stringBuffer.append("[]");
                }
                if (bl) {
                    stringBuffer.append(']');
                }
            }
            stringBuffer.append(')');
        } else {
            if (jSObject != null) {
                string2 = jSObject.getClassName();
            }
            if (string2 == null) {
                Object object = iSlot.getData(ISlot.P_TYPE);
                if (object instanceof String) {
                    stringBuffer.append((String)object).append(' ');
                } else if (object instanceof String[]) {
                    String[] stringArray = (String[])object;
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (i > 0) {
                            stringBuffer.append('/');
                        }
                        stringBuffer.append(stringArray[i]);
                    }
                    stringBuffer.append(' ');
                }
            } else {
                stringBuffer.append(string2).append(' ');
            }
            string2 = string;
            if (string2 != null) {
                stringBuffer.append(string2);
            }
        }
        return stringBuffer.length() == 0 ? null : stringBuffer.toString();
    }

    public static String getHoverInfo(String string, ISlot iSlot) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = JSTextHover.getHeader(string, iSlot);
        if (string2 != null) {
            HTMLPrinter.addSmallHeader((StringBuffer)stringBuffer, (String)string2);
        }
        Object object = iSlot.getData(ISlot.P_COMMENT);
        String string3 = null;
        if (object instanceof String) {
            string3 = (String)object;
        } else if (object instanceof JSDoc) {
            string3 = ((JSDoc)object).getComment();
        }
        JSTextHover.toHTML(stringBuffer, string3);
        return stringBuffer.toString();
    }

    public static void toHTML(StringBuffer stringBuffer, String string) {
        if (string != null && string.length() > 2) {
            int n = string.indexOf("/*", 0);
            if (n == -1) {
                HTMLPrinter.addParagraph((StringBuffer)stringBuffer, (String)string);
            } else {
                int n2;
                while ((n2 = string.indexOf("*/", n)) != -1) {
                    JSDoc2HTMLTextReader jSDoc2HTMLTextReader = new JSDoc2HTMLTextReader((Reader)((Object)new JSDocCommentReader(string, n, n2 += 2)));
                    HTMLPrinter.addParagraph((StringBuffer)stringBuffer, (Reader)((Object)jSDoc2HTMLTextReader));
                    n = string.indexOf("/*", n2);
                    if (n != -1) continue;
                    break;
                }
            }
        }
    }

    static IRegion getRegion(IDocument iDocument, String string, int n) {
        try {
            ITypedRegion iTypedRegion = TextUtilities.getPartition((IDocument)iDocument, (String)string, (int)n, (boolean)false);
            if (iTypedRegion != null && "__js_string".equals(iTypedRegion.getType())) {
                int n2 = iTypedRegion.getOffset() - 1;
                while (n2 > 0) {
                    char c;
                    if ((c = iDocument.getChar(n2--)) == '[') {
                        n2 = iTypedRegion.getOffset() + iTypedRegion.getLength();
                        while (n2 < iDocument.getLength()) {
                            if ((c = iDocument.getChar(n2++)) == ']') {
                                return iTypedRegion;
                            }
                            if (ScannerHelper.isWhitespace((char)c)) continue;
                            return null;
                        }
                        return iTypedRegion;
                    }
                    if (ScannerHelper.isWhitespace((char)c)) continue;
                    return null;
                }
                return null;
            }
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        return JSWordDetector.findWord(iDocument, n);
    }

    private String formatMessage(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        HTMLPrinter.addPageProlog((StringBuffer)stringBuffer);
        HTMLPrinter.addParagraph((StringBuffer)stringBuffer, (String)HTMLPrinter.convertToHTMLContent((String)string));
        HTMLPrinter.addPageEpilog((StringBuffer)stringBuffer);
        return stringBuffer.toString();
    }

    public JSTextHover(ILexerContext iLexerContext, String string) {
        this.fContext = iLexerContext;
        this.fPartitioning = string;
        this.fBindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(class$org$eclipse$ui$keys$IBindingService == null ? (class$org$eclipse$ui$keys$IBindingService = JSTextHover.class$("org.eclipse.ui.keys.IBindingService")) : class$org$eclipse$ui$keys$IBindingService);
    }

    public IRegion getHoverRegion(ITextViewer iTextViewer, int n) {
        return JSTextHover.getRegion(iTextViewer.getDocument(), this.fPartitioning, n);
    }

    public String getHoverInfo(ITextViewer iTextViewer, IRegion iRegion) {
        Object object;
        Object object2;
        Iterator iterator;
        ISourceViewer iSourceViewer;
        Object object3;
        if (iTextViewer instanceof ISourceViewer && (object3 = (iSourceViewer = (ISourceViewer)iTextViewer).getAnnotationModel()) != null) {
            iterator = object3.getAnnotationIterator();
            while (iterator.hasNext()) {
                String string;
                object2 = (Annotation)iterator.next();
                if (!(object2 instanceof ProblemAnnotation) || !(object = object3.getPosition((Annotation)object2)).overlapsWith(iRegion.getOffset(), iRegion.getLength()) || StringUtils.isEmpty((String)(string = object2.getText()))) continue;
                return this.formatMessage(string);
            }
        }
        if (iRegion.getLength() == 0 || this.fContext == null) {
            return null;
        }
        int n = iRegion.getOffset();
        object3 = this.fContext.getLexerProvider(n);
        if (object3 == null) {
            return null;
        }
        iterator = object3.getLexer();
        if (iterator != null) {
            object2 = new CompletionEngine((ILexerProvider)object3);
            ((CompletionEngine)object2).setLexer((BufferedScanner)iterator);
            object = ((CompletionEngine)object2).select(n);
            if (object != null) {
                return JSTextHover.getHoverInfo(((CompletionEngine)object2).getTokenName(), (ISlot)object);
            }
        }
        return null;
    }

    public IInformationControlCreator getHoverControlCreator() {
        if (this.fHoverControlCreator == null) {
            this.fHoverControlCreator = new AbstractReusableInformationControlCreator(){

                public IInformationControl doCreateInformationControl(Shell shell) {
                    return new DefaultInformationControl(shell, 0, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true), JSTextHover.this.getTooltipAffordanceString());
                }

                public boolean canReuse(IInformationControl iInformationControl) {
                    boolean bl = super.canReuse(iInformationControl);
                    if (bl && iInformationControl instanceof IInformationControlExtension4) {
                        ((IInformationControlExtension4)iInformationControl).setStatusText(JSTextHover.this.getTooltipAffordanceString());
                    }
                    return bl;
                }
            };
        }
        return this.fHoverControlCreator;
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.fPresenterControlCreator == null) {
            this.fPresenterControlCreator = new DefaultInformationControlCreator();
        }
        return this.fPresenterControlCreator;
    }

    protected String getTooltipAffordanceString() {
        if (this.fBindingService == null) {
            return null;
        }
        String string = this.fBindingService.getBestActiveBindingFormattedFor("com.spket.ui.edit.show_info");
        if (string == null) {
            return null;
        }
        Object[] objectArray = new Object[]{string == null ? "" : string};
        return MessageFormat.format(JSMessages.TextHover_makeStickyHint, objectArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

