/*
 * Decompiled with CFR 0.152.
 */
package com.spket.js.internal.text;

import com.spket.js.text.JSPartitions;
import com.spket.ui.text.BufferedDocumentScanner;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class JSPartitionScanner
implements IPartitionTokenScanner,
JSPartitions {
    private static final int JAVA = 0;
    private static final int SINGLE_LINE_COMMENT = 1;
    private static final int MULTI_LINE_COMMENT = 2;
    private static final int JAVADOC = 3;
    private static final int STRING = 4;
    private static final int REGEXP = 5;
    private static final int NONE = 0;
    private static final int BACKSLASH = 1;
    private static final int SLASH = 2;
    private static final int SLASH_STAR = 3;
    private static final int SLASH_STAR_STAR = 4;
    private static final int STAR = 5;
    private static final int CARRIAGE_RETURN = 6;
    private final BufferedDocumentScanner fScanner = new BufferedDocumentScanner(1000);
    private int fTokenOffset;
    private int fTokenLength;
    private int fQuote;
    private int fState;
    private int fLast;
    private int fPrefixLength;
    private boolean fEmulate = false;
    private int fJavaOffset;
    private int fJavaLength;
    private final IToken[] fTokens = new IToken[]{new Token(null), new Token((Object)"__js_singleline_comment"), new Token((Object)"__js_multiline_comment"), new Token((Object)"__js_jsdoc"), new Token((Object)"__js_string"), new Token((Object)"__js_regexp")};

    public JSPartitionScanner(boolean bl) {
        this.fEmulate = bl;
    }

    public JSPartitionScanner() {
        this(false);
    }

    public IToken nextToken() {
        if (this.fEmulate) {
            if (this.fJavaOffset != -1 && this.fTokenOffset + this.fTokenLength != this.fJavaOffset + this.fJavaLength) {
                this.fTokenOffset += this.fTokenLength;
                return this.fTokens[0];
            }
            this.fJavaOffset = -1;
            this.fJavaLength = 0;
        }
        this.fTokenOffset += this.fTokenLength;
        this.fTokenLength = this.fPrefixLength;
        boolean bl = false;
        block59: while (true) {
            block82: {
                int n = this.fScanner.read();
                switch (n) {
                    case -1: {
                        if (this.fTokenLength > 0) {
                            this.fLast = 0;
                            return this.preFix(this.fState, 0, 0, 0);
                        }
                        this.fLast = 0;
                        this.fPrefixLength = 0;
                        return Token.EOF;
                    }
                    case 13: {
                        if (!this.fEmulate && this.fLast != 6) {
                            this.fLast = 6;
                            ++this.fTokenLength;
                            continue block59;
                        }
                        switch (this.fState) {
                            case 1: 
                            case 4: 
                            case 5: {
                                if (this.fTokenLength > 0) {
                                    IToken iToken = this.fTokens[this.fState];
                                    if (this.fEmulate) {
                                        ++this.fTokenLength;
                                        this.fLast = 0;
                                        this.fPrefixLength = 0;
                                    } else {
                                        this.fLast = 6;
                                        this.fPrefixLength = 1;
                                    }
                                    this.fState = 0;
                                    return iToken;
                                }
                                this.consume();
                                continue block59;
                            }
                        }
                        this.consume();
                        continue block59;
                    }
                    case 10: {
                        switch (this.fState) {
                            case 1: 
                            case 4: 
                            case 5: {
                                return this.postFix(this.fState);
                            }
                        }
                        this.consume();
                        continue block59;
                    }
                }
                if (!this.fEmulate && this.fLast == 6) {
                    switch (this.fState) {
                        case 1: 
                        case 4: 
                        case 5: {
                            int n2;
                            int n3;
                            switch (n) {
                                case 47: {
                                    n3 = 2;
                                    n2 = 0;
                                    break;
                                }
                                case 42: {
                                    n3 = 5;
                                    n2 = 0;
                                    break;
                                }
                                case 34: 
                                case 39: {
                                    this.fQuote = n;
                                    n3 = 0;
                                    n2 = 4;
                                    break;
                                }
                                case 13: {
                                    n3 = 6;
                                    n2 = 0;
                                    break;
                                }
                                case 92: {
                                    n3 = 1;
                                    n2 = 0;
                                    break;
                                }
                                default: {
                                    n3 = 0;
                                    n2 = 0;
                                }
                            }
                            this.fLast = 0;
                            return this.preFix(this.fState, n2, n3, 1);
                        }
                    }
                }
                block21 : switch (this.fState) {
                    case 0: {
                        switch (n) {
                            case 47: {
                                if (this.fLast == 2) {
                                    if (this.fTokenLength - JSPartitionScanner.getLastLength(this.fLast) > 0) {
                                        return this.preFix(0, 1, 0, 2);
                                    }
                                    this.preFix(0, 1, 0, 2);
                                    this.fTokenOffset += this.fTokenLength;
                                    this.fTokenLength = this.fPrefixLength;
                                    break block21;
                                }
                                ++this.fTokenLength;
                                this.fLast = 2;
                                break block21;
                            }
                            case 42: {
                                if (this.fLast == 2) {
                                    if (this.fTokenLength - JSPartitionScanner.getLastLength(this.fLast) > 0) {
                                        return this.preFix(0, 2, 3, 2);
                                    }
                                    this.preFix(0, 2, 3, 2);
                                    this.fTokenOffset += this.fTokenLength;
                                    this.fTokenLength = this.fPrefixLength;
                                    break block21;
                                }
                                this.consume();
                                break block21;
                            }
                        }
                        if (this.fLast == 2 && this.isRegExp()) {
                            this.fScanner.unread();
                            if (this.fTokenLength > 1) {
                                return this.preFix(0, 5, 0, 1);
                            }
                            this.preFix(0, 5, 0, 1);
                            this.fTokenOffset += this.fTokenLength;
                            this.fTokenLength = this.fPrefixLength;
                            break;
                        }
                        this.fLast = 0;
                        if (n == 39 || n == 34) {
                            this.fQuote = n;
                            if (this.fTokenLength > 0) {
                                return this.preFix(0, 4, 0, 1);
                            }
                            this.preFix(0, 4, 0, 1);
                            this.fTokenOffset += this.fTokenLength;
                            this.fTokenLength = this.fPrefixLength;
                            break;
                        }
                        this.consume();
                        break;
                    }
                    case 1: {
                        this.consume();
                        break;
                    }
                    case 3: {
                        switch (n) {
                            case 47: {
                                switch (this.fLast) {
                                    case 4: {
                                        return this.postFix(2);
                                    }
                                    case 5: {
                                        return this.postFix(3);
                                    }
                                }
                                this.consume();
                                break block21;
                            }
                            case 42: {
                                ++this.fTokenLength;
                                this.fLast = 5;
                                break block21;
                            }
                        }
                        this.consume();
                        break;
                    }
                    case 2: {
                        switch (n) {
                            case 42: {
                                if (this.fLast == 3) {
                                    this.fLast = 4;
                                    ++this.fTokenLength;
                                    this.fState = 3;
                                    break block21;
                                }
                                ++this.fTokenLength;
                                this.fLast = 5;
                                break block21;
                            }
                            case 47: {
                                if (this.fLast == 5) {
                                    return this.postFix(2);
                                }
                                this.consume();
                                break block21;
                            }
                        }
                        this.consume();
                        break;
                    }
                    case 4: {
                        switch (n) {
                            case 92: {
                                this.fLast = this.fLast == 1 ? 0 : 1;
                                ++this.fTokenLength;
                                break block21;
                            }
                            case 34: 
                            case 39: {
                                if (this.fQuote == n && this.fLast != 1) {
                                    return this.postFix(4);
                                }
                                this.consume();
                                break block21;
                            }
                        }
                        this.consume();
                        break;
                    }
                    case 5: {
                        if (this.fLast == 1) {
                            this.consume();
                            break;
                        }
                        this.consume();
                        switch (n) {
                            case 47: {
                                if (!bl) {
                                    block60: while (true) {
                                        int n4 = this.fScanner.read();
                                        switch (n4) {
                                            case -1: {
                                                break block60;
                                            }
                                            case 103: 
                                            case 105: 
                                            case 109: {
                                                this.consume();
                                                continue block60;
                                            }
                                            default: {
                                                this.fScanner.unread();
                                                break block60;
                                            }
                                        }
                                        break;
                                    }
                                    return this.preFix(this.fState, 0, 0, 0);
                                }
                                break block82;
                            }
                            case 91: {
                                bl = true;
                                break block21;
                            }
                            case 93: {
                                bl = false;
                                break block21;
                            }
                            case 92: {
                                this.fLast = 1;
                            }
                        }
                    }
                }
            }
        }
    }

    private static final int getLastLength(int n) {
        switch (n) {
            default: {
                return -1;
            }
            case 0: {
                return 0;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: 
        }
        return 3;
    }

    private final void consume() {
        ++this.fTokenLength;
        this.fLast = 0;
    }

    private final IToken postFix(int n) {
        ++this.fTokenLength;
        this.fLast = 0;
        this.fState = 0;
        this.fPrefixLength = 0;
        return this.fTokens[n];
    }

    private final IToken preFix(int n, int n2, int n3, int n4) {
        if (this.fEmulate && n == 0 && this.fTokenLength - JSPartitionScanner.getLastLength(this.fLast) > 0) {
            this.fTokenLength -= JSPartitionScanner.getLastLength(this.fLast);
            this.fJavaOffset = this.fTokenOffset;
            this.fJavaLength = this.fTokenLength;
            this.fTokenLength = 1;
            this.fState = n2;
            this.fPrefixLength = n4;
            this.fLast = n3;
            return this.fTokens[n];
        }
        this.fTokenLength -= JSPartitionScanner.getLastLength(this.fLast);
        this.fLast = n3;
        this.fPrefixLength = n4;
        IToken iToken = this.fTokens[n];
        this.fState = n2;
        return iToken;
    }

    private static int getState(String string) {
        if (string == null) {
            return 0;
        }
        if (string.equals("__js_singleline_comment")) {
            return 1;
        }
        if (string.equals("__js_multiline_comment")) {
            return 2;
        }
        if (string.equals("__js_jsdoc")) {
            return 3;
        }
        if (string.equals("__js_string")) {
            return 4;
        }
        if (string.equals("__js_regexp")) {
            return 5;
        }
        return 0;
    }

    public void setPartialRange(IDocument iDocument, int n, int n2, String string, int n3) {
        this.fScanner.setRange(iDocument, n, n2);
        this.fTokenOffset = n3;
        this.fTokenLength = 0;
        this.fPrefixLength = n - n3;
        this.fLast = 0;
        this.fQuote = 0;
        this.fState = n == n3 ? 0 : JSPartitionScanner.getState(string);
        if (this.fEmulate) {
            this.fJavaOffset = -1;
            this.fJavaLength = 0;
        }
    }

    public void setRange(IDocument iDocument, int n, int n2) {
        this.fScanner.setRange(iDocument, n, n2);
        this.fTokenOffset = n;
        this.fTokenLength = 0;
        this.fPrefixLength = 0;
        this.fLast = 0;
        this.fState = 0;
        if (this.fEmulate) {
            this.fJavaOffset = -1;
            this.fJavaLength = 0;
        }
    }

    public int getTokenLength() {
        return this.fTokenLength;
    }

    public int getTokenOffset() {
        return this.fTokenOffset;
    }

    private boolean isRegExp() {
        int n = this.fScanner.getOffset() - 3;
        while (n > 0) {
            int n2 = this.fScanner.getChar(n--);
            switch (n2) {
                case -1: 
                case 125: {
                    return true;
                }
                case 34: 
                case 39: 
                case 41: 
                case 93: {
                    return false;
                }
                case 43: 
                case 45: {
                    return this.fScanner.getChar(n) != n2;
                }
            }
            if (n2 >= 48 && n2 <= 57 || Character.isJavaIdentifierPart((char)n2)) {
                return false;
            }
            if (Character.isWhitespace((char)n2)) continue;
            break;
        }
        return true;
    }
}

