/*
 * Decompiled with CFR 0.152.
 */
package com.spket.js.internal.text;

import com.spket.js.internal.text.JSCompletionCollector;
import com.spket.js.internal.text.hover.JSTextHover;
import com.spket.js.model.ISlot;
import com.spket.js.model.JSObject;
import com.spket.ui.text.IRelevanceSupport;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class JSCompletionProposal
implements ICompletionProposal,
ICompletionProposalExtension,
ICompletionProposalExtension2,
IRelevanceSupport {
    protected int fOffset;
    protected int fLength;
    protected Image fImage;
    protected int fRelevance;
    protected int fCursorPosition;
    protected String fDisplayString;
    protected String fReplacementString;
    protected char[] fTriggerCharacters;
    protected JSObject object;
    protected String name;
    protected ISlot slot;

    public JSCompletionProposal(JSObject jSObject, String string, ISlot iSlot) {
        this.object = jSObject;
        this.name = string;
        this.slot = iSlot;
    }

    public JSCompletionProposal(String string, int n, int n2, Image image, String string2, int n3) {
        this.fOffset = n;
        this.fLength = n2;
        this.fImage = image;
        this.fRelevance = n3;
        this.fReplacementString = string;
        this.fCursorPosition = string.length();
        this.fDisplayString = string2 != null ? string2 : string;
    }

    public void apply(IDocument iDocument) {
        this.apply(iDocument, '\u0000', this.fOffset + this.fLength);
    }

    public void apply(ITextViewer iTextViewer, char c, int n, int n2) {
        this.apply(iTextViewer.getDocument(), c, n2);
    }

    public void apply(IDocument iDocument, char c, int n) {
        String string;
        int n2 = n - (this.fOffset + this.fLength);
        if (n2 > 0) {
            this.fLength += n2;
        }
        if (c == '\u0000') {
            string = this.fReplacementString;
        } else if (c == '(' && this.fTriggerCharacters == JSCompletionCollector.METHOD_TRIGGERS) {
            string = this.fReplacementString;
            --this.fCursorPosition;
        } else {
            StringBuffer stringBuffer = new StringBuffer(this.fReplacementString);
            if (this.fCursorPosition > 0 && this.fCursorPosition <= stringBuffer.length() && stringBuffer.charAt(this.fCursorPosition - 1) != c) {
                stringBuffer.insert(this.fCursorPosition, c);
                ++this.fCursorPosition;
            }
            string = stringBuffer.toString();
        }
        try {
            if (!iDocument.get(this.fOffset, this.fLength).equals(string)) {
                iDocument.replace(this.fOffset, this.fLength, string);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public String getAdditionalProposalInfo() {
        if (this.slot != null) {
            return JSTextHover.getHoverInfo(this.name, this.slot);
        }
        return null;
    }

    public void setAdditionalProposalInfo(String string, ISlot iSlot) {
        this.name = string;
        this.slot = iSlot;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        return this.fDisplayString;
    }

    public Image getImage() {
        return this.fImage;
    }

    public Point getSelection(IDocument iDocument) {
        return new Point(this.fOffset + this.fCursorPosition, 0);
    }

    public int getContextInformationPosition() {
        return this.fOffset;
    }

    public int getRelevance() {
        return this.fRelevance;
    }

    public void setRelevance(int n) {
        this.fRelevance = n;
    }

    public void setImage(Image image) {
        this.fImage = image;
    }

    public char[] getTriggerCharacters() {
        return this.fTriggerCharacters;
    }

    public void setTriggerCharacters(char[] cArray) {
        this.fTriggerCharacters = cArray;
    }

    public int getCursorPosition() {
        return this.fCursorPosition;
    }

    public void setCursorPosition(int n) {
        Assert.isTrue((n >= 0 ? 1 : 0) != 0);
        this.fCursorPosition = n;
    }

    public boolean isValidFor(IDocument iDocument, int n) {
        return this.validate(iDocument, n, null);
    }

    public boolean validate(IDocument iDocument, int n, DocumentEvent documentEvent) {
        if (n < this.fOffset) {
            return false;
        }
        boolean bl = this.startsWith(iDocument, n, this.fDisplayString);
        if (bl && documentEvent != null) {
            int n2 = (documentEvent.fText == null ? 0 : documentEvent.fText.length()) - documentEvent.fLength;
            this.fLength += n2;
        }
        return bl;
    }

    public void selected(ITextViewer iTextViewer, boolean bl) {
    }

    public void unselected(ITextViewer iTextViewer) {
    }

    protected boolean startsWith(IDocument iDocument, int n, String string) {
        int n2;
        int n3 = n2 = string == null ? 0 : string.length();
        if (n > this.fOffset + n2) {
            return false;
        }
        try {
            int n4 = n - this.fOffset;
            String string2 = iDocument.get(this.fOffset, n4);
            return string.substring(0, n4).equalsIgnoreCase(string2);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }
}

