/*
 * Decompiled with CFR 0.152.
 */
package com.spket.js.internal.text;

import com.spket.js.internal.JSPlugin;
import com.spket.js.internal.text.Partitioner;
import com.spket.ui.text.AutoEditStrategy;
import com.spket.util.Debug;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;

public class JSAutoIndentStrategy
extends AutoEditStrategy {
    private static final char NULL = '\u0000';
    private Partitioner fPartitioner;

    public JSAutoIndentStrategy(Partitioner partitioner) {
        super(partitioner.getPartitioning());
        this.fPartitioner = partitioner;
    }

    public void customizeDocumentCommand(IDocument iDocument, DocumentCommand documentCommand) {
        if (!documentCommand.doit || documentCommand.text == null) {
            return;
        }
        if (!this.isSmartMode()) {
            super.customizeDocumentCommand(iDocument, documentCommand);
            return;
        }
        this.fPartitioner.setDocument(iDocument);
        if (documentCommand.length == 0 && this.isLineDelimiter(iDocument, documentCommand.text)) {
            this.smartIndentAfterNewLine(iDocument, documentCommand);
        } else if (documentCommand.text.length() == 1) {
            this.smartIndentOnKeypress(iDocument, documentCommand);
        }
    }

    private String getIndentOfLine(IDocument iDocument, int n) throws BadLocationException {
        if (n > -1) {
            int n2 = iDocument.getLineOffset(n);
            int n3 = n2 + iDocument.getLineLength(n) - 1;
            int n4 = this.findEndOfWhiteSpace(iDocument, n2, n3);
            return iDocument.get(n2, n4 - n2);
        }
        return "";
    }

    private int findChar(IDocument iDocument, int n, int n2, char c) throws BadLocationException {
        this.fPartitioner.setForward(false);
        this.fPartitioner.reset(n);
        do {
            this.fPartitioner.next();
            int n3 = this.fPartitioner.getLength();
            if (n3 < 0) break;
            n = this.fPartitioner.getOffset();
            if (n < n2) {
                n = n2;
            }
            for (int i = Math.min(n + n3, iDocument.getLength() - 1); i >= n; --i) {
                char c2 = iDocument.getChar(i);
                if (c != '\u0000' && c != c2 || Character.isWhitespace(c2)) continue;
                return i;
            }
        } while (n != n2);
        return -1;
    }

    private int findNonWhitespaceBackward(IDocument iDocument, int n, int n2) throws BadLocationException {
        return this.findChar(iDocument, n, n2, '\u0000');
    }

    private int getBracketCount(IDocument iDocument, int n, int n2, boolean bl) throws BadLocationException {
        int n3;
        int n4 = 0;
        this.fPartitioner.setForward(true);
        this.fPartitioner.reset(n);
        do {
            this.fPartitioner.next();
            int n5 = this.fPartitioner.getLength();
            if (n5 < 0) break;
            int n6 = this.fPartitioner.getOffset();
            n3 = Math.min(n6 + n5, n2);
            block5: for (int i = n6; i < n3; ++i) {
                char c = iDocument.getChar(i);
                switch (c) {
                    case '{': {
                        ++n4;
                        bl = false;
                        continue block5;
                    }
                    case '}': {
                        if (bl) continue block5;
                        --n4;
                    }
                }
            }
        } while (n3 != n2);
        return n4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int findOpeningPeer(IDocument iDocument, int n) {
        this.fPartitioner.setForward(false);
        this.fPartitioner.reset(n);
        int n2 = 1;
        try {
            do {
                this.fPartitioner.next();
                int n3 = this.fPartitioner.getLength();
                if (n3 < 0) return -1;
                n = this.fPartitioner.getOffset();
                if (n < 0) {
                    n = 0;
                }
                for (int i = Math.min(n + n3, iDocument.getLength() - 1); i >= n; --i) {
                    char c = iDocument.getChar(i);
                    switch (c) {
                        case '{': {
                            --n2;
                            break;
                        }
                        case '}': {
                            ++n2;
                        }
                    }
                    if (n2 != 0) continue;
                    return i;
                }
            } while (n != 0);
            return -1;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int findClosingPeer(IDocument iDocument, int n) {
        this.fPartitioner.setForward(true);
        this.fPartitioner.reset(n);
        int n2 = 1;
        int n3 = iDocument.getLength();
        try {
            int n4;
            do {
                this.fPartitioner.next();
                int n5 = this.fPartitioner.getLength();
                if (n5 < 0) return -1;
                n = this.fPartitioner.getOffset();
                n4 = Math.min(n + n5, n3);
                for (int i = n; i < n4; ++i) {
                    char c = iDocument.getChar(i);
                    switch (c) {
                        case '{': {
                            ++n2;
                            break;
                        }
                        case '}': {
                            --n2;
                        }
                    }
                    if (n2 != 0) continue;
                    return i;
                }
            } while (n4 != n3);
            return -1;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    private boolean isClosed(IDocument iDocument, int n, int n2) throws BadLocationException {
        if (n < 1) {
            return true;
        }
        if (n >= iDocument.getLength()) {
            return false;
        }
        int n3 = n;
        int n4 = n - 1;
        do {
            if ((n3 = this.findOpeningPeer(iDocument, n3 - 1)) != -1) continue;
            return true;
        } while ((n4 = this.findClosingPeer(iDocument, n4 + 1)) != -1);
        return false;
    }

    private String getReferenceIndentation(IDocument iDocument, int n, boolean bl) throws BadLocationException {
        int n2 = this.findChar(iDocument, n, 0, '\u0000');
        if (n2 == -1) {
            return this.getLineIndentation(iDocument, n);
        }
        String string = this.getLineIndentation(iDocument, n2);
        if (bl && iDocument.getChar(n2) == '{') {
            return string + '\t';
        }
        return string;
    }

    private void smartIndentAfterNewLine(IDocument iDocument, DocumentCommand documentCommand) {
        int n = iDocument.getLength();
        if (documentCommand.offset == -1 || n == 0) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(documentCommand.text);
        int n2 = documentCommand.offset == n ? documentCommand.offset - 1 : documentCommand.offset;
        try {
            int n3;
            int n4 = iDocument.getLineOfOffset(n2);
            IRegion iRegion = iDocument.getLineInformation(n4);
            int n5 = iRegion.getOffset() + iRegion.getLength();
            int n6 = this.findEndOfWhiteSpace(iDocument, documentCommand.offset, n5);
            documentCommand.length = Math.max(n6 - documentCommand.offset, 0);
            int n7 = iRegion.getOffset();
            stringBuffer.append(this.getReferenceIndentation(iDocument, documentCommand.offset, true));
            int n8 = 0;
            if (this.closeBrace() && this.getBracketCount(iDocument, n7, documentCommand.offset, true) > 0 && !this.isClosed(iDocument, documentCommand.offset, documentCommand.length)) {
                documentCommand.caretOffset = documentCommand.offset + stringBuffer.length();
                documentCommand.shiftsCaret = false;
                if (n5 - n6 > 0) {
                    documentCommand.length = n5 - documentCommand.offset;
                    stringBuffer.append(iDocument.get(n6, n5 - n6));
                }
                n8 = 2;
            } else if (documentCommand.offset > n7 && n6 < n5 && iDocument.getChar(n6) == '}' && (n3 = this.findNonWhitespaceBackward(iDocument, documentCommand.offset - 1, n7)) != -1 && iDocument.getChar(n3) == '{') {
                documentCommand.shiftsCaret = false;
                documentCommand.caretOffset = documentCommand.offset + stringBuffer.length();
                n8 = 1;
            }
            if (n8 > 0) {
                stringBuffer.append(TextUtilities.getDefaultLineDelimiter((IDocument)iDocument));
                n3 = this.findEndOfWhiteSpace(iDocument, n7, n5);
                if (n3 < documentCommand.offset && iDocument.getChar(n3) == '{') {
                    stringBuffer.append(iDocument.get(n7, n3 - n7));
                } else {
                    stringBuffer.append(this.getReferenceIndentation(iDocument, documentCommand.offset, false));
                }
                if (n8 > 1) {
                    stringBuffer.append('}');
                }
            }
            documentCommand.text = stringBuffer.toString();
        }
        catch (BadLocationException badLocationException) {
            Debug.debug((Throwable)badLocationException);
        }
    }

    private boolean closeBrace() {
        return JSPlugin.getDefault().getPreferenceStore().getBoolean("closeBraces");
    }

    private void smartIndentOnKeypress(IDocument iDocument, DocumentCommand documentCommand) {
        switch (documentCommand.text.charAt(0)) {
            case '}': {
                this.smartIndentAfterClosingBracket(iDocument, documentCommand);
                break;
            }
            case '{': {
                this.smartIndentAfterOpeningBracket(iDocument, documentCommand);
            }
        }
    }

    private void smartIndentAfterClosingBracket(IDocument iDocument, DocumentCommand documentCommand) {
        if (documentCommand.offset == -1 || iDocument.getLength() == 0) {
            return;
        }
        int n = documentCommand.offset == iDocument.getLength() ? documentCommand.offset - 1 : documentCommand.offset;
        try {
            int n2;
            int n3;
            int n4 = iDocument.getLineOfOffset(n);
            int n5 = iDocument.getLineOffset(n4);
            int n6 = this.findEndOfWhiteSpace(iDocument, n5, documentCommand.offset);
            if (n6 == documentCommand.offset && (n3 = this.findChar(iDocument, n6, 0, '{')) != -1 && (n2 = iDocument.getLineOfOffset(n3)) != -1 && n2 != n4) {
                StringBuffer stringBuffer = new StringBuffer(this.getIndentOfLine(iDocument, n2));
                stringBuffer.append(iDocument.get(n6, documentCommand.offset - n6));
                stringBuffer.append(documentCommand.text);
                documentCommand.length += documentCommand.offset - n5;
                documentCommand.offset = n5;
                documentCommand.text = stringBuffer.toString();
            }
        }
        catch (BadLocationException badLocationException) {
            Debug.debug((Throwable)badLocationException);
        }
    }

    private void smartIndentAfterOpeningBracket(IDocument iDocument, DocumentCommand documentCommand) {
        if (documentCommand.offset < 1 || iDocument.getLength() == 0) {
            return;
        }
        int n = documentCommand.offset == iDocument.getLength() ? documentCommand.offset - 1 : documentCommand.offset;
        try {
            int n2 = iDocument.getLineOfOffset(n);
            int n3 = iDocument.getLineOffset(n2);
            if (iDocument.get(n3, n - n3).trim().length() != 0) {
                return;
            }
            int n4 = this.findNonWhitespaceBackward(iDocument, n3, 0);
            if (n4 == -1) {
                return;
            }
            int n5 = iDocument.getLineOfOffset(n4);
            if (n5 < n2) {
                StringBuffer stringBuffer = new StringBuffer(this.getReferenceIndentation(iDocument, n4, true));
                String string = iDocument.get(n3, documentCommand.offset - n3);
                if (stringBuffer != null && !stringBuffer.toString().equals(string)) {
                    documentCommand.text = stringBuffer.append(documentCommand.text).toString();
                    documentCommand.length += documentCommand.offset - n3;
                    documentCommand.offset = n3;
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }
}

