/*
 * Decompiled with CFR 0.152.
 */
package com.spket.js.editors;

import com.spket.as.internal.compiler.ASTVisitor;
import com.spket.as.internal.compiler.ast.CompilationUnitDeclaration;
import com.spket.js.editors.JSContentProvider;
import com.spket.js.editors.JSItem;
import com.spket.js.editors.JSItemSorter;
import com.spket.js.editors.JSLabelProvider;
import com.spket.js.editors.OutlineVisitor;
import com.spket.js.editors.SourcePositionSorter;
import com.spket.js.internal.JSImages;
import com.spket.js.internal.JSMessages;
import com.spket.js.internal.JSPlugin;
import com.spket.js.model.IASTListener;
import com.spket.js.parser.LexerProvider;
import com.spket.ui.internal.UIImages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class JSOutlinePage
extends ContentOutlinePage {
    private boolean fChanged;
    private boolean showLocalVariable;
    private JSItem globalScope;
    private OutlineVisitor fVisitor;
    private LexerProvider fLexerProvider;
    private IASTListener fListener = new IASTListener(){

        public void astAboutToBeChanged() {
            JSOutlinePage.this.onASTAboutToBeChanged();
        }

        public void astChanged(CompilationUnitDeclaration compilationUnitDeclaration) {
            JSOutlinePage.this.onASTChanged(compilationUnitDeclaration);
        }
    };

    public JSOutlinePage(LexerProvider lexerProvider) {
        this.fLexerProvider = lexerProvider;
        this.globalScope = new JSItem("Global");
    }

    public void createControl(Composite composite) {
        super.createControl(composite);
        this.showLocalVariable = JSPlugin.getDefault().getPreferenceStore().getBoolean("js.outline.local");
        TreeViewer treeViewer = this.getTreeViewer();
        treeViewer.setLabelProvider((IBaseLabelProvider)new JSLabelProvider());
        treeViewer.setContentProvider((IContentProvider)new JSContentProvider());
        IToolBarManager iToolBarManager = this.getSite().getActionBars().getToolBarManager();
        if (iToolBarManager != null) {
            iToolBarManager.add((IAction)new SortingAction());
            iToolBarManager.add((IContributionItem)new Separator());
            iToolBarManager.add((IAction)new ShowLocalAction());
        }
        this.update();
        treeViewer.setInput((Object)this.globalScope);
        this.fLexerProvider.addASTListener(this.fListener);
    }

    public void dispose() {
        if (this.fLexerProvider != null) {
            if (this.fListener != null) {
                this.fLexerProvider.removeASTListener(this.fListener);
            }
            this.fLexerProvider = null;
        }
        this.fListener = null;
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onASTAboutToBeChanged() {
        JSOutlinePage jSOutlinePage = this;
        synchronized (jSOutlinePage) {
            this.fChanged = true;
            if (this.fVisitor != null) {
                this.fVisitor.cancel();
            }
        }
    }

    protected void onASTChanged(CompilationUnitDeclaration compilationUnitDeclaration) {
        this.update(compilationUnitDeclaration);
    }

    protected void update() {
        if (this.fLexerProvider == null) {
            return;
        }
        this.update(this.fLexerProvider.getCompilationUnitDeclaration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update(CompilationUnitDeclaration compilationUnitDeclaration) {
        TreeViewer treeViewer = this.getTreeViewer();
        if (treeViewer == null) {
            return;
        }
        Control control = treeViewer.getControl();
        if (control == null || control.isDisposed()) {
            return;
        }
        JSOutlinePage jSOutlinePage = this;
        synchronized (jSOutlinePage) {
            this.fChanged = false;
            if (this.fVisitor == null) {
                this.fVisitor = new OutlineVisitor(this.globalScope);
            } else {
                this.fVisitor.reset(this.globalScope);
            }
        }
        this.globalScope.clear();
        if (compilationUnitDeclaration != null) {
            this.fVisitor.showLocalVariable = this.showLocalVariable;
            compilationUnitDeclaration.traverse((ASTVisitor)this.fVisitor, null);
            this.fVisitor.reset(null);
        }
        if (this.fChanged) {
            return;
        }
        jSOutlinePage = control.getDisplay();
        if (jSOutlinePage.getThread() == Thread.currentThread()) {
            treeViewer.refresh();
        } else {
            jSOutlinePage.asyncExec(new Runnable(){

                public void run() {
                    if (JSOutlinePage.this.fChanged) {
                        return;
                    }
                    TreeViewer treeViewer = JSOutlinePage.this.getTreeViewer();
                    if (treeViewer != null) {
                        treeViewer.refresh();
                    }
                }
            });
        }
    }

    private class ShowLocalAction
    extends Action {
        public ShowLocalAction() {
            this.setText(JSMessages.JSOutline_Local_label);
            this.setToolTipText(JSMessages.JSOutline_Local_tooltip);
            this.setDescription(JSMessages.JSOutline_Local_description);
            this.setImageDescriptor(JSImages.DESC_FIELD_PRIVATE);
            this.setChecked(JSOutlinePage.this.showLocalVariable);
        }

        public void run() {
            JSOutlinePage.this.showLocalVariable = this.isChecked();
            JSPlugin.getDefault().getPreferenceStore().setValue("js.outline.local", JSOutlinePage.this.showLocalVariable);
            if (JSOutlinePage.this.globalScope != null && JSOutlinePage.this.globalScope.hasChildren()) {
                JSOutlinePage.this.update();
            }
        }
    }

    private class SortingAction
    extends Action {
        private JSItemSorter fSorter;
        private SourcePositionSorter fPositionSorter;

        public SortingAction() {
            this.setText(JSMessages.JSOutline_Sort_label);
            this.setToolTipText(JSMessages.JSOutline_Sort_tooltip);
            this.setDescription(JSMessages.JSOutline_Sort_description);
            this.setImageDescriptor(UIImages.getImageDescriptor((String)"com.spket.ui", (int)2, (String)"alphab_sort_co.png"));
            boolean bl = JSPlugin.getDefault().getPreferenceStore().getBoolean("js.outline.checked");
            this.valueChanged(bl, false);
        }

        public void run() {
            this.valueChanged(this.isChecked(), true);
        }

        private void valueChanged(boolean bl, boolean bl2) {
            if (bl2) {
                JSPlugin.getDefault().getPreferenceStore().setValue("js.outline.checked", bl);
            }
            this.setChecked(bl);
            if (bl) {
                if (this.fSorter == null) {
                    this.fSorter = new JSItemSorter();
                }
                JSOutlinePage.this.getTreeViewer().setSorter((ViewerSorter)this.fSorter);
            } else {
                if (this.fPositionSorter == null) {
                    this.fPositionSorter = new SourcePositionSorter();
                }
                JSOutlinePage.this.getTreeViewer().setSorter((ViewerSorter)this.fPositionSorter);
            }
        }
    }
}

