/*
 * Decompiled with CFR 0.152.
 */
package com.spket.js.editors;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.graphics.Point;

public class JSItem {
    static final int F_FUNCTION = 1;
    static final int F_OBJECT = 2;
    static final String SCOPE = "{...}";
    static final JSItem[] NO_ITEM = new JSItem[0];
    int type;
    String name;
    private Map properties;
    private JSItem wrap;
    public Point range;

    public JSItem() {
    }

    public JSItem(JSItem jSItem) {
        this.wrap = jSItem;
    }

    public JSItem(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    void setName(String string) {
        this.name = string;
    }

    public int compareTo(Object object) {
        JSItem jSItem = (JSItem)object;
        if (this.type == jSItem.type) {
            return this.name.compareTo(jSItem.name);
        }
        return this.type - jSItem.type;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof JSItem) {
            return this.compareTo(object) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.type << 24 | this.name.hashCode();
    }

    public boolean hasChildren() {
        return this.properties != null && this.properties.size() > 0;
    }

    public void clear() {
        if (this.properties != null && this.properties.size() > 0) {
            this.properties.clear();
        }
    }

    public void merge(JSItem jSItem, boolean bl) {
        Map map = jSItem.properties;
        if (map != null && map.size() > 0) {
            if (this.properties == null || this.properties.size() == 0) {
                this.properties = new HashMap(map);
            } else if (bl) {
                this.properties.putAll(map);
            } else {
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    Object k = entry.getKey();
                    if (this.properties.containsKey(k)) continue;
                    this.properties.put(k, entry.getValue());
                }
            }
        }
    }

    public JSItem[] getChildren() {
        if (this.properties != null && this.properties.size() > 0) {
            JSItem[] jSItemArray = new JSItem[this.properties.size()];
            this.properties.values().toArray(jSItemArray);
            return jSItemArray;
        }
        return NO_ITEM;
    }

    public void addChild(JSItem jSItem) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(jSItem.name, jSItem);
    }

    public void remove(JSItem jSItem) {
        if (this.properties != null) {
            this.properties.remove(jSItem.name);
        }
    }

    public JSItem getChild(String string) {
        JSItem jSItem = null;
        if (this.properties != null) {
            jSItem = (JSItem)this.properties.get(string);
        }
        if (jSItem == null && this.wrap != null) {
            return this.wrap.getChild(string);
        }
        return jSItem;
    }
}

