/*
 * Decompiled with CFR 0.152.
 */
package com.spket.laszlo.model;

import com.spket.buffer.BufferChangedEvent;
import com.spket.js.model.ILexerContext;
import com.spket.js.model.ILexerProvider;
import com.spket.laszlo.grammars.LZXGrammarManager;
import com.spket.laszlo.internal.LaszloPlugin;
import com.spket.laszlo.internal.LzImages;
import com.spket.laszlo.model.LZXLexerProvider;
import com.spket.laszlo.model.LzHelper;
import com.spket.xml.PositionInfo;
import com.spket.xml.XMLElement;
import com.spket.xml.XMLModel;
import com.spket.xml.XMLNode;
import com.spket.xml.grammars.GrammarManager;
import org.apache.xerces.util.SymbolTable;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.swt.graphics.Image;

public class LZXModel
extends XMLModel
implements ILexerContext {
    public static SymbolTable gSymbolTable = new SymbolTable();
    private LZXLexerProvider fProvider;

    public SymbolTable getSymbolTable() {
        return gSymbolTable;
    }

    public ILexerProvider getLexerProvider(int n) {
        if (this.fProvider != null && n >= this.fProvider.getStart() && n <= this.fProvider.getEnd()) {
            return this.fProvider;
        }
        this.fProvider = new LZXLexerProvider(this, n);
        return this.fProvider;
    }

    public Image getImage(Object object) {
        if (object instanceof XMLNode) {
            XMLNode xMLNode = (XMLNode)object;
            switch (xMLNode.getNodeType()) {
                case 1: {
                    String string = ((XMLElement)object).getLocalName();
                    if (string != null) {
                        return LzImages.get(string);
                    }
                }
                case 0: {
                    return LzImages.get("lzx");
                }
            }
        }
        return null;
    }

    public TemplateContextType getContextType(PositionInfo positionInfo) {
        return LaszloPlugin.getDefault().getTemplateContextRegistry().getContextType("lzx");
    }

    public Template[] getTemplates(String string) {
        return LaszloPlugin.getDefault().getTemplateStore().getTemplates();
    }

    protected void onBufferAboutToBeChanged(BufferChangedEvent bufferChangedEvent) {
        this.fProvider = null;
        if (this.fGrammar instanceof LZXGrammarManager) {
            ((LZXGrammarManager)this.fGrammar).clear();
        }
        super.onBufferAboutToBeChanged(bufferChangedEvent);
    }

    protected GrammarManager createGrammarManager() {
        return new LZXGrammarManager(this);
    }

    static {
        LzHelper.initSymbolTable(gSymbolTable);
    }
}

