/*
 * Decompiled with CFR 0.152.
 */
package com.spket.widget;

import com.spket.util.Debug;
import com.spket.util.IRenderer;
import com.spket.widget.BasicTheme;
import com.spket.widget.IDisposable;
import com.spket.widget.IPainter;
import com.spket.widget.IPopup;
import com.spket.widget.ITheme;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Widget;

public final class UIUtils {
    public static final int DRAG_THRESHOLD = 5;
    public static final String STRING_EXTENT = "gM";
    public static final String FONT_SYMBOL = "font.symbol";
    public static final String ICON_PLUS = "plus.gif";
    public static final String ICON_MINUS = "minus.gif";
    public static final String ICON_TODAY = "today.gif";
    public static final String ICON_ARROW = "arrow.gif";
    public static final String COLOR_BORDER = "color.border";
    public static final String COLOR_MOUSE_OVER = "color.over";
    public static final String COLOR_SELECTION = "color.selection";
    public static final String COLOR_SELECTION_HOVER = "color.selection.hover";
    private static final String ELLIPSIS = "...";
    private static ITheme theme = new BasicTheme();
    private static IRenderer renderer;
    private static UIUtils instance;
    private static BorderPaintListener borderPainter;
    private Map fonts = new HashMap();
    private Map colors = new HashMap();
    private Map images = new HashMap();
    private List disposeExecs = null;

    public static final UIUtils getInstance() {
        if (instance == null) {
            instance = new UIUtils();
        }
        return instance;
    }

    public static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static final boolean activeTheming(Display display) {
        return theme.activeTheming(display);
    }

    public static IPainter getPainter() {
        return theme.getPainter();
    }

    public static void dispose(Map map) {
        if (map != null && map.size() > 0) {
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                ((Resource)iterator.next()).dispose();
            }
            map.clear();
        }
    }

    public static void disposeAfterShutdown(Runnable runnable) {
        UIUtils.getInstance().disposeExec(runnable);
    }

    public static void disposeAfterShutdown(IDisposable iDisposable) {
        UIUtils.getInstance().disposeExec(iDisposable);
    }

    public static void copy(org.eclipse.swt.graphics.Rectangle rectangle, org.eclipse.swt.graphics.Rectangle rectangle2) {
        if (rectangle == null || rectangle2 == null || rectangle == rectangle2) {
            return;
        }
        rectangle2.x = rectangle.x;
        rectangle2.y = rectangle.y;
        rectangle2.width = rectangle.width;
        rectangle2.height = rectangle.height;
    }

    public static void expand(org.eclipse.swt.graphics.Rectangle rectangle, int n, int n2) {
        UIUtils.shrink(rectangle, -n, -n2);
    }

    public static void shrink(org.eclipse.swt.graphics.Rectangle rectangle, int n, int n2) {
        if (rectangle != null) {
            rectangle.x += n;
            rectangle.width -= n + n;
            rectangle.y += n2;
            rectangle.height -= n2 + n2;
        }
    }

    public static void expand(Rectangle rectangle, int n, int n2) {
        UIUtils.shrink(rectangle, -n, -n2);
    }

    public static void shrink(Rectangle rectangle, int n, int n2) {
        if (rectangle != null) {
            rectangle.x += n;
            rectangle.width -= n + n;
            rectangle.y += n2;
            rectangle.height -= n2 + n2;
        }
    }

    public static org.eclipse.swt.graphics.Rectangle union(org.eclipse.swt.graphics.Rectangle rectangle, org.eclipse.swt.graphics.Rectangle rectangle2) {
        int n = rectangle2.x < rectangle.x ? rectangle2.x : rectangle.x;
        int n2 = rectangle2.y < rectangle.y ? rectangle2.y : rectangle.y;
        int n3 = rectangle2.x + rectangle2.width;
        int n4 = rectangle.x + rectangle.width;
        int n5 = n3 > n4 ? n3 : n4;
        n3 = rectangle2.y + rectangle2.height;
        n4 = rectangle.y + rectangle.height;
        int n6 = n3 > n4 ? n3 : n4;
        rectangle2.x = n;
        rectangle2.y = n2;
        rectangle2.width = n5 - n;
        rectangle2.height = n6 - n2;
        return rectangle2;
    }

    public static Point getLocation(Control control, org.eclipse.swt.graphics.Rectangle rectangle, int n) {
        Display display = control.getDisplay();
        org.eclipse.swt.graphics.Rectangle rectangle2 = display.getBounds();
        org.eclipse.swt.graphics.Rectangle rectangle3 = control.getBounds();
        Point point = new Point(rectangle3.x, rectangle3.y);
        boolean bl = false;
        if (rectangle.y + rectangle.height + rectangle3.height > rectangle2.y + rectangle2.height) {
            if (rectangle3.height + rectangle2.y > rectangle.y) {
                bl = true;
                point.y = rectangle2.y + rectangle2.height - rectangle3.height;
                if (point.y < rectangle2.y) {
                    point.y = rectangle2.y;
                }
            } else {
                point.y = rectangle.y - rectangle3.height;
            }
        } else {
            point.y = rectangle.y + rectangle.height;
        }
        int n2 = rectangle.x - rectangle2.x;
        int n3 = rectangle2.x + rectangle2.width - rectangle.x - rectangle.width;
        if (n == 16384) {
            if (bl) {
                point.x = n3 > rectangle3.width ? rectangle.x + rectangle.width : rectangle.x - n2;
            } else if (rectangle.x + rectangle3.width > rectangle2.x + rectangle2.width) {
                point.x = rectangle2.x + rectangle2.width - rectangle3.width;
                if (point.x < rectangle2.x) {
                    point.x = rectangle2.x;
                }
            } else {
                point.x = rectangle.x;
            }
        } else {
            point.x = bl ? (n2 > rectangle3.width || n3 < rectangle3.width && n2 > n3 ? rectangle.x - rectangle3.width : rectangle.x + rectangle.width) : (rectangle.x + rectangle.width - rectangle3.width < rectangle2.x ? rectangle2.x : rectangle.x + rectangle.width - rectangle3.width);
        }
        return point;
    }

    public static void popup(IPopup iPopup, int n) {
        theme.popup(iPopup, n);
    }

    public static void show(Control control, org.eclipse.swt.graphics.Rectangle rectangle, int n) {
        Point point = UIUtils.getLocation(control, rectangle, n);
        control.setLocation(point);
        control.setVisible(true);
    }

    public static void drawBorder(GC gC, org.eclipse.swt.graphics.Rectangle rectangle, Color color, Color color2) {
        UIUtils.drawBorder(gC, rectangle.x, rectangle.y, rectangle.width, rectangle.height, color, color2);
    }

    public static void drawBorder(GC gC, int n, int n2, int n3, int n4, Color color, Color color2) {
        if (n3 > 0 && n4 > 0) {
            int n5 = n + n3;
            int n6 = n2 + n4;
            Color color3 = gC.getForeground();
            gC.setForeground(color);
            gC.drawLine(n, n2, n5, n2);
            gC.drawLine(n, n2, n, n6);
            gC.setForeground(color2);
            gC.drawLine(n5, n2, n5, n6);
            gC.drawLine(n, n6, n5, n6);
            gC.setForeground(color3);
        }
    }

    public static Image getGrayImage(Image image) {
        return image == null ? null : new Image(null, image, 2);
    }

    public static Image getDisableImage(Image image) {
        return image == null ? null : new Image(null, image, 1);
    }

    public static Font getFont(Display display, Font font, int n, int n2) {
        FontData[] fontDataArray = font.getFontData();
        for (int i = 0; i < fontDataArray.length; ++i) {
            if (fontDataArray[i] == null) continue;
            if (n != -1) {
                fontDataArray[i].setStyle(n);
            }
            if (n2 == -1) continue;
            fontDataArray[i].setHeight(n2);
        }
        return new Font((Device)display, fontDataArray);
    }

    public static void paintBordersFor(Composite composite) {
        if (borderPainter == null) {
            borderPainter = new BorderPaintListener();
        }
        composite.addListener(9, (Listener)borderPainter);
    }

    public static boolean okToUse(Widget widget) {
        return widget != null && !widget.isDisposed();
    }

    public static boolean isLeftMouseButton(Event event) {
        return event.button == 1;
    }

    public static boolean isLeftMouseButton(MouseEvent mouseEvent) {
        return mouseEvent.button == 1;
    }

    public static boolean isRightMouseButton(Event event) {
        return event.button == 3;
    }

    public static boolean isRightMouseButton(MouseEvent mouseEvent) {
        return mouseEvent.button == 3;
    }

    public static boolean isMouseButtonDown(Event event) {
        return (event.stateMask & SWT.BUTTON_MASK) != 0;
    }

    public static boolean isControlDown(int n) {
        return (n & 0x40000) != 0;
    }

    public static boolean isShiftDown(int n) {
        return (n & 0x20000) != 0;
    }

    public static boolean isAltDown(int n) {
        return (n & 0x10000) != 0;
    }

    public static boolean isModKeyDown(int n, int n2) {
        return (n & n2) != 0;
    }

    public static Color getColor(String string) {
        return (Color)UIUtils.getInstance().colors.get(string);
    }

    public static Font getFont(String string) {
        return (Font)UIUtils.getInstance().fonts.get(string);
    }

    public static Image getImage(String string) {
        return (Image)UIUtils.getInstance().images.get(string);
    }

    private UIUtils() {
        try {
            this.initResource();
        }
        catch (Throwable throwable) {
            Debug.debug((Throwable)throwable);
        }
    }

    private void dispose() {
        this.disposeResource();
        if (this.disposeExecs == null) {
            return;
        }
        for (int i = 0; i < this.disposeExecs.size(); ++i) {
            Object e = this.disposeExecs.get(i);
            try {
                if (e instanceof Runnable) {
                    ((Runnable)e).run();
                    continue;
                }
                if (!(e instanceof IDisposable)) continue;
                ((IDisposable)e).dispose();
                continue;
            }
            catch (RuntimeException runtimeException) {
                Debug.debug((Throwable)runtimeException);
            }
        }
    }

    private void initResource() {
        Display display = UIUtils.getDisplay();
        display.disposeExec(new Runnable(){

            public void run() {
                UIUtils.this.dispose();
            }
        });
        this.colors.put(COLOR_BORDER, new Color((Device)display, 49, 106, 197));
        this.colors.put(COLOR_SELECTION, new Color((Device)display, 225, 230, 232));
        this.colors.put(COLOR_MOUSE_OVER, new Color((Device)display, 193, 210, 238));
        this.colors.put(COLOR_SELECTION_HOVER, new Color((Device)display, 152, 181, 226));
        Font font = display.getSystemFont();
        this.fonts.put(FONT_SYMBOL, UIUtils.getFont(display, font, -1, 24));
        this.images.put(ICON_PLUS, new Image((Device)display, this.getClass().getResourceAsStream(ICON_PLUS)));
        this.images.put(ICON_MINUS, new Image((Device)display, this.getClass().getResourceAsStream(ICON_MINUS)));
        this.images.put(ICON_TODAY, new Image((Device)display, this.getClass().getResourceAsStream(ICON_TODAY)));
        this.images.put(ICON_ARROW, new Image((Device)display, this.getClass().getResourceAsStream(ICON_ARROW)));
    }

    private void disposeExec(Runnable runnable) {
        if (this.disposeExecs == null) {
            this.disposeExecs = new ArrayList();
        }
        this.disposeExecs.add(runnable);
    }

    private void disposeExec(IDisposable iDisposable) {
        if (this.disposeExecs == null) {
            this.disposeExecs = new ArrayList();
        }
        this.disposeExecs.add(iDisposable);
    }

    private void disposeResource() {
        UIUtils.dispose(this.colors);
        UIUtils.dispose(this.fonts);
        UIUtils.dispose(this.images);
    }

    public static String shortenText(GC gC, String string, int n) {
        if (n < 5) {
            return "";
        }
        if (gC.stringExtent((String)string).x <= n) {
            return string;
        }
        int n2 = gC.stringExtent((String)ELLIPSIS).x;
        int n3 = string.length();
        for (int i = n3 - 1; i > 0; --i) {
            string = string.substring(0, i);
            int n4 = gC.stringExtent((String)string).x;
            if (n4 + n2 > n) continue;
            return string + ELLIPSIS;
        }
        return string + ELLIPSIS;
    }

    static int getLightColor(int n, double d) {
        return (int)((double)(255 - n) * d + (double)n);
    }

    static int getDarkColor(int n, double d) {
        return (int)((double)n * d);
    }

    public static RGB getLighterColor(Color color, double d) {
        return UIUtils.getLighterColor(color.getRGB(), d);
    }

    public static RGB getLighterColor(RGB rGB, double d) {
        int n = UIUtils.getLightColor(rGB.red, d);
        int n2 = UIUtils.getLightColor(rGB.green, d) + 1;
        int n3 = UIUtils.getLightColor(rGB.blue, d);
        if (n >= 255) {
            n = 255;
        }
        if (n2 >= 255) {
            n2 = 255;
        }
        if (n3 >= 255) {
            n3 = 255;
        }
        return new RGB(n, n2, n3);
    }

    public static RGB getDarkerColor(Color color, double d) {
        return UIUtils.getDarkerColor(color.getRGB(), d);
    }

    public static RGB getDarkerColor(RGB rGB, double d) {
        int n = UIUtils.getDarkColor(rGB.red, d);
        int n2 = UIUtils.getDarkColor(rGB.green, d);
        int n3 = UIUtils.getDarkColor(rGB.blue, d);
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        return new RGB(n, n2, n3);
    }

    public static boolean drawImage(GC gC, BufferedImage bufferedImage, int n, int n2) {
        return renderer.drawImage(gC, bufferedImage, n, n2);
    }

    private static final class BorderPaintListener
    implements Listener {
        private Color border = UIUtils.getColor("color.border");

        private BorderPaintListener() {
        }

        public void handleEvent(Event event) {
            Composite composite = (Composite)event.widget;
            Control[] controlArray = composite.getChildren();
            for (int i = 0; i < controlArray.length; ++i) {
                Control control = controlArray[i];
                if (control instanceof ToolBar || control instanceof CoolBar || control instanceof Sash || !control.isVisible() || (control.getStyle() & 0x800000) == 0) continue;
                org.eclipse.swt.graphics.Rectangle rectangle = control.getBounds();
                if (rectangle.width <= 0 || rectangle.height <= 0) continue;
                GC gC = event.gc;
                gC.setForeground(this.border);
                gC.drawRectangle(rectangle.x - 1, rectangle.y - 1, rectangle.width + 1, rectangle.height + 1);
            }
        }
    }
}

