/*
 * Decompiled with CFR 0.152.
 */
package com.spket.widget;

import org.eclipse.swt.custom.ExtendedModifyEvent;
import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class MaskEdit
extends Composite {
    private int wStyle;
    private boolean isOverwriting = false;
    private Color bg;
    private Color fg;
    private StyledText styledText;
    private MaskModel model;

    private static int checkStyle(int n) {
        n = (n & 0x800800) != 0 ? 0x800000 : 0;
        return n | 0x40000 | 0x80000;
    }

    public MaskEdit(Composite composite, int n) {
        super(composite, MaskEdit.checkStyle(n));
        this.wStyle = n;
        this.styledText = new StyledText((Composite)this, 4);
        this.bg = this.styledText.getSelectionBackground();
        this.fg = this.styledText.getSelectionForeground();
        this.styledText.setLayoutData((Object)new GridData(1808));
        this.setLayout(new TextLayout(n));
        this.setCursor(this.getDisplay().getSystemCursor(19));
        this.installListeners();
    }

    public void addListener(int n, Listener listener) {
        if (24 == n) {
            this.styledText.addListener(n, listener);
            return;
        }
        super.addListener(n, listener);
    }

    public void removeListener(int n, Listener listener) {
        if (24 == n) {
            this.styledText.removeListener(n, listener);
            return;
        }
        super.removeListener(n, listener);
    }

    public String getText() {
        return this.styledText.getText();
    }

    public void setText(String string) {
        this.styledText.setText(string);
    }

    public void setModel(MaskModel maskModel) {
        if (maskModel == this.model) {
            return;
        }
        if (this.model != null) {
            this.model.uninstall();
        }
        this.model = maskModel;
        if (maskModel == null) {
            this.changedInsertMode(false);
            this.styledText.setDoubleClickEnabled(true);
        } else {
            maskModel.install(this.styledText);
            this.styledText.setDoubleClickEnabled(false);
            this.changedInsertMode(maskModel.usesOverwriteMode());
        }
        this.layout(false);
    }

    protected void installListeners() {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 9: {
                        MaskEdit.this.onPaint(event);
                        break;
                    }
                    case 3: {
                        MaskEdit.this.onMouseDown(event);
                        break;
                    }
                    case 15: {
                        MaskEdit.this.onTextFocusChanged(true);
                        break;
                    }
                    case 16: {
                        MaskEdit.this.onTextFocusChanged(false);
                        break;
                    }
                    case 8: {
                        MaskEdit.this.onTextMouseDoubleClick(event);
                        break;
                    }
                    case 12: {
                        MaskEdit.this.onDispose();
                    }
                }
            }
        };
        this.addListener(9, listener);
        this.addListener(12, listener);
        this.addListener(3, listener);
        this.styledText.addListener(9, listener);
        this.styledText.addListener(15, listener);
        this.styledText.addListener(16, listener);
        this.styledText.addListener(8, listener);
        if ((this.wStyle & 0x1020000) != 0) {
            this.styledText.addExtendedModifyListener(new ExtendedModifyListener(){

                public void modifyText(ExtendedModifyEvent extendedModifyEvent) {
                    MaskEdit.this.onModifyText(extendedModifyEvent);
                }
            });
        }
    }

    protected void onDispose() {
        this.bg = null;
        this.fg = null;
        this.model = null;
    }

    protected void onMouseDown(Event event) {
        Rectangle rectangle = this.styledText.getClientArea();
        int n = rectangle.x;
        Point point = this.styledText.toDisplay(rectangle.x, rectangle.y);
        point = this.toControl(point);
        n -= point.x;
        int n2 = this.styledText.getOffsetAtLine(0);
        if (event.x > point.x) {
            if (event.x >= point.x + rectangle.width) {
                n2 += this.styledText.getText().length();
            } else {
                int n3 = n2 + this.styledText.getText().length();
                Point point2 = this.styledText.getLocationAtOffset(n2);
                Point point3 = this.styledText.getLocationAtOffset(n3);
                point.x = event.x + n;
                if (point.x >= point2.x) {
                    if (point.x > point3.x) {
                        n2 = n3;
                    } else {
                        point.y = point2.y;
                        n2 = this.styledText.getOffsetAtLocation(point);
                    }
                }
            }
        }
        if (n2 != this.styledText.getCaretOffset()) {
            this.styledText.setCaretOffset(n2);
        }
        if (!this.styledText.isFocusControl()) {
            this.styledText.setFocus();
        }
    }

    protected void onPaint(Event event) {
        GC gC = event.gc;
        if (event.widget == this) {
            Rectangle rectangle = this.getClientArea();
            gC.setBackground(this.styledText.getBackground());
            gC.fillRectangle(rectangle);
            if ((this.wStyle & 0x800000) != 0) {
                --rectangle.width;
                --rectangle.height;
                gC.drawRectangle(rectangle);
            } else if ((this.wStyle & 0x800) != 0) {
                --rectangle.width;
                --rectangle.height;
                gC.drawRectangle(rectangle);
            }
        }
    }

    protected void changedInsertMode(boolean bl) {
        if (this.isOverwriting == bl) {
            return;
        }
        this.isOverwriting = bl;
        this.styledText.invokeAction(0x1000009);
    }

    protected void onTextFocusChanged(boolean bl) {
        if (bl) {
            this.styledText.setSelectionBackground(this.bg);
            this.styledText.setSelectionForeground(this.fg);
        } else {
            this.styledText.setSelectionBackground(this.styledText.getBackground());
            this.styledText.setSelectionForeground(this.styledText.getForeground());
        }
    }

    protected void onTextMouseDoubleClick(Event event) {
        int n;
        Point point;
        if (event.button != 1 || this.model == null) {
            return;
        }
        String string = this.styledText.getText();
        if (string.length() > 0 && (point = this.model.getEditableRange(n = this.styledText.getCaretOffset(), string)) != null) {
            this.styledText.setSelection(point);
        }
    }

    protected void onModifyText(ExtendedModifyEvent extendedModifyEvent) {
        this.layout(false);
    }

    private final class TextLayout
    extends Layout {
        private int marginWidth;
        private int marginHeight;

        public TextLayout(int n) {
            if ((n & 0x800000) != 0) {
                this.marginWidth = 1;
                this.marginHeight = 1;
            } else if ((n & 0x800) != 0) {
                this.marginWidth = 2;
                this.marginHeight = 2;
            } else {
                this.marginWidth = 0;
                this.marginHeight = 0;
            }
        }

        private Point getTextSize(int n, int n2) {
            int n3;
            Point point = MaskEdit.this.styledText.computeSize(n, n2);
            if ((MaskEdit.this.wStyle & 0x1020000) != 0 && (n3 = MaskEdit.this.styledText.getCharCount()) == 0) {
                GC gC = new GC((Drawable)MaskEdit.this.styledText);
                point.x = gC.stringExtent((String)" ").x;
                gC.dispose();
            }
            return point;
        }

        protected Point computeSize(Composite composite, int n, int n2, boolean bl) {
            int n3 = 0;
            int n4 = 0;
            if (MaskEdit.this.styledText != null) {
                Point point = this.getTextSize(n, n2);
                n3 = point.x + 1;
                n4 = point.y;
            }
            n3 += this.marginWidth * 2;
            n4 += this.marginHeight * 2;
            if (n != -1) {
                n3 = n;
            }
            if (n2 != -1) {
                n4 = n2;
            }
            return new Point(n3, n4);
        }

        protected void layout(Composite composite, boolean bl) {
            if (MaskEdit.this.styledText == null) {
                return;
            }
            Rectangle rectangle = composite.getClientArea();
            rectangle.x += this.marginWidth;
            rectangle.y += this.marginHeight;
            rectangle.width -= this.marginWidth * 2;
            rectangle.height -= this.marginHeight * 2;
            if ((MaskEdit.this.wStyle & 0x1020000) != 0) {
                Point point = this.getTextSize(-1, rectangle.height);
                ++point.x;
                if (point.x < rectangle.width) {
                    rectangle.x = (MaskEdit.this.wStyle & 0x20000) != 0 ? (rectangle.x += rectangle.width - point.x) : (rectangle.x += (rectangle.width - point.x) / 2);
                    rectangle.width = point.x;
                }
            } else {
                ++rectangle.width;
            }
            MaskEdit.this.styledText.setBounds(rectangle);
        }
    }

    public static interface MaskModel {
        public void install(StyledText var1);

        public void uninstall();

        public boolean usesOverwriteMode();

        public Point getEditableRange(int var1, String var2);
    }
}

