/*
 * Decompiled with CFR 0.152.
 */
package com.spket.palette;

import com.spket.palette.PaletteEntry;
import com.spket.util.IDragSource;
import com.spket.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PaletteSnippet
extends PaletteEntry
implements IDragSource {
    public static final int T_ELEMENT = 1;
    public static final int T_TEXT = 2;
    private String id;
    private Node node;

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public Node getNode() {
        return this.node;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public String toSource() {
        return this.toSource(2);
    }

    public String toSource(int n) {
        if (this.node == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        this.toSource(this.node, stringBuffer, 0);
        return stringBuffer.toString();
    }

    protected void toSource(Node node, StringBuffer stringBuffer, int n) {
        if (node.getType() == 1) {
            Element element = (Element)node;
            stringBuffer.append('<').append(element.getName());
            List list = element.getAttributes();
            if (list.size() > 0) {
                for (int i = 0; i < list.size(); ++i) {
                    Attribute attribute = (Attribute)list.get(i);
                    stringBuffer.append(' ');
                    stringBuffer.append(attribute.getName());
                    stringBuffer.append("=\"");
                    if (attribute.getDefaultValue() == null) {
                        stringBuffer.append("${").append(StringUtils.escapeValue((String)attribute.getName(), (char)'\"')).append('}');
                    } else {
                        stringBuffer.append(attribute.getDefaultValue());
                    }
                    stringBuffer.append('\"');
                }
            }
            if (element.isEmptyTag()) {
                stringBuffer.append("/>");
            } else {
                List list2 = element.getChildren();
                if (list2.size() > 0) {
                    for (int i = 0; i < list2.size(); ++i) {
                        this.toSource((Node)list2.get(i), stringBuffer, n + 1);
                    }
                }
                stringBuffer.append("</").append(element.getName()).append('>');
            }
        } else if (node.getType() == 2) {
            Text text = (Text)node;
            if (text.isEscape()) {
                stringBuffer.append(StringUtils.escapeValue((String)text.getContent(), (char)'\u0000'));
            } else {
                stringBuffer.append(text.getContent());
            }
        }
    }

    public static final class Text
    extends Node {
        private String content;
        private boolean escape;

        public int getType() {
            return 2;
        }

        public boolean isEscape() {
            return this.escape;
        }

        public void setEscape(boolean bl) {
            this.escape = bl;
        }

        public String getContent() {
            return this.content;
        }

        public void appendContent(String string) {
            this.content = string;
        }
    }

    public static final class Element
    extends Node {
        private String name;
        private List children;
        private boolean isEmptyTag;

        public Element(String string) {
            this.name = string;
        }

        public int getType() {
            return 1;
        }

        public String getName() {
            return this.name;
        }

        public void addChild(Node node) {
            if (this.children == null) {
                this.children = new ArrayList(2);
            }
            this.children.add(node);
        }

        public List getChildren() {
            return this.children != null ? this.children : Collections.EMPTY_LIST;
        }

        public void appendContent(String string) {
            if (this.children == null) {
                this.children = new ArrayList(2);
            }
            Text text = new Text();
            text.appendContent(string);
            this.children.add(text);
        }

        public boolean isEmptyTag() {
            return (this.children == null || this.children.size() == 0) && this.isEmptyTag;
        }

        public void setEmptyTag(boolean bl) {
            this.isEmptyTag = bl;
        }
    }

    public static abstract class Node {
        private List attrs;
        private String refId;

        public abstract int getType();

        public abstract void appendContent(String var1);

        public String getRefId() {
            return this.refId;
        }

        public void setRefId(String string) {
            this.refId = string;
        }

        public void addChild(Node node) {
        }

        public List getChildren() {
            return Collections.EMPTY_LIST;
        }

        public List getAttributes() {
            return this.attrs != null ? this.attrs : Collections.EMPTY_LIST;
        }

        public void addAttribute(int n, String string, String string2, String string3) {
            if (this.attrs == null) {
                this.attrs = new ArrayList(2);
            }
            this.attrs.add(new Attribute(n, string, string2, string3));
        }
    }

    public static final class Attribute {
        private Integer id;
        private String name;
        private String value;
        private String description;

        public Attribute(int n, String string, String string2, String string3) {
            this.name = string;
            this.value = string2;
            this.id = new Integer(n);
            this.description = string3;
        }

        public Integer getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getDefaultValue() {
            return this.value;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

