/*
 * Decompiled with CFR 0.152.
 */
package com.spket.palette;

import com.spket.palette.PaletteCategory;
import com.spket.palette.PaletteEntry;
import com.spket.palette.PaletteSnippet;
import com.spket.util.ImageProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Palette {
    private String id;
    private ImageProvider provider;
    private Map ids = new HashMap();
    private List categories = new ArrayList();

    public void setId(String string) {
        this.id = string;
    }

    public String getId() {
        return this.id;
    }

    public ImageProvider getImageProvider() {
        return this.provider;
    }

    public void setImageProvider(ImageProvider imageProvider) {
        this.provider = imageProvider;
    }

    public void put(String string, PaletteSnippet paletteSnippet) {
        this.ids.put(string, paletteSnippet);
    }

    public PaletteSnippet get(String string) {
        return (PaletteSnippet)this.ids.get(string);
    }

    public List getCategories() {
        return Collections.unmodifiableList(this.categories);
    }

    public void addCategories(List list) {
        for (int i = 0; i < list.size(); ++i) {
            this.addCategory((PaletteCategory)list.get(i));
        }
    }

    public void addCategory(PaletteCategory paletteCategory) {
        paletteCategory.setPalette(this);
        for (int i = 0; i < this.categories.size(); ++i) {
            PaletteCategory paletteCategory2 = (PaletteCategory)this.categories.get(i);
            if (paletteCategory2 == paletteCategory) {
                return;
            }
            if (!paletteCategory2.getLabel().equals(paletteCategory.getLabel())) continue;
            if (paletteCategory2.getIcon() == null) {
                paletteCategory2.setIcon(paletteCategory.getIcon());
            }
            if (paletteCategory2.getIconURL() == null) {
                paletteCategory2.setIconURL(paletteCategory.getIconURL());
            }
            paletteCategory2.addSnippets(paletteCategory.getSnippets());
            return;
        }
        this.categories.add(paletteCategory);
    }

    public boolean removeEntry(PaletteEntry paletteEntry) {
        if (paletteEntry instanceof PaletteCategory) {
            return this.removeCategory((PaletteCategory)paletteEntry);
        }
        if (paletteEntry instanceof PaletteSnippet && this.categories.size() > 0) {
            PaletteSnippet paletteSnippet = (PaletteSnippet)paletteEntry;
            for (int i = 0; i < this.categories.size(); ++i) {
                PaletteCategory paletteCategory = (PaletteCategory)this.categories.get(i);
                if (!paletteCategory.removeSnippet(paletteSnippet)) continue;
                return true;
            }
        }
        return false;
    }

    public PaletteCategory getCategory(PaletteSnippet paletteSnippet) {
        if (this.categories.size() > 0) {
            for (int i = 0; i < this.categories.size(); ++i) {
                PaletteCategory paletteCategory = (PaletteCategory)this.categories.get(i);
                if (!paletteCategory.contains(paletteSnippet)) continue;
                return paletteCategory;
            }
        }
        return null;
    }

    public boolean removeCategory(PaletteCategory paletteCategory) {
        if (this.categories.size() > 0) {
            return this.categories.remove(paletteCategory);
        }
        return false;
    }

    public void replace(Palette palette) {
        if (palette != null) {
            this.categories.clear();
            if (palette.categories != null) {
                this.categories.addAll(palette.categories);
            }
            this.ids.clear();
            if (palette.ids != null) {
                this.ids.putAll(palette.ids);
            }
        }
    }
}

