/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ui.text;

import com.spket.ui.text.CodeIndenter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateTranslator;

public class EncodedTemplateContext
extends DocumentTemplateContext {
    private boolean escaping;

    public EncodedTemplateContext(TemplateContextType templateContextType, IDocument iDocument, int n, int n2) {
        super(templateContextType, iDocument, n, n2);
    }

    public EncodedTemplateContext(TemplateContextType templateContextType, IDocument iDocument, Position position) {
        super(templateContextType, iDocument, position);
    }

    public TemplateBuffer evaluate(Template template) throws BadLocationException, TemplateException {
        if (!this.canEvaluate(template)) {
            return null;
        }
        String string = this.escape(template.getPattern());
        CodeIndenter codeIndenter = new CodeIndenter(this.getDocument(), this.getStart());
        string = codeIndenter.format(string);
        TemplateTranslator templateTranslator = new TemplateTranslator();
        TemplateBuffer templateBuffer = templateTranslator.translate(string);
        this.getContextType().resolve(templateBuffer, (TemplateContext)this);
        return templateBuffer;
    }

    public void setEscaping(boolean bl) {
        this.escaping = bl;
    }

    protected String escape(String string) {
        if (this.escaping) {
            int n = string.length();
            StringBuffer stringBuffer = new StringBuffer(n);
            block4: for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '&': {
                        stringBuffer.append("&amp;");
                        continue block4;
                    }
                    case '<': {
                        stringBuffer.append("&lt;");
                        continue block4;
                    }
                    default: {
                        stringBuffer.append(c);
                    }
                }
            }
            if (stringBuffer.length() != n) {
                return stringBuffer.toString();
            }
        }
        return string;
    }
}

