/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ui.text;

import com.spket.ui.internal.UIPlugin;
import com.spket.util.Debug;
import com.spket.util.StringUtils;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ui.editors.text.EditorsUI;

public class CodeIndenter {
    private int fOffset;
    private IDocument fDocument;
    private IPreferenceStore fStore;

    public CodeIndenter(IDocument iDocument, int n) {
        this.fDocument = iDocument;
        this.fOffset = n;
    }

    public void setPreferenceStore(IPreferenceStore iPreferenceStore) {
        this.fStore = iPreferenceStore;
    }

    public String format(String string) {
        int n = string.indexOf(10);
        if (n == -1) {
            n = string.indexOf(9);
        }
        if (n != -1) {
            String string2 = null;
            if (this.fDocument.getLength() > 0) {
                try {
                    string2 = this.getLineIndentation(this.fOffset);
                }
                catch (BadLocationException badLocationException) {
                    Debug.debug((Throwable)badLocationException);
                    return string;
                }
            } else {
                string2 = "";
            }
            String string3 = TextUtilities.getDefaultLineDelimiter((IDocument)this.fDocument);
            StringBuffer stringBuffer = new StringBuffer(string.length());
            int n2 = -1;
            int n3 = string2.length();
            if (this.isTabConversionEnabled()) {
                n2 = this.getTabSize();
            }
            block7: for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '\n': {
                        n3 = string2.length();
                        stringBuffer.append(string3);
                        stringBuffer.append(string2);
                        continue block7;
                    }
                    case '\r': {
                        continue block7;
                    }
                    case '\t': {
                        if (n2 == -1) {
                            ++n3;
                            stringBuffer.append(c);
                            continue block7;
                        }
                        n3 += this.insertTabString(stringBuffer, n2, n3);
                        continue block7;
                    }
                    default: {
                        ++n3;
                        stringBuffer.append(c);
                    }
                }
            }
            return stringBuffer.toString();
        }
        return string;
    }

    protected int findEndOfWhiteSpace(int n, int n2) throws BadLocationException {
        while (n < n2) {
            char c = this.fDocument.getChar(n);
            if (c != ' ' && c != '\t') {
                return n;
            }
            ++n;
        }
        return n2;
    }

    protected String getLineIndentation(int n) throws BadLocationException {
        int n2 = n == this.fDocument.getLength() ? n - 1 : n;
        IRegion iRegion = this.fDocument.getLineInformationOfOffset(n2);
        int n3 = iRegion.getOffset();
        int n4 = this.findEndOfWhiteSpace(n3, n);
        return this.fDocument.get(n3, n4 - n3);
    }

    protected boolean isTabConversionEnabled() {
        return this.getPreferenceStore().getBoolean("tab.char");
    }

    protected IPreferenceStore getPreferenceStore() {
        if (this.fStore == null) {
            return UIPlugin.getDefault().getPreferenceStore();
        }
        return this.fStore;
    }

    protected int getTabSize() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        if (iPreferenceStore == null) {
            return 4;
        }
        int n = -1;
        boolean bl = iPreferenceStore.getBoolean("tab.default");
        if (!bl) {
            n = StringUtils.toInt((String)iPreferenceStore.getString("tab.size"), (int)-1);
        }
        if (n < 0 && (n = StringUtils.toInt((String)iPreferenceStore.getString("tabWidth"), (int)-1)) == -1) {
            iPreferenceStore = EditorsUI.getPreferenceStore();
            n = iPreferenceStore.getInt("tabWidth");
        }
        return n;
    }

    private int insertTabString(StringBuffer stringBuffer, int n, int n2) {
        if (n == 0) {
            return 0;
        }
        int n3 = n2 % n;
        n3 = n - n3;
        for (int i = 0; i < n3; ++i) {
            stringBuffer.append(' ');
        }
        return n3;
    }
}

