/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ui.properties;

import com.spket.ui.properties.CellEditor;
import com.spket.ui.properties.ICellEditor;
import com.spket.ui.properties.ICellEditorListener;
import com.spket.ui.properties.IDropDownEditor;
import com.spket.ui.properties.IPropertyDescriptor;
import com.spket.ui.properties.IPropertyListener;
import com.spket.ui.properties.IPropertyProvider;
import com.spket.ui.properties.PropertyDescription;
import com.spket.ui.properties.PropertyStates;
import com.spket.util.StringUtils;
import com.spket.widget.BorderLayout;
import com.spket.widget.ListItem;
import com.spket.widget.PropertyList;
import com.spket.widget.UIUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.CPopupShell;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Widget;

public class PropertySheetViewer
extends EventManager {
    public static final int S_CATEGORIZED = 1;
    public static final int S_ALPHABETICAL = 2;
    public static final int S_CATEGORIZED_ALPHABETICAL = 3;
    public static final int S_DESCRIPTION = 4;
    public static final int S_TOOLBAR = 8;
    public static final int S_FILTER = 16;
    private static final String MISC_CATEGORY = "Misc";
    private static final int S_IN_UPDATE = 1024;
    private static final int S_NEED_UPDATE = 2048;
    private static final int D_DESC = 11;
    private int fState;
    private int style;
    private int fIndex;
    private int fColumn;
    private boolean fIsActived;
    private boolean fPreventInvisible;
    private CText fText;
    private CButton fButton;
    private Image fArrowImage;
    private Image fEllipsisImage;
    private ICellEditor fCellEditor;
    PropertyList fList;
    private ToolBarManager fToolBarManager;
    private PropertyDescription fPropertyDesc;
    private IPropertyProvider[] fProviders;
    private boolean fModified;
    private boolean fHandleModifyEvent = true;
    private Shell fPopupSite;
    private PropertyStates fStates;
    private ICellEditorListener fCellListener = new ICellEditorListener(){

        public void applyEditorValue() {
            PropertySheetViewer.this.onApplyEditorValue();
        }

        public void cancelEditor() {
            PropertySheetViewer.this.onCancelEditor();
        }

        public void popup() {
            PropertySheetViewer.this.onPopup();
        }
    };
    static /* synthetic */ Class class$com$spket$ui$properties$IPropertyProvider;
    static /* synthetic */ Class class$com$spket$widget$IOwnerDraw;
    static /* synthetic */ Class class$com$spket$ui$properties$ICellEditor;

    public PropertySheetViewer() {
        this(0x800000);
    }

    public PropertySheetViewer(int n) {
        this.style = n;
        this.fStates = new PropertyStates(this);
    }

    public void addPropertyListener(IPropertyListener iPropertyListener) {
        this.addListenerObject(iPropertyListener);
    }

    public void removePropertyListener(IPropertyListener iPropertyListener) {
        this.removeListenerObject(iPropertyListener);
    }

    public Control createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        composite2.setLayout((Layout)gridLayout);
        this.fToolBarManager = new ToolBarManager(0x800000);
        this.initActions();
        ToolBar toolBar = this.fToolBarManager.createControl(composite2);
        GridData gridData = new GridData(768);
        toolBar.setLayoutData((Object)gridData);
        if (!this.isToolbarVisisble()) {
            toolBar.setVisible(false);
            gridData.heightHint = 0;
        }
        gridData = new GridData(1808);
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayoutData((Object)gridData);
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.attach(composite3);
        this.fList = new PropertyList(composite3, this.style);
        this.fText = new CText((Composite)this.fList, 4);
        this.fText.setBackground(this.fList.getBackground());
        this.fText.setVisible(false);
        this.fText.setSize(10, this.fText.computeSize((int)-1, (int)-1).y);
        this.fButton = new CButton((Composite)this.fList, 8);
        this.fButton.setSize(16, 16);
        this.fPropertyDesc = new PropertyDescription();
        this.fPropertyDesc.createControl(composite3, this.style);
        if (!this.isDescriptionVisible()) {
            this.fPropertyDesc.getControl().setVisible(false);
        }
        this.initImages(composite.getDisplay());
        this.fButton.setImage(this.fArrowImage);
        this.fButton.setVisible(false);
        borderLayout.addLayoutControl((Control)this.fList, 0);
        borderLayout.addLayoutControl(this.fPropertyDesc.getControl(), 2, 40);
        this.installListeners();
        if ((this.style & 0x800000) != 0) {
            UIUtils.paintBordersFor((Composite)composite3);
        } else {
            Listener listener = new Listener(){

                public void handleEvent(Event event) {
                    PropertySheetViewer.this.onPaintBorder(event);
                }
            };
            this.fList.addListener(9, listener);
            this.fPropertyDesc.getControl().addListener(9, listener);
        }
        if (this.fProviders != null) {
            this.update();
        }
        return composite2;
    }

    public void dispose() {
        this.clearListeners();
        this.fProviders = null;
        if (this.fCellEditor != null) {
            this.fCellEditor.removeListener(this.fCellListener);
            this.fCellEditor = null;
        }
        this.fCellListener = null;
        if (this.fToolBarManager != null) {
            this.fToolBarManager.dispose();
            this.fToolBarManager.removeAll();
            this.fToolBarManager = null;
        }
        if (this.fArrowImage != null) {
            this.fArrowImage.dispose();
            this.fArrowImage = null;
        }
        if (this.fEllipsisImage != null) {
            this.fEllipsisImage.dispose();
            this.fEllipsisImage = null;
        }
        this.fText = null;
        this.fButton = null;
        this.fList = null;
        this.fPropertyDesc = null;
    }

    public Object getInput() {
        return this.fProviders;
    }

    public void setInput(Object object) {
        if (object == null && this.fProviders == null) {
            return;
        }
        Object[] objectArray = new Object[]{object};
        this.setInputs(objectArray);
    }

    public void setInputs(Object[] objectArray) {
        ArrayList<IPropertyProvider> arrayList = Collections.EMPTY_LIST;
        if (objectArray != null && objectArray.length > 0) {
            arrayList = new ArrayList<IPropertyProvider>(objectArray.length);
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                IPropertyProvider iPropertyProvider = null;
                if (object instanceof IPropertyProvider) {
                    iPropertyProvider = (IPropertyProvider)object;
                } else if (object instanceof IAdaptable) {
                    iPropertyProvider = (IPropertyProvider)((IAdaptable)object).getAdapter(class$com$spket$ui$properties$IPropertyProvider == null ? PropertySheetViewer.class$("com.spket.ui.properties.IPropertyProvider") : class$com$spket$ui$properties$IPropertyProvider);
                }
                if (iPropertyProvider == null) continue;
                arrayList.add(iPropertyProvider);
            }
        }
        if (arrayList.size() == 0 && this.fProviders == null) {
            return;
        }
        this.fProviders = null;
        if (arrayList.size() > 0) {
            this.fProviders = new IPropertyProvider[arrayList.size()];
            arrayList.toArray(this.fProviders);
        }
        this.update();
    }

    public boolean isFilterMode() {
        return (this.fState & 0x10) != 0;
    }

    public boolean isShowCategories() {
        return (this.fState & 1) != 0;
    }

    public boolean isToolbarVisisble() {
        return (this.fState & 8) != 0;
    }

    public boolean isDescriptionVisible() {
        return (this.fState & 4) != 0;
    }

    public void setSort(int n) {
        if ((this.fState & 3) != (n &= 3)) {
            this.setState(1, (n & 1) != 0);
            this.setState(2, (n & 2) != 0);
            if (UIUtils.okToUse((Widget)this.fList)) {
                this.applyEditorValue();
                this.fList.forceFocus();
                this.update();
            }
        }
    }

    public void setToolbarVisible(boolean bl) {
        ToolBar toolBar;
        boolean bl2;
        boolean bl3 = bl2 = (this.fState & 8) != 0;
        if (bl2 == bl) {
            return;
        }
        this.setState(8, bl);
        if (this.fToolBarManager != null && UIUtils.okToUse((Widget)(toolBar = this.fToolBarManager.getControl()))) {
            GridData gridData = (GridData)toolBar.getLayoutData();
            gridData.heightHint = bl ? -1 : 0;
            toolBar.setVisible(bl);
            toolBar.getParent().layout(true);
        }
    }

    public void setDescriptionVisible(boolean bl) {
        Control control;
        boolean bl2;
        boolean bl3 = bl2 = (this.fState & 4) != 0;
        if (bl2 == bl) {
            return;
        }
        this.setState(4, bl);
        if (this.fPropertyDesc != null && UIUtils.okToUse((Widget)(control = this.fPropertyDesc.getControl()))) {
            control.setVisible(bl);
            control.getParent().layout(true);
        }
    }

    public void setFocus() {
        if (this.fList != null) {
            this.fList.forceFocus();
        }
    }

    protected final void setState(int n, boolean bl) {
        this.fState = bl ? (this.fState |= n) : (this.fState &= ~n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        boolean bl;
        Object object = this;
        synchronized (object) {
            if ((this.fState & 0x400) != 0) {
                this.setState(2048, true);
                return;
            }
        }
        this.fModified = false;
        this.fHandleModifyEvent = true;
        if (!UIUtils.okToUse((Widget)this.fList)) {
            return;
        }
        this.fStates.saveState();
        this.fList.setRedraw(false);
        this.fList.removeAll();
        object = this.computeMergedPropertyDescriptors();
        HashMap<String, List<ListItem>> hashMap = new HashMap<String, List<ListItem>>();
        List<ListItem> list = new ArrayList<ListItem>();
        String string = null;
        if (object.size() > 0) {
            Object object2;
            Map.Entry entry;
            int n;
            ItemComparator itemComparator = new ItemComparator();
            for (n = 0; n < object.size(); ++n) {
                entry = (IPropertyDescriptor)object.get(n);
                if (this.isShowCategories()) {
                    string = entry.getCategory();
                    if (StringUtils.isEmpty((String)string)) {
                        string = MISC_CATEGORY;
                    }
                    if ((list = (List)hashMap.get(string)) == null) {
                        list = new ArrayList();
                        hashMap.put(string, list);
                    }
                }
                object2 = this.createItem((IPropertyDescriptor)((Object)entry));
                list.add((ListItem)object2);
            }
            if (this.isShowCategories()) {
                list = new ArrayList(hashMap.size());
                Iterator iterator = hashMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    object2 = (List)entry.getValue();
                    if (object2.size() <= 0) continue;
                    string = (String)entry.getKey();
                    ListItem listItem = new ListItem(string);
                    listItem.setCategory(true);
                    ListItem[] listItemArray = object2.toArray(new ListItem[object2.size()]);
                    if ((this.fState & 2) != 0) {
                        Arrays.sort(listItemArray, itemComparator);
                    }
                    listItem.addItems(listItemArray);
                    list.add(listItem);
                }
            }
            if (list.size() > 0) {
                if ((this.fState & 3) != 0) {
                    Collections.sort(list, itemComparator);
                }
                for (n = 0; n < list.size(); ++n) {
                    this.fList.addItem((ListItem)list.get(n));
                }
            }
        } else {
            this.fList.layout(false);
        }
        this.fStates.restoreState();
        this.fIndex = this.fList.getSelectionIndex();
        boolean bl2 = bl = this.fIsActived && object.size() > 0;
        if (bl) {
            this.fIsActived = false;
            this.activateCellEditor(false);
        } else {
            this.deactivateCellEditor();
        }
        this.fList.setRedraw(true);
        PropertySheetViewer propertySheetViewer = this;
        synchronized (propertySheetViewer) {
            this.setState(2048, false);
        }
    }

    protected boolean supportFilterMode(List list) {
        for (int i = 0; i < list.size(); ++i) {
            IPropertyDescriptor iPropertyDescriptor = (IPropertyDescriptor)list.get(i);
            if (!iPropertyDescriptor.hasChildProperties()) continue;
            return false;
        }
        return true;
    }

    protected List computeMergedPropertyDescriptors() {
        if (this.fProviders == null) {
            return Collections.EMPTY_LIST;
        }
        Map[] mapArray = new Map[this.fProviders.length];
        for (int i = 0; i < this.fProviders.length; ++i) {
            mapArray[i] = this.computePropertyDescriptorsFor(this.fProviders[i]);
            if (!mapArray[i].isEmpty()) continue;
            return Collections.EMPTY_LIST;
        }
        Map map = mapArray[0];
        for (int i = 1; i < mapArray.length; ++i) {
            Object[] objectArray = map.keySet().toArray();
            for (int j = 0; j < objectArray.length; ++j) {
                IPropertyDescriptor iPropertyDescriptor = (IPropertyDescriptor)mapArray[i].get(objectArray[j]);
                if (iPropertyDescriptor != null && iPropertyDescriptor.isCompatibleWith((IPropertyDescriptor)map.get(objectArray[j]))) continue;
                map.remove(objectArray[j]);
            }
        }
        if (map.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        return new ArrayList(map.values());
    }

    private Map computePropertyDescriptorsFor(IPropertyProvider iPropertyProvider) {
        IPropertyDescriptor[] iPropertyDescriptorArray = iPropertyProvider.getPropertyDescriptors();
        if (iPropertyDescriptorArray.length > 0) {
            HashMap<Object, IPropertyDescriptor> hashMap = new HashMap<Object, IPropertyDescriptor>(iPropertyDescriptorArray.length);
            for (int i = 0; i < iPropertyDescriptorArray.length; ++i) {
                hashMap.put(iPropertyDescriptorArray[i].getId(), iPropertyDescriptorArray[i]);
            }
            return hashMap;
        }
        return Collections.EMPTY_MAP;
    }

    protected ListItem createItem(IPropertyDescriptor iPropertyDescriptor) {
        ListItem listItem = new ListItem(iPropertyDescriptor.getDisplayName());
        listItem.setData(11, (Object)iPropertyDescriptor);
        this.updateItem(listItem, iPropertyDescriptor);
        if (iPropertyDescriptor.hasChildProperties()) {
            IPropertyDescriptor[] iPropertyDescriptorArray = iPropertyDescriptor.getChildProperties();
            for (int i = 0; i < iPropertyDescriptorArray.length; ++i) {
                ListItem listItem2 = this.createItem(iPropertyDescriptorArray[i]);
                listItem.addItem(listItem2);
            }
        }
        return listItem;
    }

    protected boolean isEditable(IPropertyDescriptor iPropertyDescriptor) {
        for (int i = 0; i < this.fProviders.length; ++i) {
            if (this.fProviders[i].isPropertyEditable(iPropertyDescriptor)) continue;
            return false;
        }
        return true;
    }

    protected Object getPropertyValue(IPropertyDescriptor iPropertyDescriptor) {
        return this.fProviders[0].getPropertyValue(iPropertyDescriptor);
    }

    protected void updateItem(ListItem listItem) {
        IPropertyDescriptor iPropertyDescriptor = (IPropertyDescriptor)listItem.getData(11);
        if (iPropertyDescriptor != null) {
            this.updateItem(listItem, iPropertyDescriptor);
        }
        ListItem[] listItemArray = listItem.getItems();
        for (int i = 0; i < listItemArray.length; ++i) {
            this.updateItem(listItemArray[i]);
        }
    }

    protected void updateItem(ListItem listItem, IPropertyDescriptor iPropertyDescriptor) {
        listItem.setData(1, iPropertyDescriptor.getAdapter(class$com$spket$widget$IOwnerDraw == null ? (class$com$spket$widget$IOwnerDraw = PropertySheetViewer.class$("com.spket.widget.IOwnerDraw")) : class$com$spket$widget$IOwnerDraw));
        Object object = this.getPropertyValue(iPropertyDescriptor);
        listItem.setData(object);
        String string = "";
        if (object != null) {
            string = object.toString();
        }
        listItem.setText(1, string);
        if (!this.isEditable(iPropertyDescriptor)) {
            listItem.setReadOnly(true);
        }
    }

    protected void initActions() {
    }

    protected void installListeners() {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 1: {
                        if (event.widget == PropertySheetViewer.this.fText) {
                            PropertySheetViewer.this.onTextKeyDown(event);
                            break;
                        }
                        PropertySheetViewer.this.onListKeyDown(event);
                        break;
                    }
                    case 24: {
                        PropertySheetViewer.this.onTextModify(event);
                        break;
                    }
                    case 16: {
                        event.display.asyncExec((Runnable)new FocusChecker());
                        break;
                    }
                    case 26: 
                    case 27: {
                        PropertySheetViewer.this.onActivationChanged(event);
                        break;
                    }
                    case 3: {
                        PropertySheetViewer.this.onListMouseDown(event);
                        break;
                    }
                    case 4: {
                        PropertySheetViewer.this.onListMouseUp(event);
                        break;
                    }
                    case 13: {
                        if (event.widget == PropertySheetViewer.this.fButton) {
                            PropertySheetViewer.this.onButtonSelection(event);
                            break;
                        }
                        if (event.widget == PropertySheetViewer.this.fList) {
                            PropertySheetViewer.this.onListSelectionChanged(event);
                            break;
                        }
                        PropertySheetViewer.this.onScroll(event);
                        break;
                    }
                    case 8: {
                        PropertySheetViewer.this.onMouseDoubleClick(event);
                        break;
                    }
                    case 11: {
                        PropertySheetViewer.this.onListResize(event);
                        break;
                    }
                    case 4001: {
                        PropertySheetViewer.this.onOffsetChanged(event);
                    }
                }
            }
        };
        this.fList.addListener(3, listener);
        this.fList.addListener(4, listener);
        this.fList.addListener(13, listener);
        this.fList.addListener(1, listener);
        this.fList.addListener(8, listener);
        this.fList.addListener(11, listener);
        this.fList.addListener(4001, listener);
        this.fText.addListener(1, listener);
        this.fText.addListener(24, listener);
        this.fText.addListener(8, listener);
        this.fButton.addListener(13, listener);
        this.fList.addListener(26, listener);
        this.fList.addListener(27, listener);
        this.fList.addListener(16, listener);
        this.fText.addListener(16, listener);
        this.fButton.addListener(16, listener);
        this.fList.getVerticalBar().addListener(13, listener);
    }

    protected void onPaintBorder(Event event) {
        GC gC = event.gc;
        Control control = (Control)event.widget;
        Rectangle rectangle = control.getBounds();
        if (control == this.fList) {
            control = this.fPropertyDesc.getControl();
            if (UIUtils.okToUse((Widget)control) && control.isVisible()) {
                int n = rectangle.y + rectangle.height - 1;
                gC.setForeground(UIUtils.getColor((String)"color.border"));
                gC.drawLine(rectangle.x, n, rectangle.x + rectangle.width, n);
            }
        } else {
            gC.setForeground(UIUtils.getColor((String)"color.border"));
            gC.drawLine(rectangle.x, 0, rectangle.x + rectangle.width, 0);
        }
    }

    protected void initImages(Display display) {
        Color color = display.getSystemColor(2);
        int n = 9;
        int n2 = 6;
        PaletteData paletteData = new PaletteData(new RGB[]{this.fButton.getForeground().getRGB(), this.fButton.getBackground().getRGB(), color.getRGB()});
        int[] nArray = new int[]{1, 1, 4, 5, 8, 1};
        ImageData imageData = new ImageData(n, n2, 4, paletteData);
        imageData.transparentPixel = 1;
        this.fArrowImage = new Image((Device)display, imageData);
        GC gC = new GC((Drawable)this.fArrowImage);
        gC.setBackground(this.fButton.getBackground());
        gC.fillRectangle(0, 0, n, n2);
        gC.setBackground(color);
        gC.fillPolygon(nArray);
        gC.dispose();
        paletteData = new PaletteData(new RGB[]{this.fButton.getForeground().getRGB(), this.fButton.getBackground().getRGB(), color.getRGB()});
        imageData = new ImageData(n, n2, 4, paletteData);
        imageData.transparentPixel = 1;
        this.fEllipsisImage = new Image((Device)display, imageData);
        gC = new GC((Drawable)this.fEllipsisImage);
        gC.setBackground(this.fButton.getBackground());
        gC.fillRectangle(0, 0, n, n2);
        gC.setForeground(color);
        int n3 = 1;
        for (int i = 0; i < 3; ++i) {
            gC.drawLine(n3, 4, n3 + 1, 4);
            gC.drawLine(n3, 5, n3 + 1, 5);
            n3 += 3;
        }
        gC.dispose();
    }

    protected void onFocusLost() {
        if (this.fPreventInvisible) {
            return;
        }
        if (UIUtils.okToUse((Widget)this.fList)) {
            boolean bl;
            boolean bl2 = true;
            boolean bl3 = bl = this.fList.isFocusControl() || this.fText.isFocusControl() || this.fButton.isFocusControl();
            if (bl) {
                boolean bl4 = bl2 = this.fList.getDisplay().getActiveShell() != this.fList.getShell();
            }
            if (bl2) {
                this.deactivateCellEditor();
                this.fList.setHighLighting(false);
            } else if (this.fList.isFocusControl()) {
                this.applyEditorValue();
            }
        }
    }

    protected void onActivationChanged(Event event) {
        if (this.fPreventInvisible) {
            return;
        }
        if (event.type == 26) {
            if (this.fIsActived) {
                return;
            }
            if (this.fList.isFocusControl()) {
                this.deactivateCellEditor();
            }
            this.activateCellEditor(false);
            this.fList.setHighLighting(true);
        }
    }

    protected void onTextKeyDown(Event event) {
        switch (event.character) {
            case '\u001b': {
                this.cancelCellEditor();
                break;
            }
            case '\r': {
                this.applyEditorValue();
                this.fList.forceFocus();
            }
        }
    }

    protected void onTextModify(Event event) {
        if (this.fHandleModifyEvent) {
            this.fModified = true;
        }
    }

    protected void onMouseDoubleClick(Event event) {
        Object object;
        IPropertyDescriptor iPropertyDescriptor;
        ICellEditor iCellEditor;
        if (event.detail != 0) {
            this.resetBounds();
            return;
        }
        ListItem listItem = this.fList.getItem(this.fList.getSelectionIndex());
        if (listItem != null && !listItem.isReadOnly() && (iCellEditor = (ICellEditor)(iPropertyDescriptor = (IPropertyDescriptor)listItem.getData(11)).getAdapter(class$com$spket$ui$properties$ICellEditor == null ? (class$com$spket$ui$properties$ICellEditor = PropertySheetViewer.class$("com.spket.ui.properties.ICellEditor")) : class$com$spket$ui$properties$ICellEditor)) != null && (object = iCellEditor.getNextValue(this.fProviders, iPropertyDescriptor, this.fText.getText())) != null) {
            this.applyEditorValue(object);
        }
    }

    protected void onListKeyDown(Event event) {
        switch (event.keyCode) {
            case 0x1000001: 
            case 0x1000002: 
            case 0x1000003: 
            case 0x1000004: 
            case 0x1000005: 
            case 0x1000006: 
            case 0x1000007: 
            case 0x1000008: {
                this.fIsActived = false;
                this.activateCellEditor(false);
            }
        }
    }

    protected void onListMouseDown(Event event) {
        this.fList.forceFocus();
        if (event.detail == 1) {
            if (this.fText.isVisible()) {
                this.fText.setVisible(false);
            }
        } else {
            int n;
            int n2 = this.fList.getSelectionIndex();
            if (n2 != this.fIndex) {
                this.deactivateCellEditor();
                this.fColumn = this.fList.getColumnIndex(event.x);
                int n3 = this.getActiveColumn();
                boolean bl = false;
                if (n2 != -1) {
                    Rectangle rectangle = this.fList.getBounds(n2, n3);
                    bl = rectangle != null && rectangle.contains(event.x, event.y);
                }
                this.activateCellEditor(bl);
                this.fIndex = n2;
            } else if (this.isFilterMode() && this.fColumn != (n = this.fList.getColumnIndex(event.x))) {
                this.deactivateCellEditor();
                this.fColumn = n;
                this.activateCellEditor(true);
            }
        }
    }

    protected void onListMouseUp(Event event) {
        if (event.detail == 1) {
            this.resetBounds();
        }
    }

    protected void onListResize(Event event) {
        this.resetBounds();
    }

    protected void onOffsetChanged(Event event) {
        this.resetBounds();
    }

    protected void onListSelectionChanged(Event event) {
        IPropertyDescriptor iPropertyDescriptor;
        ListItem listItem;
        int n = this.fList.getSelectionIndex();
        if (n != -1 && !(listItem = this.fList.getItem(n)).isCategory() && (iPropertyDescriptor = (IPropertyDescriptor)listItem.getData(11)) != null) {
            iPropertyDescriptor.getDescription();
        }
    }

    protected void onScroll(Event event) {
        if (this.fText.isFocusControl() || this.fButton.isFocusControl()) {
            this.fList.forceFocus();
        }
        this.resetBounds();
    }

    protected void onButtonSelection(Event event) {
        IPropertyDescriptor iPropertyDescriptor;
        Object object;
        if (this.fCellEditor != null) {
            this.fCellEditor.removeListener(this.fCellListener);
            this.fCellEditor = null;
        }
        int n = this.getActiveColumn();
        int n2 = this.fList.getSelectionIndex();
        Object[] objectArray = null;
        String string = null;
        if (n != 0) {
            object = this.fList.getItem(n2);
            if (object == null) {
                return;
            }
            iPropertyDescriptor = (IPropertyDescriptor)object.getData(11);
            string = this.fText.getText();
            if (iPropertyDescriptor.getType() == 1025) {
                objectArray = CellEditor.getChoiceOfValues(this.fProviders, iPropertyDescriptor);
            }
            this.fCellEditor = (ICellEditor)iPropertyDescriptor.getAdapter(class$com$spket$ui$properties$ICellEditor == null ? (class$com$spket$ui$properties$ICellEditor = PropertySheetViewer.class$("com.spket.ui.properties.ICellEditor")) : class$com$spket$ui$properties$ICellEditor);
        }
        if (this.fCellEditor == null) {
            return;
        }
        this.fCellEditor.addListener(this.fCellListener);
        if (this.fCellEditor instanceof IDropDownEditor) {
            this.fPopupSite = this.createPopupSite();
            object = (IDropDownEditor)this.fCellEditor;
            object.setInput(objectArray);
            object.setValue(string);
            object.fill((Composite)this.fPopupSite);
            iPropertyDescriptor = this.fButton.getBounds();
            Point point = this.fList.toDisplay(((Rectangle)iPropertyDescriptor).x, ((Rectangle)iPropertyDescriptor).y);
            ((Rectangle)iPropertyDescriptor).x = point.x;
            ((Rectangle)iPropertyDescriptor).y = point.y;
            if (object.isFixedSize()) {
                this.fPopupSite.pack();
            } else {
                Rectangle rectangle = this.fList.getBounds(n2, n);
                int n3 = rectangle != null ? rectangle.width : this.fList.getBounds((int)n2, (int)n).width;
                point = this.fPopupSite.computeSize(n3 + 2, -1, true);
                n3 = this.fPopupSite.computeSize((int)-1, (int)-1, (boolean)true).x;
                if (n3 > point.x) {
                    point.x = n3;
                }
                this.fPopupSite.setSize(point);
            }
            this.fPopupSite.layout();
            this.fPreventInvisible = true;
            this.fList.forceFocus();
            UIUtils.show((Control)this.fPopupSite, (Rectangle)iPropertyDescriptor, (int)131072);
            object.setFocus();
        } else {
            this.fCellEditor.setInput(this.fProviders[0]);
            this.fCellEditor.setValue(this.fText.getText());
            this.fCellEditor.popup(this.fList.getShell());
        }
    }

    protected int getActiveColumn() {
        return this.isFilterMode() ? this.fColumn : 1;
    }

    protected boolean resetBounds() {
        if (!this.fIsActived) {
            return false;
        }
        boolean bl = false;
        int n = this.fList.getSelectionIndex();
        ListItem listItem = this.fList.getItem(n);
        if (listItem == null || listItem.isCategory()) {
            this.fText.setVisible(false);
            this.fButton.setVisible(false);
        } else {
            int n2 = this.getActiveColumn();
            Rectangle rectangle = this.fList.getCellBounds(n, n2);
            if (rectangle == null) {
                this.fText.setVisible(false);
                this.fButton.setVisible(false);
            } else {
                IPropertyDescriptor iPropertyDescriptor;
                boolean bl2;
                int n3 = 0;
                boolean bl3 = false;
                boolean bl4 = bl2 = n2 == 0 || !listItem.isReadOnly();
                if (n2 == 0) {
                    bl3 = true;
                } else {
                    iPropertyDescriptor = (IPropertyDescriptor)listItem.getData(11);
                    n3 = iPropertyDescriptor.getType();
                    boolean bl5 = bl3 = (n3 & 0xC00) != 0;
                }
                if (bl3 &= bl2) {
                    iPropertyDescriptor = this.fButton.getBounds();
                    this.fText.setBounds(rectangle.x, rectangle.y, rectangle.width - ((Rectangle)iPropertyDescriptor).width, rectangle.height);
                    this.fButton.setBounds(rectangle.x + rectangle.width - ((Rectangle)iPropertyDescriptor).width, rectangle.y - 1, ((Rectangle)iPropertyDescriptor).width, rectangle.height + 1);
                    Image image = this.fArrowImage;
                    if ((n3 & 0x800) != 0) {
                        image = this.fEllipsisImage;
                    }
                    if (this.fButton.getImage() != image) {
                        this.fButton.setImage(image);
                    }
                } else {
                    this.fText.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
                if (this.fButton.isVisible() != bl3) {
                    this.fButton.setVisible(bl3);
                }
                if (!this.fText.isVisible()) {
                    this.fText.setVisible(true);
                }
                if ((this.fText.getStyle() & 8) == 0 != bl2) {
                    this.fText.setEditable(bl2);
                    if (bl2) {
                        this.fText.setForeground(this.fList.getForeground());
                    } else {
                        this.fText.setForeground(this.fText.getDisplay().getSystemColor(16));
                    }
                }
                bl = true;
            }
        }
        return bl;
    }

    protected void activateCellEditor(boolean bl) {
        if (this.fIsActived) {
            this.resetBounds();
            return;
        }
        this.fList.setHighLighting(1 - this.getActiveColumn());
        int n = this.fList.getSelectionIndex();
        if (n != -1) {
            this.fIsActived = true;
            int n2 = this.getActiveColumn();
            ListItem listItem = this.fList.getItem(n);
            String string = n2 == 0 ? listItem.getText() : listItem.getText(1);
            this.fHandleModifyEvent = false;
            this.fText.setText(string == null ? StringUtils.EMPTY_STRING : string);
            this.fHandleModifyEvent = true;
            this.resetBounds();
            if (bl) {
                if (this.fText.isVisible()) {
                    this.fText.setFocus();
                } else if (!this.fList.isFocusControl()) {
                    this.fList.forceFocus();
                }
            }
        }
    }

    protected void cancelCellEditor() {
        this.fModified = false;
        int n = this.fList.getSelectionIndex();
        if (n != -1) {
            ListItem listItem = this.fList.getItem(n);
            this.fHandleModifyEvent = false;
            String string = listItem.getText(1);
            this.fText.setText(string == null ? StringUtils.EMPTY_STRING : string);
            this.fHandleModifyEvent = true;
        }
        this.fList.forceFocus();
    }

    protected void deactivateCellEditor() {
        if (this.fIsActived) {
            this.fIsActived = false;
            this.fText.setVisible(false);
            this.fButton.setVisible(false);
            this.applyEditorValue();
            this.fList.setHighLighting(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyEditorValue(Object object) {
        this.fModified = false;
        if (this.fProviders == null) {
            return;
        }
        IPropertyProvider[] iPropertyProviderArray = this.fProviders;
        int n = this.fIndex;
        int n2 = this.getActiveColumn();
        ListItem listItem = this.fList.getItem(n);
        if (listItem != null) {
            IPropertyDescriptor iPropertyDescriptor = (IPropertyDescriptor)listItem.getData(11);
            if (n2 != 0) {
                Object object2;
                boolean bl = false;
                if (iPropertyProviderArray.length > 1) {
                    bl = true;
                } else if (iPropertyProviderArray.length == 1) {
                    object2 = listItem.getData();
                    boolean bl2 = bl = !this.equals(object2, object);
                }
                if (bl) {
                    PropertySheetViewer propertySheetViewer;
                    int n3;
                    object2 = this;
                    synchronized (object2) {
                        this.setState(1024, true);
                    }
                    object2 = this.getListeners();
                    for (n3 = 0; n3 < ((Object[])object2).length; ++n3) {
                        ((IPropertyListener)object2[n3]).propertyAboutToBeChanged(iPropertyProviderArray, iPropertyDescriptor);
                    }
                    try {
                        for (n3 = 0; n3 < iPropertyProviderArray.length; ++n3) {
                            iPropertyProviderArray[n3].setPropertyValue(iPropertyDescriptor, object);
                        }
                        Object var11_11 = null;
                        propertySheetViewer = this;
                    }
                    catch (Throwable throwable) {
                        Object var11_12 = null;
                        PropertySheetViewer propertySheetViewer2 = this;
                        synchronized (propertySheetViewer2) {
                            this.setState(1024, false);
                        }
                        throw throwable;
                    }
                    synchronized (propertySheetViewer) {
                        this.setState(1024, false);
                    }
                    for (n3 = 0; n3 < ((Object[])object2).length; ++n3) {
                        ((IPropertyListener)object2[n3]).propertyChanged(iPropertyProviderArray, iPropertyDescriptor);
                    }
                    if ((this.fState & 0x800) != 0) {
                        this.update();
                    }
                }
            }
        }
    }

    protected void applyEditorValue() {
        if (this.fModified) {
            this.applyEditorValue(this.fText.getText());
        }
    }

    protected void onPopupSiteDown() {
        this.fPreventInvisible = false;
        Control control = this.fList.getDisplay().getFocusControl();
        if (control != this.fList && control != this.fText && control != this.fButton) {
            this.deactivateCellEditor();
            this.fList.setHighLighting(false);
        }
    }

    protected Shell createPopupSite() {
        if (!UIUtils.okToUse((Widget)this.fPopupSite)) {
            this.fPopupSite = new CPopupShell(this.fList.getShell(), 16392, true);
            this.fPopupSite.setVisible(false);
            this.fPopupSite.setBackground(this.fList.getDisplay().getSystemColor(2));
            FillLayout fillLayout = new FillLayout(512);
            fillLayout.marginHeight = 1;
            fillLayout.marginWidth = 1;
            this.fPopupSite.setLayout((Layout)fillLayout);
            Listener listener = new Listener(){

                public void handleEvent(Event event) {
                    switch (event.type) {
                        case 23: {
                            PropertySheetViewer.this.onPopupSiteDown();
                        }
                    }
                }
            };
            this.fPopupSite.addListener(23, listener);
        }
        return this.fPopupSite;
    }

    protected void onApplyEditorValue() {
        if (this.fCellEditor != null) {
            ICellEditor iCellEditor = this.fCellEditor;
            this.fCellEditor = null;
            iCellEditor.removeListener(this.fCellListener);
            Object object = iCellEditor.getValue();
            if (UIUtils.okToUse((Widget)this.fPopupSite) && this.fPopupSite.isVisible()) {
                this.fPopupSite.setVisible(false);
            }
            this.applyEditorValue(object);
        }
    }

    protected void onCancelEditor() {
        if (this.fCellEditor != null) {
            this.fCellEditor.removeListener(this.fCellListener);
            this.fCellEditor = null;
            if (UIUtils.okToUse((Widget)this.fPopupSite) && this.fPopupSite.isVisible()) {
                this.fPopupSite.setVisible(false);
            }
        }
    }

    protected void onPopup() {
        if (this.fCellEditor != null) {
            if (this.fPopupSite.isVisible()) {
                this.fPopupSite.setVisible(false);
            }
            this.fPreventInvisible = false;
            this.fCellEditor.popup(this.fList.getShell());
        }
    }

    protected boolean equals(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null) {
            if (object2 instanceof String && ((String)object2).length() == 0) {
                return true;
            }
        } else if (object2 == null) {
            if (object instanceof String && ((String)object).length() == 0) {
                return true;
            }
        } else {
            return object.equals(object2);
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class FocusChecker
    implements Runnable {
        private FocusChecker() {
        }

        public void run() {
            PropertySheetViewer.this.onFocusLost();
        }
    }

    private static final class CText
    extends Text {
        public CText(Composite composite, int n) {
            super(composite, n);
        }

        public boolean forceFocus() {
            if (!this.isEnabled() || !this.isVisible()) {
                return this.getParent().forceFocus();
            }
            return super.forceFocus();
        }

        protected void checkSubclass() {
        }
    }

    private static final class CButton
    extends Button {
        public CButton(Composite composite, int n) {
            super(composite, n);
        }

        public boolean forceFocus() {
            if (!this.isEnabled() || !this.isVisible()) {
                return this.getParent().forceFocus();
            }
            return super.forceFocus();
        }

        protected void checkSubclass() {
        }
    }

    private static final class ItemComparator
    implements Comparator {
        private ItemComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            if (object instanceof ListItem && object2 instanceof ListItem) {
                return ((ListItem)object).getText().compareTo(((ListItem)object2).getText());
            }
            return StringUtils.compareTo((Object)object, (Object)object2);
        }
    }
}

