/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ui.preferences;

import com.spket.ui.preferences.OverlayPreferenceStore;
import com.spket.ui.preferences.PrefMessages;
import com.spket.ui.util.Message;
import com.spket.ui.util.PixelConverter;
import com.spket.ui.util.StatusInfo;
import com.spket.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public abstract class AbstractPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    protected static final OverlayPreferenceStore.OverlayKey[] NO_KEYS = new OverlayPreferenceStore.OverlayKey[0];
    private Map fCheckBoxes = new HashMap();
    private OverlayPreferenceStore fOverlayStore;
    private Listener linkListener;
    private Listener fCheckBoxListener = new Listener(){

        public void handleEvent(Event event) {
            Button button = (Button)event.widget;
            String string = (String)AbstractPreferencePage.this.fCheckBoxes.get(button);
            AbstractPreferencePage.this.fOverlayStore.setValue(string, button.getSelection());
            AbstractPreferencePage.this.onFieldChanged(string, (Control)button);
        }
    };
    private Map fTextFields = new HashMap();
    private ModifyListener fTextFieldListener = new ModifyListener(){

        public void modifyText(ModifyEvent modifyEvent) {
            Text text = (Text)modifyEvent.widget;
            AbstractPreferencePage.this.fOverlayStore.setValue((String)AbstractPreferencePage.this.fTextFields.get(text), text.getText());
        }
    };
    private ArrayList fNumberFields = new ArrayList();
    private ModifyListener fNumberFieldListener = new ModifyListener(){

        public void modifyText(ModifyEvent modifyEvent) {
            AbstractPreferencePage.this.numberFieldChanged((Text)modifyEvent.widget);
        }
    };

    public AbstractPreferencePage() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        if (iPreferenceStore != null) {
            this.fOverlayStore = new OverlayPreferenceStore(iPreferenceStore, this.createOverlayStoreKeys());
        }
    }

    public void init(IWorkbench iWorkbench) {
    }

    protected OverlayPreferenceStore getOverlayPreferenceStore() {
        return this.fOverlayStore;
    }

    protected Composite createSubsection(Composite composite, String string, int n) {
        Group group = new Group(composite, 32);
        group.setText(string);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = n;
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)new GridData(768));
        return group;
    }

    protected Label createLable(Composite composite, String string) {
        return this.createLable(composite, string, 1);
    }

    protected Label createLable(Composite composite, String string, int n) {
        Label label = null;
        if (string == null) {
            label = new Label(composite, 258);
        } else {
            label = new Label(composite, 0);
            label.setText(string);
        }
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = n;
        label.setLayoutData((Object)gridData);
        return label;
    }

    protected Button addCheckBox(Composite composite, String string, String string2, int n, int n2) {
        Button button = new Button(composite, 32);
        button.setText(string);
        GridData gridData = new GridData(32);
        gridData.horizontalSpan = n;
        gridData.horizontalIndent = n2;
        button.setLayoutData((Object)gridData);
        button.addListener(13, this.fCheckBoxListener);
        this.fCheckBoxes.put(button, string2);
        return button;
    }

    protected Control[] addLabelledTextField(Composite composite, String string, String string2, int n, int n2, boolean bl) {
        Label label = new Label(composite, 0);
        label.setText(string);
        GridData gridData = new GridData(32);
        gridData.horizontalIndent = n2;
        label.setLayoutData((Object)gridData);
        Text text = new Text(composite, 2052);
        if (n == -1) {
            gridData = new GridData(768);
        } else {
            gridData = new GridData(32);
            PixelConverter pixelConverter = new PixelConverter((Control)composite);
            gridData.widthHint = pixelConverter.convertWidthInCharsToPixels(n + 1);
            text.setTextLimit(n);
        }
        text.setLayoutData((Object)gridData);
        this.fTextFields.put(text, string2);
        if (bl) {
            this.fNumberFields.add(text);
            text.addModifyListener(this.fNumberFieldListener);
        } else {
            text.addModifyListener(this.fTextFieldListener);
        }
        return new Control[]{label, text};
    }

    protected Link createLink(Composite composite, String string) {
        return this.createLink(composite, string, 1);
    }

    protected Link createLink(Composite composite, String string, int n) {
        Link link = new Link(composite, 0);
        link.setText(string);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = n;
        link.setLayoutData((Object)gridData);
        if (this.linkListener == null) {
            this.linkListener = new Listener(){

                public void handleEvent(Event event) {
                    String string = StringUtils.makeNullIfEmpty((String)event.text);
                    if (string != null) {
                        Program.launch((String)string);
                    }
                }
            };
        }
        link.addListener(13, this.linkListener);
        link.addListener(14, this.linkListener);
        return link;
    }

    public void dispose() {
        super.dispose();
        if (this.fCheckBoxes != null) {
            this.fCheckBoxes.clear();
        }
    }

    public void createControl(Composite composite) {
        if (this.fOverlayStore != null) {
            this.fOverlayStore.load();
            this.fOverlayStore.start();
        }
        super.createControl(composite);
        if (this.fOverlayStore != null) {
            this.initialize();
        }
    }

    public boolean performOk() {
        Plugin plugin = this.getPlugin();
        if (plugin != null) {
            this.fOverlayStore.propagate();
            plugin.savePluginPreferences();
        }
        return true;
    }

    public void performDefaults() {
        if (this.fOverlayStore != null) {
            this.fOverlayStore.loadDefaults();
            this.initialize();
        }
        super.performDefaults();
    }

    protected abstract Plugin getPlugin();

    protected abstract String getPluginId();

    protected abstract OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys();

    protected void onFieldChanged(String string, Control control) {
    }

    protected void initialize() {
        this.initializeFields();
    }

    private void initializeFields() {
        Text text;
        OverlayPreferenceStore overlayPreferenceStore = this.getOverlayPreferenceStore();
        Iterator iterator = this.fCheckBoxes.entrySet().iterator();
        while (iterator.hasNext()) {
            text = iterator.next();
            if (!overlayPreferenceStore.getBoolean((String)text.getValue())) continue;
            ((Button)text.getKey()).setSelection(true);
        }
        iterator = this.fTextFields.keySet().iterator();
        while (iterator.hasNext()) {
            text = (Text)iterator.next();
            String string = (String)this.fTextFields.get(text);
            text.setText(overlayPreferenceStore.getString(string));
        }
        this.updateStatus(new StatusInfo(this.getPluginId()));
    }

    private void numberFieldChanged(Text text) {
        String string = text.getText();
        IStatus iStatus = this.validatePositiveNumber(string);
        if (iStatus == null || !iStatus.matches(4)) {
            this.fOverlayStore.setValue((String)this.fTextFields.get(text), string);
        }
        this.updateStatus(iStatus);
    }

    private IStatus validatePositiveNumber(String string) {
        StatusInfo statusInfo = new StatusInfo(this.getPluginId());
        if (string.length() == 0) {
            statusInfo.setError(PrefMessages.Pre_empty_input);
        } else {
            try {
                int n = Integer.parseInt(string);
                if (n < 0) {
                    statusInfo.setError(Message.format(PrefMessages.Pre_invalid_input, string));
                }
            }
            catch (NumberFormatException numberFormatException) {
                statusInfo.setError(Message.format(PrefMessages.Pre_invalid_input, string));
            }
        }
        return statusInfo;
    }

    protected void updateStatus(IStatus iStatus) {
        this.setValid(iStatus == null || iStatus.isOK());
        this.applyToStatusLine(iStatus);
    }

    protected void applyToStatusLine(IStatus iStatus) {
        if (iStatus == null) {
            this.setMessage(null);
            this.setErrorMessage(null);
        } else {
            String string = iStatus.getMessage();
            switch (iStatus.getSeverity()) {
                case 0: {
                    this.setMessage(string, 0);
                    this.setErrorMessage(null);
                    break;
                }
                case 2: {
                    this.setMessage(string, 2);
                    this.setErrorMessage(null);
                    break;
                }
                case 1: {
                    this.setMessage(string, 1);
                    this.setErrorMessage(null);
                    break;
                }
                default: {
                    if (string.length() == 0) {
                        string = null;
                    }
                    this.setMessage(null);
                    this.setErrorMessage(string);
                }
            }
        }
    }
}

