/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ui.internal.dialogfields;

import com.spket.ui.internal.dialogfields.DialogField;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class LayoutUtil {
    public static int getNumberOfColumns(DialogField[] dialogFieldArray) {
        int n = 0;
        for (int i = 0; i < dialogFieldArray.length; ++i) {
            n = Math.max(dialogFieldArray[i].getNumberOfControls(), n);
        }
        return n;
    }

    public static void doDefaultLayout(Composite composite, DialogField[] dialogFieldArray, boolean bl) {
        LayoutUtil.doDefaultLayout(composite, dialogFieldArray, bl, 0, 0);
    }

    public static void doDefaultLayout(Composite composite, DialogField[] dialogFieldArray, boolean bl, int n, int n2) {
        int n3 = LayoutUtil.getNumberOfColumns(dialogFieldArray);
        Control[][] controlArrayArray = new Control[dialogFieldArray.length][];
        for (int i = 0; i < dialogFieldArray.length; ++i) {
            controlArrayArray[i] = dialogFieldArray[i].doFillIntoGrid(composite, n3);
        }
        if (bl) {
            LayoutUtil.modifyLabelSpans(controlArrayArray, --n3);
        }
        GridLayout gridLayout = null;
        gridLayout = composite.getLayout() instanceof GridLayout ? (GridLayout)composite.getLayout() : new GridLayout();
        if (n != -1) {
            gridLayout.marginWidth = n;
        }
        if (n2 != -1) {
            gridLayout.marginHeight = n2;
        }
        gridLayout.numColumns = n3;
        composite.setLayout((Layout)gridLayout);
    }

    private static void modifyLabelSpans(Control[][] controlArray, int n) {
        for (int i = 0; i < controlArray.length; ++i) {
            LayoutUtil.setHorizontalSpan(controlArray[i][0], n);
        }
    }

    public static void setHorizontalSpan(Control control, int n) {
        Object object = control.getLayoutData();
        if (object instanceof GridData) {
            ((GridData)object).horizontalSpan = n;
        } else if (n != 1) {
            GridData gridData = new GridData();
            gridData.horizontalSpan = n;
            control.setLayoutData((Object)gridData);
        }
    }

    public static void setWidthHint(Control control, int n) {
        Object object = control.getLayoutData();
        if (object instanceof GridData) {
            ((GridData)object).widthHint = n;
        }
    }

    public static void setHeightHint(Control control, int n) {
        Object object = control.getLayoutData();
        if (object instanceof GridData) {
            ((GridData)object).heightHint = n;
        }
    }

    public static void setHorizontalIndent(Control control, int n) {
        Object object = control.getLayoutData();
        if (object instanceof GridData) {
            ((GridData)object).horizontalIndent = n;
        }
    }

    public static void setHorizontalGrabbing(Control control) {
        Object object = control.getLayoutData();
        if (object instanceof GridData) {
            ((GridData)object).grabExcessHorizontalSpace = true;
        }
    }
}

