/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ui.internal;

import com.spket.ui.internal.UIPlugin;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public final class License {
    private static final String LICENSE = "spket.lic";
    private static final int PE = 51419;
    private static final byte[] bpn = new byte[]{70, 69, 53, 49, 65, 67, 67, 65, 68, 68, 55, 55, 57, 65, 49, 49, 51, 57, 54, 70, 70, 57, 69, 67, 68, 54, 51, 49, 67, 66, 57, 69, 53, 57, 53, 50, 54, 65, 68, 70, 70, 56, 48, 68, 66, 53, 69, 54, 49, 68, 70, 68, 69, 48, 70, 50, 56, 49, 51, 66, 48, 48, 70, 54, 69, 54, 52, 52, 53, 49, 67, 66, 66, 70, 55, 49, 51, 68, 49, 51, 51, 55, 49, 49, 57, 57, 56, 53, 50, 70, 69, 69, 50, 66, 56, 65, 53, 50, 69, 54, 51, 50, 53, 69, 54, 55, 65, 54, 57, 48, 53, 70, 57, 49, 70, 65, 69, 52, 49, 67, 48, 65, 65, 48, 54, 48, 70, 52, 54, 70, 50, 49, 54, 70, 67, 57, 52, 56, 49, 54, 55, 66, 66, 57, 68, 65, 51, 52, 69, 51, 65, 48, 65, 51, 53, 67, 50, 67, 52, 70};
    private static final String LICENSE_PAGE_ID = "com.spket.ui.preferences";
    private static final byte[] bpd = new byte[]{55, 51, 48, 50, 56, 49, 66, 67, 49, 66, 52, 66, 68, 52, 67, 68, 48, 55, 56, 70, 57, 52, 65, 68, 51, 48, 51, 54, 50, 69, 49, 51, 57, 54, 49, 55, 52, 50, 53, 50, 57, 55, 48, 50, 65, 70, 56, 67, 67, 50, 68, 53, 52, 57, 52, 69, 51, 70, 48, 69, 48, 67, 57, 48, 55, 50, 65, 51, 55, 69, 69, 57, 48, 66, 70, 69, 50, 68, 52, 54, 70, 53, 68, 49, 54, 50, 54, 69, 69, 55, 48, 53, 54, 49, 66, 49};
    private static final byte equalSign = 61;
    private boolean checked;
    private boolean valid;

    static int decodeDigit(byte by) {
        char c = (char)by;
        if (c <= 'Z' && c >= 'A') {
            return c - 65;
        }
        if (c <= 'z' && c >= 'a') {
            return c - 97 + 26;
        }
        if (c <= '9' && c >= '0') {
            return c - 48 + 52;
        }
        switch (c) {
            case '+': {
                return 62;
            }
            case '/': {
                return 63;
            }
        }
        throw new IllegalArgumentException("Invalid char to decode: " + by);
    }

    private static byte[] decode(byte[] byArray) {
        int n;
        if (byArray.length == 0) {
            return byArray;
        }
        int n2 = byArray.length - 1;
        while (byArray[n2] == 61) {
            --n2;
        }
        int n3 = byArray.length - 1 - n2;
        int n4 = byArray.length * 6 / 8 - n3;
        byte[] byArray2 = new byte[n4];
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = (n2 + 1) / 4;
        for (n = 0; n < n8; ++n) {
            int n9;
            n7 = 0;
            for (n9 = 0; n9 < 4; ++n9) {
                n7 = n7 << 6 | License.decodeDigit(byArray[n5++]);
            }
            for (n9 = n6 + 2; n9 >= n6; --n9) {
                byArray2[n9] = (byte)(n7 & 0xFF);
                n7 >>>= 8;
            }
            n6 += 3;
        }
        switch (n3) {
            case 1: {
                n7 = 0;
                for (n = 0; n < 3; ++n) {
                    n7 = n7 << 6 | License.decodeDigit(byArray[n5++]);
                }
                n7 <<= 6;
                n7 >>>= 8;
                for (n = n6 + 1; n >= n6; --n) {
                    byArray2[n] = (byte)(n7 & 0xFF);
                    n7 >>>= 8;
                }
                break;
            }
            case 2: {
                n7 = 0;
                for (n = 0; n < 2; ++n) {
                    n7 = n7 << 6 | License.decodeDigit(byArray[n5++]);
                }
                n7 <<= 6;
                n7 <<= 6;
                n7 >>>= 8;
                byArray2[n6] = (byte)((n7 >>>= 8) & 0xFF);
            }
        }
        return byArray2;
    }

    public void promptForLicense(Shell shell) {
        PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)LICENSE_PAGE_ID, (String[])new String[]{LICENSE_PAGE_ID}, null).open();
    }

    public boolean isValid() {
        if (!this.checked) {
            this.checked = true;
            File file = this.getLicenseFile();
            if (file != null && file.exists() && file.isFile()) {
                this.valid = this.check(file);
            }
        }
        return this.valid;
    }

    private boolean check(byte[] byArray) {
        if (byArray != null) {
            String string;
            byte[] byArray2;
            BigInteger bigInteger = new BigInteger(byArray);
            byArray = new byte[bpn.length + bpd.length];
            System.arraycopy(bpn, 0, byArray, 0, bpn.length);
            System.arraycopy(bpd, 0, byArray, bpn.length, bpd.length);
            BigInteger bigInteger2 = new BigInteger(new String(byArray), 16);
            BigInteger bigInteger3 = BigInteger.valueOf(51419L);
            BigInteger bigInteger4 = bigInteger.modPow(bigInteger3, bigInteger2);
            if (bigInteger4 != null && (byArray2 = bigInteger4.toByteArray()) != null && byArray2.length >= 39 && (string = new String(byArray2)).length() >= 39 && string.charAt(0) == '1') {
                for (int i = 1; i < 39; ++i) {
                    char c = string.charAt(i);
                    if (!(i == 17 || i == 20 ? c != '/' : c < '0' || c > '9')) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private byte[] getKeyFromText(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() != 172 && (string = string.trim()).length() != 172) {
            return null;
        }
        return License.decode(string.getBytes());
    }

    public boolean check(String string) {
        return this.check(this.getKeyFromText(string));
    }

    public boolean check(File file) {
        try {
            byte[] byArray = this.getLicenseData(file);
            return this.check(byArray);
        }
        catch (IOException iOException) {
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void save(byte[] byArray, File file) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            ((OutputStream)fileOutputStream).write(byArray, 0, byArray.length);
            Object var5_4 = null;
            if (fileOutputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (fileOutputStream == null) throw throwable;
            try {
                ((OutputStream)fileOutputStream).close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            ((OutputStream)fileOutputStream).close();
            return;
        }
        catch (IOException iOException) {}
    }

    public void saveLicense(String string) throws IOException {
        byte[] byArray = this.getKeyFromText(string);
        if (this.check(byArray)) {
            File file = this.getLicenseFile();
            this.save(byArray, file);
            this.valid = true;
            this.checked = true;
        }
    }

    public void saveLicense(File file) throws IOException {
        File file2 = this.getLicenseFile();
        if (file.equals(file2)) {
            return;
        }
        byte[] byArray = this.getLicenseData(file);
        if (this.check(byArray)) {
            this.save(byArray, file2);
            this.valid = true;
            this.checked = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected byte[] getLicenseData(File file) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream;
        block7: {
            FileInputStream fileInputStream = null;
            if (!file.exists()) return null;
            if (!file.isFile()) return null;
            byte[] byArray = new byte[256];
            byteArrayOutputStream = new ByteArrayOutputStream(256);
            try {
                int n;
                fileInputStream = new FileInputStream(file);
                while ((n = ((InputStream)fileInputStream).read(byArray)) != -1) {
                    if (n > 0) {
                        byteArrayOutputStream.write(byArray, 0, n);
                    }
                    if (byteArrayOutputStream.size() <= 8192) continue;
                    throw new IOException();
                }
                Object var7_6 = null;
                if (fileInputStream == null) break block7;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (fileInputStream == null) throw throwable;
                try {
                    ((InputStream)fileInputStream).close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            ((InputStream)fileInputStream).close();
        }
        if (byteArrayOutputStream.size() <= 0) return null;
        return byteArrayOutputStream.toByteArray();
    }

    protected File getLicenseFile() {
        File file;
        String string = System.getProperty("user.home");
        if (string != null && (file = new File(string)).exists() && file.isDirectory()) {
            return new File(file, LICENSE);
        }
        return UIPlugin.getDefault().getStateLocation().append(LICENSE).toFile();
    }
}

