/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ui.editors;

import com.spket.ui.editors.PlainTextEditor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;

public class DNDSupport {
    private PlainTextEditor fEditor;
    private ISourceViewer fViewer;
    private DragSource fDragSource;
    private Object fTextDragAndDropToken;
    private DropTargetListener dropListener = new DropTargetListener(){
        private Point fSelection;

        public void dragEnter(DropTargetEvent dropTargetEvent) {
            DNDSupport.this.fTextDragAndDropToken = null;
            if (DNDSupport.this.fDragSource != null) {
                StyledText styledText = DNDSupport.this.fViewer.getTextWidget();
                this.fSelection = styledText.getSelection();
            }
        }

        public void dragOperationChanged(DropTargetEvent dropTargetEvent) {
        }

        public void dragOver(DropTargetEvent dropTargetEvent) {
            if (dropTargetEvent.detail != 0) {
                dropTargetEvent.feedback |= 8;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void drop(DropTargetEvent dropTargetEvent) {
            try {
                DNDSupport.this.doDrop(dropTargetEvent, this.fSelection);
            }
            catch (RuntimeException runtimeException) {
                dropTargetEvent.detail = 0;
            }
            finally {
                DNDSupport.this.fTextDragAndDropToken = null;
            }
        }

        public void dragLeave(DropTargetEvent dropTargetEvent) {
        }

        public void dropAccept(DropTargetEvent dropTargetEvent) {
        }
    };
    static /* synthetic */ Class class$org$eclipse$jface$text$IRewriteTarget;

    protected static final int widgetOffset2ModelOffset(ISourceViewer iSourceViewer, int n) {
        if (iSourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 iTextViewerExtension5 = (ITextViewerExtension5)iSourceViewer;
            return iTextViewerExtension5.widgetOffset2ModelOffset(n);
        }
        return n + iSourceViewer.getVisibleRegion().getOffset();
    }

    public DNDSupport(PlainTextEditor plainTextEditor) {
        this.fEditor = plainTextEditor;
    }

    public void install(boolean bl) {
        Transfer[] transferArray = new Transfer[]{TextTransfer.getInstance(), LocalSelectionTransfer.getTransfer(), com.spket.util.LocalSelectionTransfer.getInstance()};
        this.fViewer = this.fEditor.getViewer();
        StyledText styledText = this.fViewer.getTextWidget();
        int n = 23;
        DropTarget dropTarget = new DropTarget((Control)styledText, n);
        dropTarget.setTransfer(transferArray);
        dropTarget.addDropListener(this.dropListener);
        if (bl) {
            this.setTextDragSupport(bl);
        }
    }

    public void setTextDragSupport(boolean bl) {
        if (bl) {
            if (this.fDragSource != null) {
                return;
            }
            StyledText styledText = this.fViewer.getTextWidget();
            this.fDragSource = new DragSource((Control)styledText, 3);
            this.fDragSource.setTransfer(new Transfer[]{TextTransfer.getInstance()});
            this.fDragSource.addDragListener(new DragSourceListener(){
                private Point fSelection;
                private String fSelectedText;

                public void dragStart(DragSourceEvent dragSourceEvent) {
                    DNDSupport.this.fTextDragAndDropToken = null;
                    StyledText styledText = DNDSupport.this.fViewer.getTextWidget();
                    ISelectionProvider iSelectionProvider = DNDSupport.this.fViewer.getSelectionProvider();
                    try {
                        this.fSelection = styledText.getSelection();
                        int n = styledText.getOffsetAtLocation(new Point(dragSourceEvent.x, dragSourceEvent.y));
                        Point point = styledText.getLocationAtOffset(n);
                        if (point.x > dragSourceEvent.x) {
                            --n;
                        }
                        dragSourceEvent.doit = n > this.fSelection.x && n < this.fSelection.y;
                        ISelection iSelection = iSelectionProvider.getSelection();
                        this.fSelectedText = iSelection instanceof ITextSelection ? ((ITextSelection)iSelection).getText() : styledText.getSelectionText();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        dragSourceEvent.doit = false;
                    }
                }

                public void dragSetData(DragSourceEvent dragSourceEvent) {
                    dragSourceEvent.data = this.fSelectedText;
                    DNDSupport.this.fTextDragAndDropToken = this;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void dragFinished(DragSourceEvent dragSourceEvent) {
                    StyledText styledText = DNDSupport.this.fViewer.getTextWidget();
                    try {
                        if ((dragSourceEvent.detail == 2 || dragSourceEvent.detail == 16) && DNDSupport.this.validateEditorInputState()) {
                            IRewriteTarget iRewriteTarget;
                            Point point = styledText.getSelection();
                            int n = this.fSelection.y - this.fSelection.x;
                            int n2 = 0;
                            if (point.x < this.fSelection.x) {
                                n2 = n;
                            }
                            styledText.replaceTextRange(this.fSelection.x + n2, n, "");
                            if (DNDSupport.this.fTextDragAndDropToken == null && (iRewriteTarget = (IRewriteTarget)DNDSupport.this.getAdapter(class$org$eclipse$jface$text$IRewriteTarget == null ? (class$org$eclipse$jface$text$IRewriteTarget = DNDSupport.class$("org.eclipse.jface.text.IRewriteTarget")) : class$org$eclipse$jface$text$IRewriteTarget)) != null) {
                                iRewriteTarget.endCompoundChange();
                            }
                        }
                    }
                    finally {
                        DNDSupport.this.fTextDragAndDropToken = null;
                    }
                }
            });
        } else if (this.fDragSource != null) {
            this.fDragSource.dispose();
            this.fDragSource = null;
        }
    }

    protected Object getAdapter(Class clazz) {
        return this.fEditor.getAdapter(clazz);
    }

    protected boolean validateEditorInputState() {
        if (this.fEditor == null) {
            return false;
        }
        return this.fEditor.validateEditorInputState();
    }

    protected ISourceViewer getViewer() {
        return this.fViewer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDrop(DropTargetEvent dropTargetEvent, Point point) {
        Object object;
        if (dropTargetEvent.detail == 0) {
            return;
        }
        if (!this.validateEditorInputState()) {
            dropTargetEvent.detail = 0;
            return;
        }
        StyledText styledText = this.fViewer.getTextWidget();
        IDocument iDocument = this.fViewer.getDocument();
        if (this.fTextDragAndDropToken == null && (object = this.fEditor.getDropAction((ITextViewer)this.fViewer, dropTargetEvent)) != null) {
            try {
                int n;
                object.apply((ITextViewer)this.fViewer);
                int n2 = object.getSelectionOffset();
                if (n2 >= 0 && (n = object.getSelectionLength()) >= 0) {
                    styledText.setFocus();
                    this.fViewer.revealRange(n2, n);
                    this.fViewer.setSelectedRange(n2, n);
                }
            }
            finally {
                dropTargetEvent.detail = 0;
            }
            return;
        }
        if (TextTransfer.getInstance().isSupportedType(dropTargetEvent.currentDataType)) {
            Point point2;
            if (this.fTextDragAndDropToken != null) {
                int n = styledText.getCaretOffset();
                if (point.x <= n && n <= point.y) {
                    dropTargetEvent.detail = 0;
                    return;
                }
                if ((dropTargetEvent.detail == 2 || dropTargetEvent.detail == 16) && (point2 = (IRewriteTarget)this.getAdapter(class$org$eclipse$jface$text$IRewriteTarget == null ? (class$org$eclipse$jface$text$IRewriteTarget = DNDSupport.class$("org.eclipse.jface.text.IRewriteTarget")) : class$org$eclipse$jface$text$IRewriteTarget)) != null) {
                    point2.beginCompoundChange();
                }
            }
            object = (String)dropTargetEvent.data;
            point2 = styledText.getSelection();
            try {
                int n = DNDSupport.widgetOffset2ModelOffset(this.fViewer, point2.x);
                iDocument.replace(n, 0, (String)object);
            }
            catch (BadLocationException badLocationException) {
                return;
            }
            if (this.fTextDragAndDropToken == null) {
                styledText.setFocus();
            }
            styledText.setSelectionRange(point2.x, ((String)object).length());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

