/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ui.actions;

import com.spket.ui.editors.PlainTextEditor;
import com.spket.ui.internal.UIPlugin;
import com.spket.util.Debug;
import com.spket.util.StringUtils;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.IUpdate;

public class TabsAction
extends Action
implements IUpdate {
    private PlainTextEditor editor;

    public TabsAction(PlainTextEditor plainTextEditor) {
        this.editor = plainTextEditor;
    }

    public void run() {
        if (this.editor == null) {
            return;
        }
        ISourceViewer iSourceViewer = this.editor.getViewer();
        if (iSourceViewer == null) {
            return;
        }
        IDocument iDocument = iSourceViewer.getDocument();
        if (iDocument == null || iDocument.getLength() == 0) {
            return;
        }
        StyledText styledText = iSourceViewer.getTextWidget();
        if (styledText == null || !styledText.isEnabled()) {
            return;
        }
        int n = 0;
        int n2 = iDocument.getLength();
        Point point = iSourceViewer.getSelectedRange();
        if (point != null && point.y > 0) {
            n = point.x;
            n2 = point.y;
        }
        if (n >= 0 && n2 > 0) {
            boolean bl = false;
            try {
                bl = this.format(iDocument, n, n2, point);
            }
            catch (MalformedTreeException malformedTreeException) {
                Debug.error((Throwable)malformedTreeException);
            }
            catch (BadLocationException badLocationException) {
                Debug.error((Throwable)badLocationException);
            }
            if (bl && point != null && point.x >= 0 && point.y >= 0) {
                iSourceViewer.setSelectedRange(point.x, point.y);
                styledText.showSelection();
            }
        }
    }

    public void update() {
        ISourceViewer iSourceViewer;
        boolean bl = false;
        if (this.editor != null && (iSourceViewer = this.editor.getViewer()) != null && iSourceViewer.getDocument() != null) {
            StyledText styledText = iSourceViewer.getTextWidget();
            bl = styledText != null && styledText.isEnabled();
        }
        this.setEnabled(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected boolean format(IDocument var1_1, int var2_2, int var3_3, Point var4_4) throws BadLocationException {
        block36: {
            block35: {
                var6_5 = 0;
                var7_6 = var2_2;
                var8_7 = 0;
                var9_8 = null;
                var10_9 = new ArrayList<Tab>();
                var11_10 = this.getTabSize();
                var12_11 = -1;
                var13_12 = -2147483648;
                var14_13 = var1_1.get(var2_2, var3_3);
                if (var2_2 > 0) {
                    var15_14 = var1_1.getLineInformationOfOffset(var2_2);
                    for (var16_17 = var15_14.getOffset(); var16_17 < var2_2; ++var16_17) {
                        var17_19 = var1_1.getChar(var16_17);
                        if (var17_19 == '\t') {
                            if (var11_10 <= 0) continue;
                            var8_7 += var11_10 - var8_7 % var11_10;
                            continue;
                        }
                        ++var8_7;
                    }
                }
                if (var4_4 != null) {
                    var4_4.y += var4_4.x;
                }
                block12: for (var15_15 = 0; var15_15 < var3_3; ++var15_15) {
                    var16_17 = var14_13.charAt(var15_15);
                    switch (var16_17) {
                        case 9: {
                            var5_21 = var11_10;
                            if (var13_12 + 1 == var15_15) {
                                ++var9_8.length;
                            } else {
                                if (var12_11 == -1) {
                                    var12_11 = var15_15;
                                }
                                var9_8 = new Tab();
                                var10_9.add(var9_8);
                                var9_8.length = 1;
                                var9_8.offset = var15_15;
                                if (var11_10 > 0) {
                                    var5_21 = var11_10 - var8_7 % var11_10;
                                }
                            }
                            var13_12 = var15_15;
                            var8_7 += var5_21;
                            var9_8.spaces += var5_21;
                            if (var6_5 < var9_8.spaces) {
                                var6_5 = var9_8.spaces;
                            }
                            if (var4_4 == null) continue block12;
                            if (var4_4.x > var7_6) {
                                var4_4.x += var5_21 - 1;
                            }
                            if (var4_4.y > var7_6) {
                                var4_4.y += var5_21 - 1;
                            }
                            var7_6 += var5_21;
                            continue block12;
                        }
                        case 10: {
                            ++var7_6;
                            var8_7 = 0;
                            continue block12;
                        }
                        default: {
                            ++var7_6;
                            ++var8_7;
                        }
                    }
                }
                if (var4_4 != null) {
                    var4_4.y -= var4_4.x;
                }
                if (var10_9.size() <= 0) break block36;
                var15_16 = new char[var6_5];
                for (var16_17 = 0; var16_17 < var6_5; ++var16_17) {
                    var15_16[var16_17] = 32;
                }
                var16_18 = new MultiTextEdit(var12_11 + var2_2, var13_12 - var12_11 + 1);
                var17_20 = var10_9.iterator();
                while (var17_20.hasNext()) {
                    var9_8 = (Tab)var17_20.next();
                    if (var11_10 > 0) {
                        var16_18.addChild((TextEdit)new ReplaceEdit(var9_8.offset + var2_2, var9_8.length, new String(var15_16, 0, var9_8.spaces)));
                        continue;
                    }
                    var16_18.addChild((TextEdit)new ReplaceEdit(var9_8.offset + var2_2, var9_8.length, ""));
                }
                var18_22 = null;
                if (var10_9.size() > 20) {
                    var18_22 = TextUtilities.removeDocumentPartitioners((IDocument)var1_1);
                }
                var19_23 = null;
                if (var10_9.size() > 1 && var1_1 instanceof IDocumentExtension4) {
                    var20_24 = (IDocumentExtension4)var1_1;
                    var19_23 = var20_24.startRewriteSession(DocumentRewriteSessionType.SEQUENTIAL);
                }
                try {
                    var16_18.apply(var1_1);
                    var22_25 = null;
                    if (var10_9.size() <= 1) break block35;
                }
                catch (Throwable var21_31) {
                    var22_26 = null;
                    if (var10_9.size() > 1) {
                        try {
                            if (!(var1_1 instanceof IDocumentExtension4)) ** GOTO lbl103
                            var23_28 = (IDocumentExtension4)var1_1;
                            var23_28.stopRewriteSession(var19_23);
                        }
                        finally {
                            if (var18_22 != null) {
                                TextUtilities.addDocumentPartitioners((IDocument)var1_1, (Map)var18_22);
                            }
                        }
                    } else if (var18_22 != null) {
                        TextUtilities.addDocumentPartitioners((IDocument)var1_1, (Map)var18_22);
                    }
lbl103:
                    // 5 sources

                    throw var21_31;
                }
                try {
                    if (!(var1_1 instanceof IDocumentExtension4)) ** GOTO lbl117
                    var23_27 = (IDocumentExtension4)var1_1;
                    var23_27.stopRewriteSession(var19_23);
                }
                finally {
                    if (var18_22 != null) {
                        TextUtilities.addDocumentPartitioners((IDocument)var1_1, (Map)var18_22);
                    }
                }
            }
            if (var18_22 != null) {
                TextUtilities.addDocumentPartitioners((IDocument)var1_1, (Map)var18_22);
            }
lbl117:
            // 5 sources

            var10_9.clear();
            return true;
        }
        return false;
    }

    protected int getTabSize() {
        int n = -1;
        IPreferenceStore iPreferenceStore = UIPlugin.getDefault().getPreferenceStore();
        boolean bl = iPreferenceStore.getBoolean("tab.default");
        if (!bl) {
            n = StringUtils.toInt((String)iPreferenceStore.getString("tab.size"), (int)-1);
        }
        if (n < 0) {
            iPreferenceStore = EditorsUI.getPreferenceStore();
            n = iPreferenceStore.getInt("tabWidth");
        }
        return n;
    }

    private static class Tab {
        int offset;
        int length;
        int spaces;

        private Tab() {
        }
    }
}

